function onLoad() {
  load("beginner");
  load("intermediate");
  load("expert");
  window.screenX += 24;
  window.screenY += 45;
  setTimeout(ensureSizeAndPosition, 0);
}

function ensureSizeAndPosition() {
  var windowX = window.screenX;
  if (windowX < screen.availLeft)
    windowX = screen.availLeft;
  else {
    var availX = screen.availLeft + screen.availWidth - window.outerWidth;
    if (windowX > availX)
      windowX = availX;
  }
  var windowY = window.screenY;
  if (windowY < screen.availTop)
    windowY = screen.availTop;
  else {
    var availY = screen.availTop + screen.availHeight - window.outerHeight;
    if (windowY > availY)
      windowY = availY;
  }
  window.moveTo(windowX, windowY);
}

function load(level) {
  var documentElement = window.opener.document.documentElement;
  var row = document.getElementById(level);
  var time = row.childNodes[1];
  time.setAttribute("value", time.getAttribute("value").replace(/\d+/, documentElement.getAttribute(level)));
  var name = documentElement.getAttribute(level + "name");
  if (name)
    row.lastChild.setAttribute("value", name);
}

function resetScores(anonymous) {
  reset("beginner", anonymous);
  reset("intermediate", anonymous);
  reset("expert", anonymous);
}

function reset(level, anonymous) {
  var documentElement = window.opener.document.documentElement;
  documentElement.setAttribute(level, 999);
  documentElement.setAttribute(level + "name", "");
  var row = document.getElementById(level);
  var time = row.childNodes[1];
  time.setAttribute("value", time.getAttribute("value").replace(/\d+/, 999));
  row.lastChild.setAttribute("value", anonymous);
}
