#! /usr/bin/perl -w

# ****** Generate Mozilla Application Stubs ******
# ****** Copyright 2003 Jim Massey - all rights reserved ******

use Cwd;
use CGI;

$cgi_query = new CGI;

$appName = $cgi_query->param('appName');
$appNameString = $cgi_query->param('appString');
$appNameAuthor = $cgi_query->param('appAuthor');
#$appName = "mozapp";
#$appNameString = "Jims Test Moz-app";
#$appNameAuthor = "James Massey";

$appName = lc $appName;

$appNameStringOriginal = "Mozilla Application Stub";
$appDownloadUri = "http://stlouis-shopper.com/~massey/mozappgen/apps/";
$savePath = "/home/massey/public_html/mozappgen/apps/";
$generaterStyleSheet = "http://stlouis-shopper.com/~massey/mozappgen/style1.css";

# ****** Generate Application Tree ******
# ***************************************
mkdir "$appName", 0755;
mkdir "$appName/content", 0755;
mkdir "$appName/skin", 0755;
mkdir "$appName/skin/default", 0755;
mkdir "$appName/locale", 0755;
mkdir "$appName/locale/en-US", 0755;
mkdir "$appName/moz-appstubs", 0755;


sub build_moz_app() {
# ****** Generate Main directory files ******
# *******************************************

print $cgi_query->header();
print $cgi_query->start_html(-title=>"Mozilla App Download",
			     -style=>{'src'=>"$generaterStyleSheet"});

open (CONTENT, "> $appName/README.txt");
open (STUBRDF, "< ./appStubs/README.txt") || die print "$!";
common_fix_files(); 

open (CONTENT, "> $appName/mozilla-rebuild-databases.pl");
open (STUBRDF, "< ./appStubs/mozilla-rebuild-databases.pl") || die print "$!";
common_fix_files();

open (CONTENT, "> $appName/rebuild-databases.sh");
open (STUBRDF, "< ./appStubs/rebuild-databases.sh") || die print "$!";
common_fix_files();

open (CONTENT, "> $appName/remove-lock.sh");
open (STUBRDF, "< ./appStubs/remove-lock.sh") || die print "$!";
common_fix_files();

open (CONTENT, "> $appName/install.js");
open (STUBRDF, "< ./appStubs/install.js") || die print "$!";
#common_fix_files();
fix_appname_string();

open (CONTENT, "> $appName/installed-chrome.txt");
open (STUBRDF, "< ./appStubs/installed-chrome.txt") || die print "$!";
common_fix_files();

open (CONTENT, "> $appName/InstallMaker.pl");
open (STUBRDF, "< ./appStubs/InstallMaker.pl") || die print "$!";
chmod (0755, "$appName/InstallMaker.pl");
common_fix_files();

# ***** Generate Content directory files *****
# ********************************************
# *** contents.rdf ***
open (CONTENT, "> $appName/content/contents.rdf");
open (STUBRDF, "< ./appStubs/content/contents.rdf") || die print "$!";
#common_fix_files();
fix_appname_string();

# *** appName.xul ***
open (CONTENT, "> $appName/content/$appName.xul");
open (STUBRDF, "< ./appStubs/content/appstubs.xul") || die print "$!";
common_fix_files();

open (CONTENT, "> $appName/content/quit-btnOverlay.xul");
open (STUBRDF, "< ./appStubs/content/quit-btnOverlay.xul") || die print "$!";
common_fix_files();

open (CONTENT, "> $appName/content/sizeOverlay.xul");
open (STUBRDF, "< ./appStubs/content/sizeOverlay.xul") || die print "$!";
common_fix_files();

open (CONTENT, "> $appName/content/$appName.js");
open (STUBRDF, "< ./appStubs/content/appstubs.js") || die print "$!";
common_fix_files();

# ****** Generate Locale directory files ******
# *********************************************
# *** en-US contents.rdf ***
open (CONTENT, "> $appName/locale/en-US/contents.rdf");
open (STUBRDF, "< ./appStubs/locale/en-US/contents.rdf") || die print "$!";
#common_fix_files();
fix_appname_string();

open (CONTENT, "> $appName/locale/en-US/$appName.dtd");
open (STUBRDF, "< ./appStubs/locale/en-US/appstubs.dtd") || die print "$!";
common_fix_files();

my $properties_file = $appName . "Default";
open (CONTENT, "> $appName/locale/en-US/$properties_file.properties");
open (STUBRDF, "< ./appStubs/locale/en-US/appstubsDefault.properties") || die print "$!";
common_fix_files();

# ****** Generate Skin directory files ******
# *******************************************

open (CONTENT, "> $appName/skin/default/contents.rdf");
open (STUBRDF, "< ./appStubs/skin/default/contents.rdf") || die print "$!";
#common_fix_files();
fix_appname_string();

open (CONTENT, "> $appName/skin/default/$appName.css");
open (STUBRDF, "< ./appStubs/skin/default/appstubs.css") || die print "$!";
common_fix_files();

# ****** Generate moz-appstubs directory files ******
# ***************************************************

open (CONTENT, "> $appName/moz-appstubs/appStubInstall.html");
open (STUBRDF, "< ./appStubs/moz-appstubs/appStubInstall.html") || die print "$!";
common_fix_files_nocase();

open (CONTENT, "> $appName/moz-appstubs/style1.css");
open (STUBRDF, "< ./appStubs/moz-appstubs/style1.css") || die print "$!";
common_fix_files_nocase();

add_gtoolbar();
add_xbuttons();

system ("./$appName/InstallMaker.pl");
system ("cp $appName/$appName.xpi $appName/moz-appstubs/$appName.xpi");
system ("zip -rq $appName.zip  $appName");
system ("cp $appName.zip $savePath");
system ("rm -r ./$appName");
unlink "./$appName.zip";


print ("<div class='neat-li'>\n");
print $cgi_query->p("<h2>You Had Success in generating $appName!</h2>\n");
print ("<br>Here is a link to download your mozilla application stub:<br>\n");
print $cgi_query->p("<a href=" . $appDownloadUri . $appName . ".zip>$appName Zip File</a>\n");
print ("<p>A complete mozilla application has been generated from the simple information you provided. There is an xpi in the application's root directory that is installable, just to prove that you have a complete mozilla application stub that is ready for you to build your application from.</p>\n");
print ("</div>\n");
print $cgi_query->end_html;


}

# ***** Common fix files routine *****
sub common_fix_files() {
    while (<STUBRDF>) {
	my $newLine = $_;
	$newLine =~ s/appstubs/$appName/g;
	print CONTENT $newLine;
	#print $newLine;
    }
}

# ***** Common fix files routine case insensitive *****
sub common_fix_files_nocase() {
    while (<STUBRDF>) {
	my $newLine = $_;
	$newLine =~ s/appstubs/$appName/gi;
	print CONTENT $newLine;
	#print $newLine;
    }
}

# ***** Fix Appname String routine case insensitive *****
sub fix_appname_string() {
    while (<STUBRDF>) {
	my $newLine = $_;
	$newLine =~ s/"Mozilla Appstub"/"$appNameAuthor"/i;
	$newLine =~ s/"AppStubs application stub"/"$appNameString"/;
	$newLine =~ s/$appNameStringOriginal/$appNameString/i;
	$newLine =~ s/appstubs/$appName/gi;
	print CONTENT $newLine;
	#print $newLine;
    }
}


sub add_gtoolbar {
    system("cp -r ./appStubs/content/gtoolbar $appName/content");

}

sub add_xbuttons {
    system("cp -r ./appStubs/content/xbutton $appName/content");

}

# ****** Start the appgen ******
&build_moz_app();

