var cmd_color, cmd_graphics;
var vbox_parent, vbox_field, digits_left, digits_time, feedback_button, down;
var row = 0, col = 0, push = 0, flags = 0, blanks = 0;
var start_time = null, stop_time = null, game = "new";
var best, rows, cols, mines, sound, marks;
var grid;
var beginner = {rows: 8, cols: 8, mines: 10};
var intermediate = {rows: 16, cols: 16, mines: 40};
var expert = {rows: 16, cols: 30, mines: 99};
var sound_svc, won_uri, lost_uri;

function updateFields(pushed) {
  for (var l = Math.max(0, row - push + 1); l < Math.min(rows, row + push); l++)
    for (var m = Math.max(0, col - push + 1); m < Math.min(cols, col + push); m++)
      grid[l][m].setPushed(pushed);
}

function randInt(max) {
  return parseInt(max * Math.random());
}

function tick() {
  if (start_time) {
    var now = stop_time || new Date();
    var elapsed = now - start_time;
    var seconds = digits_time.value = parseInt(elapsed / 1000);
    if (!stop_time) setTimeout(tick, (seconds + 1) * 1000 - elapsed);
  }
}

function startGame(row, col) {
  var cell;
  for (var k = 0; k < mines; k++) {
    do {
      var i = randInt(rows);
      var j = randInt(cols);
    } while ((i == row && j == col) || (cell = grid[i][j]).value == 9);
    cell.value = 9;
    for (var l = Math.max(0, i - 1); l < Math.min(rows, i + 2); l++) {
      for (var m = Math.max(0, j - 1); m < Math.min(cols, j + 2); m++) {
        cell = grid[l][m];
        if (cell.value != 9)
          cell.value++;
      }
    }
  }
  game = "play";
  start_time = new Date();
  setTimeout(tick, 1000);
}

function revealField(i, j) {
  var cell = grid[i][j];
  if (!cell.show || cell.show == "mark") {
    cell.setShow("true");
    if (cell.value == 9) {
      stop_time = new Date();
      game = "lost";
      feedback_button.className = "lost";
      setTimeout(checkLost, 100);
      if (sound && sound_svc)
        sound_svc.play(lost_uri);
    } else {
      if (cell.value == 0) {
        for (var l = Math.max(0, i - 1); l < Math.min(rows, i + 2); l++)
          for (var m = Math.max(0, j - 1); m < Math.min(cols, j + 2); m++)
            revealField(l, m);
      }
      if (--blanks == 0) {
        stop_time = new Date();
        game = "won";
        feedback_button.className = "won";
        flags = mines;
        digits_left.value = 0;
        setTimeout(checkwon, 100);
        if (sound && sound_svc)
          sound_svc.play(won_uri);
      }
    }
  }
}

function checkLost() {
  for (var i = 0; i < rows; i++)
    for (var j = 0; j < cols; j++)
      grid[i][j].lost();
}

function checkwon() {
  for (var i = 0; i < rows; i++)
    for (var j = 0; j < cols; j++)
      grid[i][j].won();
  setTimeout(checkTime, 100);
}

function checkTime() {
  var elapsed = stop_time - start_time;
  var seconds = parseInt(elapsed / 1000);
  if (seconds < best) {
    best = seconds;
    window.openDialog("fastest.xul", "_blank", "chrome,close,modal");
    window.openDialog("best.xul", "_blank", "chrome,close,modal");
  }
}

function bestTimes() {
  window.openDialog("best.xul", "_blank", "chrome,close,modal");
}

function restart() {
  feedback_button.className = "down";
  setTimeout(newGame, 100);
}

function newGame() {
  down = stop_time = start_time = null;
  game = "new";
  digits_time.value = 0;
  flags = 0;
  blanks = rows * cols - mines;
  digits_left.value = mines;
  for (var i = 0; i < rows; i++)
    for (var j = 0; j < cols; j++)
      grid[i][j].reset();
  feedback_button.className = null;
}

function toggleColor() {
  if (cmd_color.getAttribute("checked") == "false") {
    cmd_color.setAttribute("checked", "true");
    cmd_graphics.setAttribute("disabled", "false");
  } else {
    cmd_color.setAttribute("checked", "false");
    cmd_graphics.setAttribute("disabled", "true");
  }
}

function toggleGraphics() {
  if (vbox_field.getAttribute("graphics") == "field") {
    vbox_field.setAttribute("graphics", "tield");
    cmd_graphics.setAttribute("checked", "true");
  } else {
    vbox_field.setAttribute("graphics", "field");
    cmd_graphics.setAttribute("checked", "false");
  }
}

function onLoad() {
  if ("@mozilla.org/sound;1" in Components.classes) try {
    sound_svc = Components.classes["@mozilla.org/sound;1"].getService(Components.interfaces.nsISound);
    document.getElementById("cmd_sound").removeAttribute("disabled");
    if ("init" in sound_svc)
      sound_svc.init();
  } catch (e) {
  }
  setHelpFileURI("chrome://xulmine/locale/help.rdf");
  var uri = Components.classes["@mozilla.org/network/standard-url;1"];
  won_uri = uri.createInstance(Components.interfaces.nsIURI);
  won_uri.spec = "chrome://xulmine/content/won.wav";
  lost_uri = uri.createInstance(Components.interfaces.nsIURI);
  lost_uri.spec = "chrome://xulmine/content/lost.wav";
  cmd_color = document.getElementById("cmd_color");
  cmd_graphics = document.getElementById("cmd_graphics");
  vbox_parent = document.getElementById("parent");
  vbox_field = document.getElementById("field");
  digits_left = document.getElementById("left");
  digits_time = document.getElementById("time");
  feedback_button = document.getElementById("button");
  marks = document.getElementById("cmd_marks").getAttribute("checked") == "true";
  sound = document.getElementById("cmd_sound").getAttribute("checked") == "true";
  window.custom = {
    rows: document.documentElement.getAttribute("rows"),
    cols: document.documentElement.getAttribute("cols"),
    mines: document.documentElement.getAttribute("mines"),
    best: 0
  }
  window.beginner.best = document.documentElement.getAttribute("beginner");
  window.beginner.name = document.documentElement.getAttribute("beginnername");
  window.intermediate.best = document.documentElement.getAttribute("intermediate");
  window.intermediate.name = document.documentElement.getAttribute("intermediatename");
  window.expert.best = document.documentElement.getAttribute("expert");
  window.expert.name = document.documentElement.getAttribute("expertname");
  startLevel(document.documentElement.getAttribute("level"));
}

function setLevel(element) {
  var level = document.documentElement.getAttribute("level");
  document.getElementById(level).removeAttribute("checked");
  document.documentElement.setAttribute("level", element.id);
  startLevel(element.id);
}

function setCustom() {
  window.openDialog("custom.xul", "_blank", "chrome,close,modal");
  var level = document.documentElement.getAttribute("level");
  document.getElementById(level).removeAttribute("checked");
  document.documentElement.setAttribute("level", "custom");
  startLevel("custom");
}

function startLevel(level) {
  window.level = level;
  document.getElementById(level).setAttribute("checked", "true");
  level = window[level];
  rows = level.rows;
  cols = level.cols;
  mines = level.mines;
  best = level.best;
  document.documentElement.setAttribute("rows", rows);
  document.documentElement.setAttribute("cols", cols);
  document.documentElement.setAttribute("mines", mines);
  grid = new Array(rows);
  vbox_parent.removeChild(vbox_field);
  var hbox = vbox_field.firstChild;
  while (hbox.nextSibling)
    vbox_field.removeChild(vbox_field.lastChild);
  var cell = hbox.firstChild;
  while (cell.nextSibling)
    hbox.removeChild(hbox.lastChild);
  for (var j = 1; j < cols; j++) {
    cell = cell.cloneNode(false);
    cell.setAttribute("col", j);
    hbox.appendChild(cell);
  }
  grid[0] = hbox.childNodes;
  for (var i = 1; i < rows; i++) {
    hbox = hbox.cloneNode(true);
    hbox.setAttribute("row", i);
    vbox_field.appendChild(hbox);
    grid[i] = hbox.childNodes;
  }
  vbox_parent.appendChild(vbox_field);
  newGame();
  setTimeout(ensureSizeAndPosition, 0);
}

function ensureSizeAndPosition() {
  sizeToContent();
  window.innerWidth = document.getElementById("innerWidth").boxObject.width;
  var windowX = window.screenX;
  if (windowX < screen.availLeft)
    windowX = screen.availLeft;
  else {
    var availX = screen.availLeft + screen.availWidth - window.outerWidth;
    if (windowX > availX)
      windowX = availX;
  }
  var windowY = window.screenY;
  if (windowY < screen.availTop)
    windowY = screen.availTop;
  else {
    var availY = screen.availTop + screen.availHeight - window.outerHeight;
    if (windowY > availY)
      windowY = availY;
  }
  window.moveTo(windowX, windowY);
}

function onMouseDown(event) {
  if (!down) {
    if (event.button == 0 && event.target == feedback_button) {
      down = feedback_button;
      feedback_button.className = "down";
    } else if (!stop_time && event.target.localName == "cell") {
      row = parseInt(event.target.parentNode.getAttribute("row"));
      col = parseInt(event.target.getAttribute("col"));
      var cell = grid[row][col];
      if (event.button == 0 || cell.show == "true") {
        down = vbox_field;
        feedback_button.className = "field";
        push = event.button == 0 ? 1 : 2;
        updateFields(true);
      } else {
        switch (cell.show) {
        case "flag": flags--; cell.setShow("mark"); if (marks) break;
        case "mark": cell.setShow(null); break;
        default: flags++; cell.setShow("flag"); break;
        }
        digits_left.value = mines - flags;
      }
    }
  } else if (down == vbox_field && push == 1) {
    push = 2;
    updateFields(true);
  }
}

function onMouseMove(event) {
  if (down == feedback_button) {
    if (event.target == feedback_button)
      feedback_button.className = "down";
    else
      feedback_button.className = game;
  }
  if (down == vbox_field) {
    if (event.target.localName == "cell") {
      var i = parseInt(event.target.parentNode.getAttribute("row"));
      var j = parseInt(event.target.getAttribute("col"));
    } else {
      i = j = -push;
    }
    if (i != row || j != col) {
      updateFields(false);
      row = i;
      col = j;
      updateFields(true);
    }
  }
}

function onMouseUp(event) {
  if (down == feedback_button && event.target == feedback_button)
    restart();
  if (down == vbox_field) {
    updateFields(false);
    feedback_button.className = null;
    if (event.target.localName == "cell") {
      row = parseInt(event.target.parentNode.getAttribute("row"));
      col = parseInt(event.target.getAttribute("col"));
      if (game == "new")
        startGame(row, col);
      var cell = grid[row][col];
      if (push == 1) {
        revealField(row, col);
      } else if (cell.show == "true") {
        var count = cell.value;
        for (var l = Math.max(0, row - 1); l < Math.min(rows, row + 2); l++)
          for (var m = Math.max(0, col - 1); m < Math.min(cols, col + 2); m++)
            if (grid[l][m].show == "flag")
              count--;
        if (!count)
          for (l = Math.max(0, row - 1); l < Math.min(rows, row + 2); l++)
            for (m = Math.max(0, col - 1); m < Math.min(cols, col + 2); m++)
              revealField(l, m);
        else if (cell.value) {
          count = cell.value;
          for (l = Math.max(0, row - 1); l < Math.min(rows, row + 2); l++)
            for (m = Math.max(0, col - 1); m < Math.min(cols, col + 2); m++)
              if (grid[l][m].show != "true")
                count--;
          if (!count) {
            for (l = Math.max(0, row - 1); l < Math.min(rows, row + 2); l++)
              for (m = Math.max(0, col - 1); m < Math.min(cols, col + 2); m++)
                if (!grid[l][m].show || grid[l][m].show == "mark") {
                  grid[l][m].setShow("flag");
                  flags++;
                }
            digits_left.value = mines - flags;
          }
        }
      }
    }
  }
  down = null;
}

function about() {
  window.openDialog("about.xul", "_blank", "chrome,close,modal");
}
