// user vars
var debug = false;

// game vars
var gcWidth = 25;
var gcHeight = 25;
var tickRate = 5;
var playerSpeed = 1;
var maxSpeed = playerSpeed * 1.5;
var accel = playerSpeed / 10;
var aiSpeed = maxSpeed - accel;
var speedCoeff = 100;
var enableMouseControls = false;
var mouseSensitivity = 5;
var pcWidth = 20;
var pcHeight = 20;
var useInterval = true;

// preload track images
var trackImgs = new Array();

// transparent piece representing the track
(trackImgs[0] = new Image()).src = "images/blank.gif";

// solid pieces
(trackImgs[32] = new Image()).src = "images/grass.gif";
(trackImgs[33] = new Image()).src = "images/track-n.gif";
(trackImgs[34] = new Image()).src = "images/track-s.gif";
(trackImgs[35] = new Image()).src = "images/track-e.gif";
(trackImgs[36] = new Image()).src = "images/track-w.gif";
(trackImgs[37] = new Image()).src = "images/track-nw.gif";
(trackImgs[38] = new Image()).src = "images/track-ne.gif";
(trackImgs[39] = new Image()).src = "images/track-se.gif";
(trackImgs[40] = new Image()).src = "images/track-sw.gif";
(trackImgs[41] = new Image()).src = "images/track-i-nw.gif";
(trackImgs[42] = new Image()).src = "images/track-i-ne.gif";
(trackImgs[43] = new Image()).src = "images/track-i-se.gif";
(trackImgs[44] = new Image()).src = "images/track-i-sw.gif";
(trackImgs[50] = new Image()).src = "images/forest-centre.gif";
(trackImgs[51] = new Image()).src = "images/forest-n.gif";
(trackImgs[52] = new Image()).src = "images/forest-ne.gif";
(trackImgs[53] = new Image()).src = "images/forest-nw.gif";
(trackImgs[54] = new Image()).src = "images/forest-sw.gif";
(trackImgs[55] = new Image()).src = "images/forest-se.gif";
(trackImgs[56] = new Image()).src = "images/forest-s1.gif";
(trackImgs[57] = new Image()).src = "images/forest-s2.gif";
(trackImgs[58] = new Image()).src = "images/forest-s3.gif";
(trackImgs[59] = new Image()).src = "images/forest-couple.gif";
(trackImgs[60] = new Image()).src = "images/forest-copse.gif";

// misc overlaid images
(trackImgs[64] = new Image()).src = "images/start-v.gif";
(trackImgs[65] = new Image()).src = "images/tree.gif";

// computer player images
var playerImgsW = new Array();
(playerImgsW[0] = new Image()).src = "images/playerw-0.gif";
(playerImgsW[1] = new Image()).src = "images/playerw-1.gif";
(playerImgsW[2] = new Image()).src = "images/playerw-2.gif";
(playerImgsW[3] = new Image()).src = "images/playerw-3.gif";
(playerImgsW[4] = new Image()).src = "images/playerw-4.gif";
(playerImgsW[5] = new Image()).src = "images/playerw-5.gif";
(playerImgsW[6] = new Image()).src = "images/playerw-6.gif";
(playerImgsW[7] = new Image()).src = "images/playerw-7.gif";
(playerImgsW[8] = new Image()).src = "images/playerw-8.gif";
(playerImgsW[9] = new Image()).src = "images/playerw-9.gif";
(playerImgsW[10] = new Image()).src = "images/playerw-10.gif";
(playerImgsW[11] = new Image()).src = "images/playerw-11.gif";

// human player images
var playerImgsR = new Array();
(playerImgsR[0] = new Image()).src = "images/playerr-0.gif";
(playerImgsR[1] = new Image()).src = "images/playerr-1.gif";
(playerImgsR[2] = new Image()).src = "images/playerr-2.gif";
(playerImgsR[3] = new Image()).src = "images/playerr-3.gif";
(playerImgsR[4] = new Image()).src = "images/playerr-4.gif";
(playerImgsR[5] = new Image()).src = "images/playerr-5.gif";
(playerImgsR[6] = new Image()).src = "images/playerr-6.gif";
(playerImgsR[7] = new Image()).src = "images/playerr-7.gif";
(playerImgsR[8] = new Image()).src = "images/playerr-8.gif";
(playerImgsR[9] = new Image()).src = "images/playerr-9.gif";
(playerImgsR[10] = new Image()).src = "images/playerr-10.gif";
(playerImgsR[11] = new Image()).src = "images/playerr-11.gif";

// define the tracks
var defaultTrack = new Track(
	"Default Track",3,
	[[55,43,34,34,34,34,34,34,34,34,34,34,34,34,44,32,54,50,50,50,50,50,50,50],
	 [43,39,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,40,44,32,50,50,50,50,50,50,50],
	 [35,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,36,32,50,50,50,50,50,50,50],
	 [35,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,36,32,50,50,50,50,50,50,50],
	 [35,0 ,0 ,0 ,37,33,33,33,33,33,38,0 ,0 ,0 ,0 ,36,32,54,50,50,50,50,50,50],
	 [35,0 ,0 ,37,41,53,51,51,51,52,42,38,0 ,0 ,0 ,36,32,32,54,50,50,50,50,50],
	 [35,0 ,0 ,36,53,50,50,50,50,50,52,35,0 ,0 ,0 ,40,44,32,32,54,56,57,50,50],
	 [35,0 ,0 ,36,50,50,50,50,50,50,50,35,0 ,0 ,0 ,0 ,40,34,34,44,32,32,54,50],
	 [35,0 ,0 ,36,50,50,50,50,50,50,50,35,0 ,0 ,0 ,0 ,0 ,0 ,0 ,40,34,44,32,50],
	 [35,0 ,0 ,36,50,50,50,50,50,50,50,42,33,38,0 ,0 ,0 ,0 ,0 ,0 ,0 ,36,32,50],
	 [35,0 ,0 ,36,54,50,50,50,50,50,50,52,32,42,33,33,38,0 ,0 ,0 ,0 ,36,32,50],
	 [35,0 ,0 ,40,44,54,50,50,50,50,50,50,51,51,51,52,42,38,0 ,0 ,0 ,36,32,50],
	 [35,0 ,0 ,0 ,40,44,54,50,50,50,50,50,50,50,50,50,52,35,0 ,0 ,0 ,36,32,50],
	 [35,0 ,0 ,0 ,0 ,40,44,54,50,50,50,50,50,50,50,50,56,35,0 ,0 ,0 ,36,32,50],
	 [35,0 ,0 ,0 ,0 ,0 ,40,44,54,56,57,58,56,57,58,56,43,39,0 ,0 ,0 ,36,32,50],
	 [42,38,0 ,0 ,0 ,0 ,0 ,40,34,34,34,34,34,34,34,34,39,0 ,0 ,0 ,0 ,36,32,50],
	 [32,42,38,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,36,32,50],
	 [52,32,42,38,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,36,32,50],
	 [50,52,32,42,38,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,37,41,53,50],
	 [50,50,52,32,42,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,41,53,50,50]],
	[[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1],
	 [-1,-1,3 ,3 ,4 ,5 ,6 ,6 ,6 ,6 ,6 ,6 ,6 ,6 ,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1],
	 [-1,3 ,3 ,4 ,6 ,6 ,6 ,6 ,6 ,6 ,6 ,6 ,6 ,6 ,6 ,-1,-1,-1,-1,-1,-1,-1,-1,-1],
	 [-1,3 ,5 ,5 ,6 ,6 ,6 ,6 ,6 ,6 ,6 ,7 ,7 ,7 ,7 ,-1,-1,-1,-1,-1,-1,-1,-1,-1],
	 [-1,3 ,5 ,5 ,6 ,6 ,6 ,6 ,6 ,6 ,6 ,7 ,7 ,8 ,7 ,-1,-1,-1,-1,-1,-1,-1,-1,-1],
	 [-1,3 ,3 ,5 ,6 ,-1,-1,-1,-1,-1,-1,-1,8 ,8 ,8 ,-1,-1,-1,-1,-1,-1,-1,-1,-1],
	 [-1,3 ,3 ,3 ,-1,-1,-1,-1,-1,-1,-1,-1,9 ,8 ,8 ,8,-1,-1,-1,-1,-1,-1,-1,-1],
	 [-1,3 ,3 ,3 ,-1,-1,-1,-1,-1,-1,-1,-1,9 ,8 ,8 ,8 ,-1,-1,-1,-1,-1,-1,-1,-1],
	 [-1,3 ,3 ,3 ,-1,-1,-1,-1,-1,-1,-1,-1,9 ,9 ,8 ,8 ,7 ,6 ,6 ,-1,-1,-1,-1,-1],
	 [-1,3 ,3 ,3 ,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9 ,8 ,7 ,7 ,7 ,6 ,6 ,-1,-1,-1],
	 [-1,3 ,3 ,3 ,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9 ,9 ,7 ,9 ,9 ,7 ,6 ,-1,-1,-1],
	 [-1,2 ,3 ,3 ,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9 ,9 ,9 ,9 ,-1,-1,-1],
	 [-1,2 ,2 ,2 ,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9 ,9 ,9 ,8 ,-1,-1,-1],
	 [-1,1 ,1 ,2 ,2 ,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9 ,9 ,9 ,9 ,-1,-1,-1],
	 [-1,1 ,1 ,2 ,2 ,2 ,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9 ,10,9 ,9 ,-1,-1,-1],
	 [-1,-1,1 ,1 ,2 ,1 ,2 ,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,10,9 ,9 ,-1,-1,-1],
	 [-1,-1,-1,2 ,1 ,1 ,1 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,11,10,10,9 ,-1,-1,-1],
	 [-1,-1,-1,-1,1 ,1 ,1 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,10,11,10,9 ,9 ,-1,-1,-1],
	 [-1,-1,-1,-1,-1,1 ,1 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,10,10,11,9 ,9 ,-1,-1,-1,-1],
	 [-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]],
	[new TrackImage(64,8*gcWidth-10,gcHeight+12),
	 new TrackImage(65,16*gcWidth+10,6*gcHeight-5)],
	[[0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	 [2,2,2,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,1,0,0,0,0,8,8,8,8,8,8,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0],
	 [3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,0,0],
	 [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0],
	 [0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0]],
	new Vector(8*gcWidth,2*gcHeight),
	new Vector(8*gcWidth+26,2*gcHeight),
	new Vector(8*gcWidth,2*gcHeight+16),
	new Vector(8*gcWidth+26,2*gcHeight+16),
	6,6,6,6
	);


// positions of gifs in big gif and relative directions
var positions = [
	new SpritePosition(0,0,1,0),			// 0 = >
	new SpritePosition(0,0,0.86,0.5),
	new SpritePosition(0,0,0.5,0.86),
	new SpritePosition(0,0,0,1),			// 3 = v
	new SpritePosition(0,0,-0.5,0.86),
	new SpritePosition(0,0,-0.86,0.5),
	new SpritePosition(0,0,-1,0),			// 6 = <
	new SpritePosition(0,0,-0.86,-0.5),
	new SpritePosition(0,0,-0.5,-0.86),
	new SpritePosition(0,0,0,-1),			// 9 = ^
	new SpritePosition(0,0,0.5,-0.86),
	new SpritePosition(0,0,0.86,-0.5)];


// document elements
var trackGride;
var players;
var player1;
var player2;
var player3;
var player4;

// internal vars
var intervalID;
var lastMousePos = new Vector(0,0);
var gameRunning = false;
var debugWin;
var curTrack;
var nextP = 0;
var placings = new Array(4);

// the first function that's executed
function startUp() {
	// get shortcuts to document elements
	trackGride = document.getElementById("track-grid");
	statusTextE = document.getElementById("status-text");

	// create player1
	player1 = new Player(
		"Player 1",
		false,
		document.getElementById("player1"),
		document.getElementById("player1box")
		);
	
	// create player2
	player2 = new Player(
		"Player 2",
		true,
		document.getElementById("player2"),
		document.getElementById("player2box")
		);
	
	// create player3
	player3 = new Player(
		"Player 3",
		true,
		document.getElementById("player3"),
		document.getElementById("player3box")
		);
	
	// create player4
	player4 = new Player(
		"Player 4",
		true,
		document.getElementById("player4"),
		document.getElementById("player4box")
		);
	// create refs in array
	players = new Array(player1,player2,player3,player4);

	// have default track loaded
	loadTrack(defaultTrack);

	// show debug mode stuff
	debug = !debug;
	debugToggle();

	// start the timer (won't do anything if not in game
	if (useInterval) {
		intervalID = window.setInterval(tick,tickRate);
	} else {
		window.setTimeout(tick,tickRate);
	}

	// we're loaded
	document.getElementById("xoom-frontend-loading").setAttribute("value","Press n to start");
}

// start playing the current level
function go() {
	// set the status text
	setStatusText("Go!!");
	setTimeout(clearStatusText,1000);
	// start the game timer
	gameRunning = true;
	// start computer cars going
	player1.start();
	player2.start();
	player3.start();
	player4.start();
}

// on mouse down
function md() {
	if (!enableMouseControls) return false;
	player1.footOnPedal = true;
}

// on mouse up
function mu() {
	if (!enableMouseControls) return false;
	player1.footOnPedal = false;
}

// on mouse move
function mm(event) {
	if (!enableMouseControls) return false;
	if (event.clientX > lastMousePos.x + mouseSensitivity) {
		// dragging right
		player1.goRight = true;
		lastMousePos.x = event.clientX;
		lastMousePos.y = event.clientY;
	} else if (event.clientX < lastMousePos.x - mouseSensitivity) {
		// dragging left
		player1.goLeft = true;
		lastMousePos.x = event.clientX;
		lastMousePos.y = event.clientY;
	} else {
		// no change
	}
	return true;
}

// user presses left on keyboard
function turnLeft() {
	player1.goLeft = true;
}

// user presses right on keyboard
function turnRight() {
	player1.goRight = true;
}

// on key down
function kd(event) {
	// shift=16, ctrl = 17, alt=18
	if ((event.keyCode == 17) || (event.keyCode == 32)) {
		player1.footOnPedal = true;
	}
}

// on key up
function ku(event) {
	if ((event.keyCode == 17) || (event.keyCode == 32)) {
		player1.footOnPedal = false;
	}
}

// this function gets executed every tickRate ms
function tick() {
	if (!gameRunning) return;
	
	// move the players
	player1.move();
	player2.move();
	player3.move();
	player4.move();

	// update the screen
	if (nextP == 0) {
		player1.updatePos();
	} else if (nextP == 1) {
		player2.updatePos();
	} else if (nextP == 2) {
		player3.updatePos();
	} else if (nextP == 3) {
		player4.updatePos();
	} else if (nextP == 4) {
		player1.updateSpeed();
		player1.updatePlacing();
	}
	nextP ++;
	if (nextP == 5) nextP = 0;

	//if (!useInterval) window.setTimeout(tick,tickRate);

	// any winners
	if (player1.lap > curTrack.laps) {
		player1.win();
	} else if (player2.lap > curTrack.laps) {
		player2.win();
	} else if (player3.lap > curTrack.laps) {
		player3.win();
	} else if (player4.lap > curTrack.laps) {
		player4.win();
	}
}

// function to calculate + update the current placings of players
function calcPlacings() {
	for (var i = 0; i<4; i++) {
		placings[i] = (players[i].marker * 100) + (players[i].lap * 1000) - players[i].placing;
	}
	// get first, second, third, fourth
	for (var i = 0; i<4; i++) {
		var h = 0;
		var wh = 0;
		for (var j = 0; j<4; j++) {
			if (placings[j] > h)  {
				h = placings[j];
				wh = j;
			}
		}
		placings[wh] = -1;
		if (players[wh].placing != i+1) {
			players[wh].placing = i+1;
			players[wh].upd = true;
		}
	}
}

// pause/unpause
function pauseToggle() {
	gameRunning = !gameRunning;
	if (!gameRunning) {
		setStatusText("Paused");
	} else {
		clearStatusText();
	}
}

// switch between debug and nondebug modes and do layout, etc changes
function debugToggle() {
	debug = !debug;
	// set debug mode settings
	if (debug) {
		document.getElementById("track-debug-grid").hidden = false;
	} else {
		document.getElementById("track-debug-grid").hidden = true;
	}
}

// print a debug message somewhere
function debugPrint(msg) {
	if (!debug) return;
	//throw(msg);
	if (!debugWin) {
		debugWin = window.open('',"Debug Window");
	}
	debugWin.document.write("<p>" + msg + "</p>");
}

// load a track on the game area
function loadTrack(track, posonly) {
	if (!track) return false;

	if (!posonly) {
	// load the track images
	var theGrid = track.grid;
	for (var i=0; i<theGrid.length; i++) {
		for (var j=0; j<theGrid[i].length; j++) {
			// set the grid image
			trackGride.childNodes[1].childNodes[i].childNodes[j].src = trackImgs[theGrid[i][j]].src;
			trackGride.childNodes[1].childNodes[i].childNodes[j].width = gcWidth;
			trackGride.childNodes[1].childNodes[i].childNodes[j].height = gcHeight;
		}
	}

	// load the overlay images
	var trackImages = document.getElementById("track-images");
	for (var i=0; i<trackImages.childNodes.length; i++) {
		trackImages.childNodes.item(i).parentNode.removeChild(trackImages.childNodes.item(i));
	}
	for (var i=0; i<track.imgs.length; i++) {
		var newi = document.createElement("image");
		trackImages.appendChild(newi);
		newi.src = trackImgs[track.imgs[i].img].src;
		newi.top = track.imgs[i].top;
		newi.left = track.imgs[i].left;
	}
	}

	// position the players
	player1.pos.x = track.p1StartPos.x;
	player1.pos.y = track.p1StartPos.y;
	player2.pos.x = track.p2StartPos.x;
	player2.pos.y = track.p2StartPos.y;
	player3.pos.x = track.p3StartPos.x;
	player3.pos.y = track.p3StartPos.y;
	player4.pos.x = track.p4StartPos.x;
	player4.pos.y = track.p4StartPos.y;
	player1.dir = track.p1StartDir;
	player2.dir = track.p2StartDir;
	player3.dir = track.p3StartDir;
	player4.dir = track.p4StartDir;
	player1.updatePos();
	player1.updateDir();
	player2.updatePos();
	player2.updateDir();
	player3.updatePos();
	player3.updateDir();
	player4.updatePos();
	player4.updateDir();
	
	// remember what track we're on
	curTrack = track;

}

// start the game
function startGame() {
	for (var i = 0; i<4; i++) {
		players[i].reset();
	}
	loadTrack(defaultTrack, true);
	document.getElementById("xoom-deck").selectedIndex = 1;
	setStatus3();
	setTimeout(setStatus2,1000);
	setTimeout(setStatus1,2000);
	setTimeout(go, 3000);
}

// show the title screen
function showFrontEnd() {
	document.getElementById("xoom-deck").selectedIndex = 0;
}

// util functions

// objects

// Track object represents a track!
function Track(trackName,laps,grid,aigrid,imgs,markergrid,
		p1StartPos,p2StartPos,p3StartPos,p4StartPos,
		p1StartDir,p2StartDir,p3StartDir,p4StartDir
		) {
	// save this object
	this.trackName = trackName;
	this.laps = laps;
	this.grid = grid;
	this.aigrid = aigrid;
	this.imgs = imgs;
	this.markergrid = markergrid;
	this.p1StartPos = p1StartPos;
	this.p2StartPos = p2StartPos;
	this.p3StartPos = p3StartPos;
	this.p4StartPos = p4StartPos;
	this.p1StartDir = p1StartDir;
	this.p2StartDir = p2StartDir;
	this.p3StartDir = p3StartDir;
	this.p4StartDir = p4StartDir;
	// work out the highest marker
	this.highestMarker = 0;
	for (var i=0; i<markergrid.length; i++) {
		for (var j=0; j<markergrid[i].length; j++) {
			if (markergrid[i][j] > this.highestMarker) {
				this.highestMarker = markergrid[i][j];
			}
		}
	}
}

// Track image object
function TrackImage(imgNum, left, top) {
	this.img = imgNum;
	this.top = top;
	this.left = left;
}

// Vector object
function Vector(x,y) {
	this.x = x;
	this.y = y;
}

// Player object
function Player(
		plStr,
		isComputerPlayer,
		element,
		bElement,
		pimages) {
	// variables
	this.plStr = plStr;
	this.isComputerPlayer = isComputerPlayer;
	this.e = element;
	this.boxE = bElement;
	this.speE = bElement.childNodes.item(2);
	this.placeE = bElement.childNodes.item(1);
	this.pos = new Vector(0,0);
	this.dir = 0;
	this.speed = 0;
	this.goLeft = false;
	this.goRight = false;
	this.footOnPedal = false;
	this.placing = 4;
	this.lap = 0;
	this.marker = 0;
	this.usd = true; // update speed due
	this.upd = true; // update placing due
	this.udd = true; // update dir due

	// member functions
	this.updatePos = Player_updatePos;
	this.updateSpeed = Player_updateSpeed;
	this.updatePlacing = Player_updatePlacing;
	this.win = Player_win;
	this.reset = Player_reset;

	// change functions if computer
	if (isComputerPlayer) {
		this.updateDir = Player_aiUpdateDir;
		this.start = Player_aiStart;
		this.move = Player_aiMove;
		// randomize speed
		this.randomizeSpeed = Player_randomizeSpeed;
		// hide player boxes
		//if (!debug) 
		this.boxE.hidden = true;
	} else {
		this.updateDir = Player_updateDir;
		this.start = Player_start;
		this.move = Player_move;
		this.lap = 1;
	}

	// update display
	this.updateSpeed();
	this.updatePlacing();
	
}

// Reset play vars
function Player_reset() {
	this.marker = 0;
	this.dir = 0;
	this.speed = 0;
	if (this.isComputerPlayer) {
		this.randomizeSpeed = Player_randomizeSpeed;
		this.lap = 0;
	} else {
		this.lap = 1;
	}
}

// Player object function to win the game
function Player_win() {
	gameRunning = false;
	setStatusText (this.plStr + " wins!");
	setTimeout (showFrontEnd, 6000);
}

// Player object member functions for updating the postion of its element on screen
function Player_updatePos() {
	// update the spriteposition
	this.e.left = this.pos.x;
	this.e.top = this.pos.y;
	// update the speed text
	//this.updateSpeed();
	// update the placing/lap text
	//this.updatePlacing();
	if (this.udd) {
		this.updateDir();
		this.udd = false;
	}
}

// Player object member function to update the direction the car is facing
function Player_updateDir() {
	this.e.src = playerImgsR[this.dir].src;
}

// Player object to update the speed element
function Player_updateSpeed() {
	if (!this.usd) return;
	var realSpeed = Math.floor(this.speed * speedCoeff);
	if (realSpeed < 10) {
		realSpeed = "00" + realSpeed;
	} else if (realSpeed < 100) {
		realSpeed = "0" + realSpeed;
	}
	realSpeed += " kph";
	if (!this.isComputerPlayer) this.speE.setAttribute("value", realSpeed);
	this.usd = false;
}

// Player object to update the placing of this player
function Player_updatePlacing() {
	if (this.upd) {
		if (!this.isComputerPlayer) {
			var plStr = "";
			if (this.placing == 4) {
				plStr = "4th"
			} else if (this.placing == 3) {
				plStr = "3rd"
			} else if (this.placing == 2) {
				plStr = "2nd"
			} else {
				plStr = "1st"
			}
			if (debug) {
				this.placeE.setAttribute("value",this.lap + ":" + this.marker + ":" + this.placing);
			} else {
				this.placeE.setAttribute("value", plStr + " lap" + this.lap);
			}
		}
		this.upd = false;
	}
}

// Player object member function to start computer cars
function Player_aiStart() {
	this.speed = aiSpeed;
	this.randomizeSpeed();
}

// Function to start a human player
function Player_start() {
}

// Player function that gets executed (by a human controlled car) every game tick
function Player_move() {
	var oldSpe = this.speed;
	var oldDir = this.dir;
	if (this.goRight) {
		this.dir++;
		this.goRight = false;
		if (this.dir > positions.length-1) this.dir = 0;
	} else if (this.goLeft) {
		this.dir--;
		if (this.dir < 0) this.dir = positions.length - 1;
		this.goLeft = false;
	}
	// if dir has changed, set the direction updater flag
	if (oldDir != this.dir) this.udd = true;
	// if player is moving, update position
	// move player
	var newx = this.pos.x + (positions[this.dir].dirX * this.speed);
	var newy = this.pos.y + (positions[this.dir].dirY * this.speed);
	var newposy; var newposx;
	var curposy; var curposx;
	// calculate the leading edge of the sprite (improves collision detection)
	if ((this.dir == 9) || (this.dir == 10) || (this.dir == 11)) {
		// if going north-east-ish
		newposx = Math.floor((newx+pcWidth)/gcHeight);
		newposy = Math.floor(newy/gcWidth);
		curposx = Math.floor((this.pos.x+pcWidth)/gcHeight);
		curposy = Math.floor(this.pos.y/gcWidth);
	} else if ((this.dir == 0) || (this.dir == 1) || (this.dir == 2)) {
		// if going south-east-ish
		newposx = Math.floor((newx+pcWidth)/gcHeight);
		newposy = Math.floor((newy+pcHeight)/gcWidth);
		curposx = Math.floor((this.pos.x+pcWidth)/gcHeight);
		curposy = Math.floor((this.pos.y+pcHeight)/gcWidth);
	} else if ((this.dir == 4) || (this.dir == 3) || (this.dir == 5)) {
		// if going south-west-ish
		newposx = Math.floor(newx/gcHeight);
		newposy = Math.floor((newy+pcHeight)/gcWidth);
		curposx = Math.floor((this.pos.x)/gcHeight);
		curposy = Math.floor((this.pos.y+pcHeight)/gcWidth);
	} else {
		// if going north-west-ish
		newposx = Math.floor(newx/gcHeight);
		newposy = Math.floor(newy/gcWidth);
		curposx = Math.floor(this.pos.x/gcHeight);
		curposy = Math.floor(this.pos.y/gcWidth);
	}
	// check for collisions with scenery
	if (curTrack.grid[newposy][newposx] == 0) {
		// can go in both directions
		this.pos.x = newx;
		this.pos.y = newy;
		//this.updatePos();
	} else if (curTrack.grid[newposy][curposx] == 0) {
		// can go up/down
		this.pos.y = newy;
		//this.updatePosY();
		this.speed -= accel;
	} else if (curTrack.grid[curposy][newposx] == 0) {
		// can go left/right
		this.pos.x = newx;
		//this.updatePosX();
		this.speed -= accel;
	} else {
		// can't go anywhere
		this.speed = 0;
	}
	// update marker
	var newmarker = curTrack.markergrid[newposy][newposx];
	if (newmarker > 0) {
		if (newmarker - this.marker == 1) {
			this.marker = newmarker;
			calcPlacings();
		} else if ((newmarker == 1) && (this.marker == curTrack.highestMarker))  {
			this.lap++;
			this.upd = true;
			this.marker = newmarker;
			calcPlacings();
		}
	}
	// accel / decel
	if (this.footOnPedal) {
		this.speed += accel;
	} else {
		this.speed -= accel;
	}
	if (this.speed > maxSpeed) this.speed = maxSpeed;
	if (this.speed < 0) this.speed = 0;
	if (oldSpe != this.speed) {
		this.usd = true;
	}
}

// Player function gets executed by the computer cars every tick
function Player_aiMove() {
	var curposx; var curposy;
	// calculate the leading edge of the sprite (improves collision detection)
	var scx = this.speed * 3;
	var scy = this.speed * 3;
	if ((this.dir == 9) || (this.dir == 10) || (this.dir == 11)) {
		// if going north-east-ish
		curposx = Math.floor((this.pos.x+pcWidth+scx)/gcHeight);
		curposy = Math.floor((this.pos.y-scy)/gcWidth);
	} else if ((this.dir == 3) || (this.dir == 1) || (this.dir == 2)) {
		// if going south-east-ish
		curposx = Math.floor((this.pos.x+pcWidth+scx)/gcHeight);
		curposy = Math.floor((this.pos.y+pcHeight+scy)/gcWidth);
	} else if ((this.dir == 6) || (this.dir == 4) || (this.dir == 5)) {
		// if going south-west-ish
		curposx = Math.floor((this.pos.x-scx)/gcHeight);
		curposy = Math.floor((this.pos.y+pcHeight+scy)/gcWidth);
	} else {
		// if going north-west-ish
		curposx = Math.floor((this.pos.x-scx)/gcHeight);
		curposy = Math.floor((this.pos.y-scy)/gcWidth);
	}
	// set our marker
	if ((curTrack.markergrid[curposy][curposx] > 0)  &&
		(curTrack.markergrid[curposy][curposx] != this.marker)) {
		this.marker = curTrack.markergrid[curposy][curposx];
		if (this.marker == 1) {
			// new lap
			this.lap++;
		}
		calcPlacings();
	}
	var oldDir = this.dir;
	// what direction should this car be moving in?
	this.dir = curTrack.aigrid[curposy][curposx];
	// set the new position
	if (this.dir >= 0) {
		this.pos.x = this.pos.x + (positions[this.dir].dirX * this.speed);
		this.pos.y = this.pos.y + (positions[this.dir].dirY * this.speed);
	} else {
		this.dir = 0;
	}
	// if dir has changed, set the direction updater flag
	if (oldDir != this.dir) this.udd = true;
}

// Player object member function to update the direction the car is facing
function Player_aiUpdateDir() {
	this.e.src = playerImgsW[this.dir].src;
}

// increase/decrease computer speed randomly
function Player_randomizeSpeed() {
	this.speed = this.speed + (Math.random()*accel) - (accel/2);
}

// Object sprite position - info about a player facing or going in a certain direction
function SpritePosition(cropLeft,cropRight,dirX,dirY) {
	this.cropLeft = cropLeft;
	this.cropRight = cropRight;
	this.dirX = dirX;
	this.dirY = dirY;
}

// Set the status taxt
function setStatusText(t) {
	statusTextE.setAttribute("value",t);
}

// set status text functions
function setStatus3() { setStatusText("3"); }
function setStatus2() { setStatusText("2"); }
function setStatus1() { setStatusText("1"); }
function clearStatusText() { setStatusText(""); }
