/*
  Author: David Gillen

  Hiss-Zilla

  Revision History
  Version 0.1.0  -  Snake appearing and moving, and growing on key press Fully controlable
  Version 0.1.1  -  Collision detection added for hitting walls, headsmash function
  Version 0.1.2  -  Snake with now selfsmash() is he tries to run over himself
                    Also added check for which direction you are going and only allow chang if it is valid.
  Version 0.1.3  -  Scoring and levels now implemented. 
                    Score for each bit eaten, level increase after every 10, with speed increase also implemented
  Version 1.0.0  -  Things tidied up and readey for sending out.
  Version 2.0.0  -  Added Graphic for wriggler and food, still are messy for starting snake.
  Version 3.0.0  -  Updated XUL for Mozilla 1.0. Added full screen mode. Made remote JAR. Cleaned up some code. (Eric)
  Version 3.0.1  -  Added image preloading

  Thanks to David McNamara (me@mackers.com) for allow me to use some of his functions. From his xultris game.
*/

// internal vars
var widthofgrid;
var heightofgrid;
var gameison=false;
var pauseison=false;
var intervalID;
var grid;
var score;
var level;
var wriggler;
var section = new Array();
var secondsection = new Array();
var tail = new Array();
var xcoord;
var ycoord;
var secondxcoord;
var secondycoord;
var speed;
var entered;
var left;
var headclass;
var selfsmashed = false;

function snake()
{
  this.direction = 'e';
  this.body = [[12,9],[11,9],[10,9],[9,9]];
  this.togrow = 0;
  this.nextfood = [0,0];
  this.score = 0;
}

function startup()
{
  widthofgrid=document.getElementsByTagName("column").length;
    heightofgrid=document.getElementsByTagName("row").length;

  grid = new Array(widthofgrid);

  for (i=0 ; i<widthofgrid ; i++)
  {
    grid[i] = new Array(heightofgrid);
  }
  window.title="Snake";

  preload_images();

  // hide the full screen button if playing over web
  // (not allowed)
  if (new String(window.location).indexOf("http") == 0)
  {
	  document.getElementById("fullscreenbut").setAttribute("style","display: none;");
  }
}

function newGame()
{
  gameOverMan();
  for (i=0 ; i<widthofgrid ; i++)
  {
    for (j=0 ; j<heightofgrid ; j++)
    {
      grid[i][j] = false;
      prepareString = ("r" + make2digit(parseInt(j)) + "c" + make2digit(parseInt(i)));
      document.getElementById(prepareString).setAttribute("class","off");
    }
  }
  gameison = true;
  pauseison = false;
  resetScore();
  resetLevel();
  resetsmashed();
  unhalt();
  spawnNewSnake();
}

function pause()
{
  if (pauseison)
  {
    pauseison = false;
    unhalt();
  } else {
    pauseison = true;
    halt();
  }
}

//function called from key presses to check for valid direction changes and stuff.
function east() { if (gameison && (wriggler.direction != 'e' && wriggler.direction != 'w' )) { wriggler.direction = 'e'; } }
function west() { if (gameison && (wriggler.direction != 'e' && wriggler.direction != 'w' )) { wriggler.direction = 'w'; } }
function north() { if (gameison && (wriggler.direction != 'n' && wriggler.direction != 's' )) { wriggler.direction = 'n'; } }
function south() { if (gameison && (wriggler.direction != 'n' && wriggler.direction != 's' )) { wriggler.direction = 's'; } }

function halt()
{
  if (intervalID) window.clearInterval(intervalID);
}

function unhalt()
{
  var spe = 275 - (25 * level);
  intervalID = window.setInterval("moveSnake()",spe);
}

function gameOverMan()
{
  gameison = false;
  halt();
}


function spawnNewSnake()
{
  wriggler = new snake();
  redrawSnake();
  drawfood();
}

function increaseScore(s)
{
  if (s)
  {
    s *= level;
    if (Math.floor(score/1000) != Math.floor((s+score)/1000)) increaseLevel(1);
    score+=s;
    document.getElementById("currentscore").setAttribute("value", score);
  }
}

function increaseLevel(l)
{
  if (!l) l=1;
  level+=1;
  document.getElementById("currentlevel").setAttribute("value", level);
}

function resetScore()
{
  score=0;
  document.getElementById("currentscore").setAttribute("value", 0);
}

function resetLevel()
{
  level=1;
  document.getElementById("currentlevel").setAttribute("value", 1);
}

function resetsmashed()
{
  selfsmashed = false;
}

function moveSnake()
{
  if (gameison && !pauseison)
  {
    moveDirection(wriggler.direction);
  }  
}

function moveDirection(dir)
{
  switch(dir)
  {
    case 'n': {movenorth(); break;}
    case 's': {movesouth(); break;}
    case 'e': {moveeast();  break;}
    case 'w': {movewest();  break;}
  }
}

function movenorth()
{
  if(wriggler.togrow == 0)
  {
    section = wriggler.body.pop();
    deletesection(section[0], section[1]);
    drawtail();
  }
  else
  {
    wriggler.togrow--;
  }
  section = wriggler.body[0];
  if (section[1] == 0)
  {
    gameison = false;
    headsmash(section[0], section[1]);
    return;
  }
  selfsmashed = selfsmash(section[0], section[1]-1);
  eatfood(section[0], section[1]-1);
  wriggler.body.unshift([section[0],section[1]-1]);
  secsection();
  drawhead(section[0], section[1]-1);
}

function movesouth()
{
  if(wriggler.togrow == 0)
  {
    section = wriggler.body.pop();
    deletesection(section[0], section[1]);
    drawtail();
  }
  else
  {
    wriggler.togrow--;
  }
  section = wriggler.body[0];
  if (section[1]+1 == heightofgrid)
  {
    gameison = false;
    headsmash(section[0], section[1]);
    return;
  }
  selfsmashed = selfsmash(section[0], section[1]+1);
  eatfood(section[0], section[1]+1);
  wriggler.body.unshift([section[0],section[1]+1]);
  secsection();
  drawhead(section[0], section[1]+1);
}

function moveeast()
{
  if(wriggler.togrow == 0)
  {
    section = wriggler.body.pop();
    deletesection(section[0], section[1]);
    drawtail();
  }
  else
  {
    wriggler.togrow--;
  }
  section = wriggler.body[0];
  if (section[0]+1 == widthofgrid)
  {
    gameison = false;
    headsmash(section[0], section[1]);
    return;
  }
  selfsmashed = selfsmash(section[0]+1, section[1]);
  eatfood(section[0]+1, section[1]);
  wriggler.body.unshift([section[0]+1,section[1]]);
  secsection();
  drawhead(section[0]+1, section[1]);
}

function movewest()
{
  if(wriggler.togrow == 0)
  {
    section = wriggler.body.pop();
    deletesection(section[0], section[1]);
    drawtail();
  }
  else
  {
    wriggler.togrow--;
  }
  section = wriggler.body[0];
  if (section[0] == 0)
  {
    gameison = false;
    headsmash(section[0], section[1]);
    return;
  }
  selfsmashed = selfsmash(section[0]-1, section[1]);
  eatfood(section[0]-1, section[1]);
  wriggler.body.unshift([section[0]-1,section[1]]);
  secsection();
  drawhead(section[0]-1, section[1]);
}

function redrawSnake()
{
  for (s = 0; s < wriggler.body.length; s++)
  {
    section = wriggler.body[s];
    xcoord = section[0];
    ycoord = section[1];
    prepareString = ("r" + make2digit(parseInt(ycoord)) + "c" + make2digit(parseInt(xcoord)));
    document.getElementById(prepareString).setAttribute("class","bodyeastwest");
  }
}

function deleteSnake()
{
  for (i=0; i<wriggler.body.length; i++)
  {
    section = wriggler.body[i];
    xcoord = section[0];
    ycoord = section[1];
    prepareString = ("r" + make2digit(parseInt(ycoord)) + "c" + make2digit(parseInt(xcoord)));
    document.getElementById(prepareString).setAttribute("class","off");
  }
}


function clearGrid()
{
  for(i = 0; i < widthofgrid; i++)
  {
    for (j=0; j < heightofgrid; j++)
    {
      grid[i][j] = false;
      prepareString = ("r" + make2digit(parseInt(j)) + "c" + make2digit(parseInt(i)));
      document.getElementById(prepareString).setAttribute("class","off");
      
    }
  }
}

function make2digit(n)
{
  if ((n < 10) || (n.length == 1))
  {
    return "0" + n;
  } else if (((n > 9) && (n < 100)) || (n.length == 2)) {
    return "" + n;
  } else {
    return "00";
  }
}

// debugging to output the location of each snake body section
function body()
{
  for (i=0;i < wriggler.body.length ;i++ )
  {
    section = wriggler.body[i];
  }
}

function snakegrow()
{
  wriggler.togrow+=2;
}

function deletesection(x, y)
{
  prepareString = ("r" + make2digit(parseInt(y)) + "c" + make2digit(parseInt(x)));
  document.getElementById(prepareString).setAttribute("class","off");

}

function drawhead(x, y)
{
  prepareString = ("r" + make2digit(parseInt(y)) + "c" + make2digit(parseInt(x)));
  var goingin;
  switch(wriggler.direction)
  {
    case 'n': {if(selfsmashed){headclass = "smashnorth"}else{headclass = "headnorth"}; goingin = 's'; break;}
    case 's': {if(selfsmashed){headclass = "smashsouth"}else{headclass = "headsouth"}; goingin = 'n'; break;}
    case 'e': {if(selfsmashed){headclass = "smasheast"}else{headclass = "headeast"};  goingin = 'w'; break;}
    case 'w': {if(selfsmashed){headclass = "smashwest"}else{headclass = "headwest"};  goingin = 'e'; break;}
  }
  
  document.getElementById(prepareString).setAttribute("class",headclass);
  document.getElementById(prepareString).setAttribute("entered",goingin);
  if(selfsmashed){gameison = false;}
  return;
}

function secsection()
{
  secondArray = wriggler.body[1];
  secondxcoord = secondArray[0];
  secondycoord = secondArray[1];
  drawsecondsection(secondxcoord, secondycoord);
  return;
}

function drawsecondsection(secondx, secondy)
{
  switch(wriggler.direction)
  {
    case 'n': { left = 'n'; break; }
    case 's': { left = 's'; break; }
    case 'e': { left = 'e'; break; }
    case 'w': { left = 'w'; break; }
  }
  prepareString = ("r" + make2digit(parseInt(secondy)) + "c" + make2digit(parseInt(secondx)));
  document.getElementById(prepareString).setAttribute("left",left);
  var entered = document.getElementById(prepareString).getAttribute("entered");
  var secondpicture = secpicture(entered, left);
  document.getElementById(prepareString).setAttribute("class", secondpicture);
  return;
}

function secpicture(e, l)
{
  if(e == 'n')
  {
    if(l == 's')
    {
      return("bodynorthsouth");
    }
    else if(l == 'e')
    {
      return("bodynortheast");
    }
    else
    {
      return("bodynorthwest");
    }
  }
  else if(e == 's')
  {
    if(l == 'n')
    {
      return("bodynorthsouth");
    }
    else if(l == 'e')
    {
      return("bodysoutheast");
    }
    else
    {
      return("bodysouthwest");
    }
  }
  else if(e == 'e')
  {
    if(l == 'n')
    {
      return("bodynortheast");
    }
    else if(l == 's')
    {
      return("bodysoutheast");
    }
    else
    {
      return("bodyeastwest");
    }
  }
  else
  {
    if(l == 'n')
    {
      return("bodynorthwest");
    }
    else if(l == 's')
    {
      return("bodysouthwest");
    }
    else
    {
      return("bodyeastwest");
    }
  }
}

function drawtail()
{
  tail = wriggler.body[wriggler.body.length-1];
  prepareString = ("r" + make2digit(parseInt(tail[1])) + "c" + make2digit(parseInt(tail[0])));
  taildir = document.getElementById(prepareString).getAttribute("left");
  if(taildir == 'n') { document.getElementById(prepareString).setAttribute("class","tailsouth")};
  if(taildir == 's') { document.getElementById(prepareString).setAttribute("class","tailnorth")};
  if(taildir == 'e') { document.getElementById(prepareString).setAttribute("class","tailwest")};
  if(taildir == 'w') { document.getElementById(prepareString).setAttribute("class","taileast")};
}

function headsmash(x, y)
{
  prepareString = ("r" + make2digit(parseInt(y)) + "c" + make2digit(parseInt(x)));
  if(wriggler.direction == 'n'){document.getElementById(prepareString).setAttribute("class","smashnorth")};
  if(wriggler.direction == 's'){document.getElementById(prepareString).setAttribute("class","smashsouth")};
  if(wriggler.direction == 'e'){document.getElementById(prepareString).setAttribute("class","smasheast")};
  if(wriggler.direction == 'w'){document.getElementById(prepareString).setAttribute("class","smashwest")};
}

// Check to see is snake runs over himself and if so tis gameover
function selfsmash(x, y)
{
  for (i=1; i < wriggler.body.length; i++)
  {
    var selfcrush = new Array();
    
    selfcrush = wriggler.body[i];
    if (selfcrush[0] == x && selfcrush[1] == y)
    {
      //dump("If is true\n");
      prepareString = ("r" + make2digit(parseInt(y)) + "c" + make2digit(parseInt(x)));
      if(wriggler.direction == 'n'){document.getElementById(prepareString).setAttribute("class","smashnorth")};
      if(wriggler.direction == 's'){document.getElementById(prepareString).setAttribute("class","smashsouth")};
      if(wriggler.direction == 'e'){document.getElementById(prepareString).setAttribute("class","smasheast")};
      if(wriggler.direction == 'w'){document.getElementById(prepareString).setAttribute("class","smashwest")};
      gameison = false;
      return true;
    }
  }
  return false;
}

function drawfood()
{
  do
  {
    xcoord = Math.floor(Math.random() * widthofgrid);
    ycoord = Math.floor(Math.random() * heightofgrid);
  }while(inbody(xcoord, ycoord));
  prepareString = ("r" + make2digit(parseInt(ycoord)) + "c" + make2digit(parseInt(xcoord)));
  document.getElementById(prepareString).setAttribute("class","food");
  wriggler.nextfood[0] = xcoord;
  wriggler.nextfood[1] = ycoord;
}

// Check is a square in the snakes body, if so return true to generate more food else where.
function inbody(x, y)
{
  for(i=0; i < wriggler.body.length; i++)
  {
    var inbodysection = new Array();
    inbodysection = wriggler.body[i];
    if (inbodysection[0] == x && inbodysection[1] == y)
    {
      return true;
    }
  }
  return false;
}

function eatfood(x, y)
{
  if(x == wriggler.nextfood[0] && y == wriggler.nextfood[1])
  {
    //dump("food eaten\n");
    wriggler.score++;
    document.getElementById("currentscore").setAttribute("value", wriggler.score);
    if ((wriggler.score % 10) == 0)
    {
      level++;
      halt();
      unhalt();
      document.getElementById("currentlevel").setAttribute("value", level);
    }
    wriggler.togrow += 2;
    drawfood();
  }
}

function preload_images()
{
	var imgs = [
		"headnorth",
		"headsouth",
		"headeast",
		"headwest",
		"bodynorthsouth",
		"bodyeastwest",
		"bodynortheast",
		"bodynorthwest",
		"bodysoutheast",
		"bodysouthwest",
		"tailnorth",
		"tailsouth",
		"taileast",
		"tailwest",
		"smashnorth",
		"smashsouth",
		"smasheast",
		"smashwest",
		"food"];
	for (var i=0; i<imgs.length; i++)
	{
		var istr = "";
		if (i<10) {
			istr = "0" + i;
		} else {
			istr = "" + i;
		}
		document.getElementById("r00c" + istr ).setAttribute("class", imgs[i]);
	}
	//document.getElementById("r00c00").setAttribute("class", "off");
}