var pagman;
var move = null;
var temp = null;
var ghostMove = null;
var ghostDir = null;
var powerTime = null;
var speed = 1;
var ghostspeed = 1;
var gridWidth = 28;
var gridHeight = 31;
var gridCellWidth = 16;
var gridCellHeight = 16;
var gridWidthPx = gridWidth*gridCellWidth;
var gridHeightPx = gridHeight*gridCellHeight;
var ghostNum = 0;
var startGameNum = 0;
var players = 1;
var currentPlayer = null;
var specialString = "";

var moveCells = new Array();
moveCells[0] = "dot";
moveCells[1] = "blank";
moveCells[2] = "powerup";

var ghosts = new Array();

var ghostClassName = "ghost";
var idleClassName = "idle";
var rightClassName = "right";
var leftClassName = "left";
var upClassName = "up";
var downClassName = "down";
var scaredClassName = "scared";
var deadClassName = "dead";


function onWindowLoad(){
  pagman = new pagman();
  pagman.el.setAttribute("left", (pagman.startCellIndex*gridCellWidth));
  pagman.el.setAttribute("top", (pagman.startRowIndex*gridCellHeight));

  ghosts[0] = new ghost("pink-ghost");
  ghosts[1] = new ghost("red-ghost");
  ghosts[2] = new ghost("green-ghost");
  ghosts[3] = new ghost("yellow-ghost");

  player1 = new player(1, "first-up");
  player2 = new player(2, "second-up");
  player2.bgGridEl.setAttribute("hidden", "true");
  currentPlayer = player1;

  player1.buildDotArray();
  player2.buildDotArray();
}

function loadGame(num){
  if (specialString.toLowerCase() == "mozillarules")
    loadSpecial();
  else
    specialString = "";

  players = num;
  if (num == 1){
    player2.lives = -1;
    player2.gameOver = true;
  }

  // we need to move this to the bottom of the stack instead
  //document.getElementById("openingpage").setAttribute("hidden", "true");
  document.getElementById("openingpage").parentNode.insertBefore(
	  document.getElementById("openingpage"),
	  document.getElementById("openingpage").parentNode.firstChild);

  document.getElementById("credit").setAttribute("value", currentPlayer.lives);
  //move = setInterval("movePag()", (200/speed));
  move = setInterval("movePag()", (300/speed));
  startGame();
}

function loadSpecial(){
  ghostClassName = "ie-ghost";
  idleClassName = "moz-idle";
  rightClassName = "moz-right";
  leftClassName = "moz-left";
  upClassName = "moz-up";
  downClassName = "moz-down";
  scaredClassName = "ie-scared";
  deadClassName = "moz-dead";
 
  pagman.el.className = idleClassName;

  len = ghosts.length;
  for(g=0; g<len;g++){
    ghosts[g].el.className = ghostClassName;
  }
}

function enterSpecial(which){
  specialString += which;
  if (specialString.toLowerCase() == "mozillarules")
    alert("You Have Found The Secret Mozilla Version of PagMan\nHave Fun!");
}

function buildDotArray(){
  len = this.bgGridEl.childNodes.length
  for (i=0; i<len; i++){
    children = this.bgGridEl.childNodes[i].childNodes;
    childLen = children.length;
    for (j=0; j<childLen; j++){
      if (children[j].className == "dot")
        this.dotArray[this.dotArray.length] = children[j];
    }
  }
}

function resetDotArray(){
  len = this.dotArray.length;
  for (i=0; i<len; i++)
    this.dotArray[i].className = "dot";
}

function resetGame(){
  // put this to top of stack instead
  //document.getElementById("openingpage").removeAttribute("hidden");
  document.getElementById("openingpage").parentNode.appendChild(document.getElementById("openingpage"));

  var highScore = (player1.score > player2.score)?  player1.score : player2.score;
  document.getElementById("high-score").setAttribute("value", highScore);
  document.getElementById("winner").setAttribute("hidden", true);

  clearInterval(move);
  clearInterval(ghostMove);
  clearInterval(ghostDir);
  if (temp)
    clearTimeout(temp);
  if (powerTime)
    clearTimeout(powerTime);
  move = null;
  ghostMove = null;
  ghostDir = null;
  currentPlayer = player1;
  ghostNum = 0;
  startGameNum = 0;
  players = 1;

  player1.dots = 295;
  player1.score = 0
  player1.scoreEl.setAttribute("value", 0);
  player1.lives = 2;
  player1.gameOver = false;
  player1.resetDotArray();
  player1.bgGridEl.removeAttribute("hidden");
  player2.dots = 295;
  player2.score = 0
  player2.scoreEl.setAttribute("value", 0);
  player2.lives = 2;
  player2.gameOver = false; 
  player2.resetDotArray();
  player2.bgGridEl.setAttribute("hidden", "true");
  document.getElementById("credit").setAttribute("value", "");
  specialString = "";
}

function startGame(restart){
  if (restart == true){
    pagman.el.setAttribute("left", (pagman.startCellIndex*gridCellWidth));
    pagman.el.setAttribute("top", (pagman.startRowIndex*gridCellHeight));
    pagman.currentRowIndex = pagman.startRowIndex;
    pagman.currentCellIndex = pagman.startCellIndex;
    pagman.currentDirection = null;
    pagman.el.className = idleClassName;

    len = ghosts.length;
    for(f=0; f<len; f++){
      ghosts[f].sendToJail();
    }

    switchPlayer();
    document.getElementById("gameover").setAttribute("hidden", "true");
  }

  if (player1.gameOver == true && player2.gameOver == true){
    gameOver();
    if (players == 2)
      setTimeout("resetGame()", 3000);
    else
      resetGame();
    return false;
  }

  if (startGameNum == 0){
    document.getElementById("player").setAttribute("value", ("Player "+currentPlayer.number));
    document.getElementById("ready").removeAttribute("hidden");
    startGameNum = 1;
    setTimeout("startGame()", 1000);
  }
  else{
    document.getElementById("ready").setAttribute("hidden", "true");
    document.getElementById("gobox").removeAttribute("hidden");
    pagman.isDead = false;
    startGhosts();
    setTimeout("document.getElementById('gobox').setAttribute('hidden', 'true')", 1000);
    startGameNum = 0;
  }    
}

function startGhosts(){
  if (ghosts[ghostNum].inJail == true){
    ghosts[ghostNum].currentRowIndex = 11;
    ghosts[ghostNum].currentCellIndex = 12;
    ghosts[ghostNum].el.setAttribute("top", (ghosts[ghostNum].startOutRowIndex*gridCellHeight));
    ghosts[ghostNum].el.setAttribute("left", (ghosts[ghostNum].startOutCellIndex*gridCellWidth));
    ghosts[ghostNum].changeDir();
    ghosts[ghostNum].inJail = false;
  }
  if (ghostMove == null)
    ghostMove = setInterval("moveGhosts()", (300/ghostspeed));
  if (ghostNum < (ghosts.length-1)){
    ghostNum++;
    setTimeout("startGhosts()", 1000);
  }
  else{
    ghostDir = setInterval("ghostChangeDir()", 3000);
    ghostNum = 0;
  }
}

function pagman(){
  this.el = document.getElementById("pagman");
  this.width = gridCellWidth;
  this.height = gridCellHeight;
  this.currentRowIndex = 23;
  this.currentCellIndex = 14;
  this.startRowIndex = 23;
  this.startCellIndex = 14;
  this.currentDirection = null;
  this.isDead = true;
  this.moveRight = moveRight;
  this.moveLeft = moveLeft;
  this.moveUp = moveUp;
  this.moveDown = moveDown;
  this.pass = pass;
  this.hitCheck = hitCheck;
  this.canGo = canGo;
}

function ghost(which){
  this.el = document.getElementById(which);
  this.width = gridCellWidth;
  this.height = gridCellHeight;
  this.currentRowIndex = 13;
  this.currentCellIndex = 13;
  this.startRowIndex = 13;
  this.startCellIndex = 13;
  this.startOutRowIndex = 11;
  this.startOutCellIndex = 12;
  this.currentDirection = null;
  this.scared = false;
  this.inJail = true;
  this.moveRight = moveRight;
  this.moveLeft = moveLeft;
  this.moveUp = moveUp;
  this.moveDown = moveDown;
  this.pass = pass;
  this.hitCheck = hitCheck;
  this.changeDir = changeDir;
  this.canGo = canGo;
  this.sendToJail = sendToJail;
}

function player(num, scoreEl){
  this.number = num;
  this.dots = 295;
  this.score = parseInt(document.getElementById(scoreEl).getAttribute("value"));
  this.lives = 2;
  this.gameOver = false;
  this.scoreEl = document.getElementById(scoreEl);
  this.bgGridEl = document.getElementById("bgGrid"+num);
  this.dotArray = new Array();
  this.buildDotArray = buildDotArray;
  this.resetDotArray = resetDotArray;
}

function setPagDir(dir){
  if (pagman.isDead == true)
    return false;
  if (pagman.canGo(dir)){
    if (temp != null)
      clearTimeout(temp);
    pagman.currentDirection = dir;
    ghostChangeDir();
  }
  else{
    if (temp != null)
      clearTimeout(temp);
    func = "setPagDir(\""+dir+"\")";
    temp = setTimeout(func, 100);
  }
}

function movePag(){
  if (pagman.isDead == true)
    return false;
  dir = pagman.currentDirection;
  if (dir == "right"){
    if (pagman.moveRight()){
      pagman.el.className = rightClassName;
      pagman.hitCheck();
    }
  }
  else if (dir == "left"){
    if (pagman.moveLeft()){
      pagman.el.className = leftClassName;
      pagman.hitCheck();
    }
  }
  else if (dir == "up"){
    if (pagman.moveUp()){
      pagman.el.className = upClassName;
      pagman.hitCheck();
    }
  }
  else if (dir == "down"){
    if (pagman.moveDown()){
      pagman.el.className = downClassName;
      pagman.hitCheck();
    }
  }
  else
    pagman.hitCheck();

  currentPlayer.scoreEl.setAttribute("value", currentPlayer.score);

  if (currentPlayer.dots <= 0){
    finish(false, currentPlayer);
  }
}

function moveGhosts(){
  if (pagman.isDead == true)
    return false;
  len = ghosts.length;
  for (i=0; i<len; i++){
    if (ghosts[i].inJail == false){
      dir = ghosts[i].currentDirection;
      if (dir == "right"){
        if (ghosts[i].moveRight())
          ghosts[i].hitCheck();
        else
          ghosts[i].changeDir();
      }
      else if (dir == "left"){
        if (ghosts[i].moveLeft())
          ghosts[i].hitCheck();
        else
          ghosts[i].changeDir();
      }
      else if (dir == "up"){
        if (ghosts[i].moveUp())
          ghosts[i].hitCheck();
        else
          ghosts[i].changeDir();
      }
      else if (dir == "down"){
        if (ghosts[i].moveDown())
          ghosts[i].hitCheck();
        else
          ghosts[i].changeDir();
      }
    }
  }
}

function ghostChangeDir(){
  if (pagman.isDead == true)
    return false;
  len = ghosts.length;
  for (b=0; b<len; b++){
    if (ghosts[b].inJail == false){
      if (ghosts[b].scared == true){
        if (pagman.currentDirection == "up" || pagman.currentDirection == "down"){
          if (ghosts[b].currentDirection == "up" || ghosts[b].currentDirection == "down"){
            if (ghosts[b].currentCellIndex > pagman.currentCellIndex){
              if (ghosts[b].canGo("right"))
                ghosts[b].currentDirection = "right";
            }
            else if (ghosts[b].currentCellIndex < pagman.currentCellIndex){
              if (ghosts[b].canGo("left"))
                ghosts[b].currentDirection = "left";
            }
          }
          else{
            if (ghosts[b].currentRowIndex < pagman.currentRowIndex){
              if (ghosts[b].canGo("up"))
                ghosts[b].currentDirection = "up";
            }
            else if (ghosts[b].currentRowIndex > pagman.currentRowIndex){
              if (ghosts[b].canGo("down"))
                ghosts[b].currentDirection = "down";
            }
          }
        }
        else if (pagman.currentDirection == "left" || pagman.currentDirection == "right"){
          if (ghosts[b].currentDirection == "left" || ghosts[b].currentDirection == "right"){
            if (ghosts[b].currentRowIndex < pagman.currentRowIndex){
              if (ghosts[b].canGo("up"))
                ghosts[b].currentDirection = "up";
            }
            else if (ghosts[b].currentRowIndex > pagman.currentRowIndex){
              if (ghosts[b].canGo("down"))
                ghosts[b].currentDirection = "down";
            }
          }
          else{
            if (ghosts[b].currentCellIndex > pagman.currentCellIndex){
              if (ghosts[b].canGo("right"))
                ghosts[b].currentDirection = "right";
            }
            else if (ghosts[b].currentCellIndex < pagman.currentCellIndex){
              if (ghosts[b].canGo("left"))
                ghosts[b].currentDirection = "left";
            }
          }
        }
      }
      else{
        if (pagman.currentDirection == "up" || pagman.currentDirection == "down"){
          if (ghosts[b].currentDirection == "up" || ghosts[b].currentDirection == "down"){
            if (ghosts[b].currentCellIndex < pagman.currentCellIndex){
              if (ghosts[b].canGo("right"))
                ghosts[b].currentDirection = "right";
            }
            else if (ghosts[b].currentCellIndex > pagman.currentCellIndex){
              if (ghosts[b].canGo("left"))
                ghosts[b].currentDirection = "left";
            }
          }
          else{
            if (ghosts[b].currentRowIndex > pagman.currentRowIndex){
              if (ghosts[b].canGo("up"))
                ghosts[b].currentDirection = "up";
            }
            else if (ghosts[b].currentRowIndex < pagman.currentRowIndex){
              if (ghosts[b].canGo("down"))
                ghosts[b].currentDirection = "down";
            }
          }
        }
        else if (pagman.currentDirection == "left" || pagman.currentDirection == "right"){
          if (ghosts[b].currentDirection == "left" || ghosts[b].currentDirection == "right"){
            if (ghosts[b].currentRowIndex > pagman.currentRowIndex){
              if (ghosts[b].canGo("up"))
                ghosts[b].currentDirection = "up";
            }
            else if (ghosts[b].currentRowIndex < pagman.currentRowIndex){
              if (ghosts[b].canGo("down"))
                ghosts[b].currentDirection = "down";
            }
          }
          else{
            if (ghosts[b].currentCellIndex < pagman.currentCellIndex){
              if (ghosts[b].canGo("right"))
                ghosts[b].currentDirection = "right";
            }
            else if (ghosts[b].currentCellIndex > pagman.currentCellIndex){
              if (ghosts[b].canGo("left"))
                ghosts[b].currentDirection = "left";
            }
          }
        }
      }
    }
  }
}

function moveRight(){
  if (pagman.isDead == true)
    return false;
  if (this.canGo("right")){
    var left = parseInt(this.el.getAttribute("left"));
    var right = left+this.width;
    if (right < gridWidthPx){
      this.el.setAttribute("left", left+gridCellWidth);
      this.currentCellIndex++;
      return true;
    }
  }
  return false;
}

function moveLeft(){
  if (pagman.isDead == true)
    return false;
  if (this.canGo("left")){
    var left = parseInt(this.el.getAttribute("left"));
    if (left > 0){
      this.el.setAttribute("left", left-gridCellWidth);
      this.currentCellIndex--;
      return true;
    }
  }
  return false;
}

function moveUp(){
  if (pagman.isDead == true)
    return false;
  if (this.canGo("up")){
    var top = parseInt(this.el.getAttribute("top"));
    if (top > 0){
      this.el.setAttribute("top", top-gridCellHeight);
      this.currentRowIndex--;
      return true;
    }
  }
  return false;
}

function moveDown(){
  if (pagman.isDead == true)
    return false;
  if (this.canGo("down")){
    var top = parseInt(this.el.getAttribute("top"));
    var bottom = top+this.height;
    if (bottom < gridHeightPx){
      this.el.setAttribute("top", top+gridCellHeight);
      this.currentRowIndex++;
      return true;
    }
  }
  return false;
}

function canGo(dir){
  if (pagman.isDead == true)
    return false;
  var cell;
  if (dir == "right")
    cell = getCellAt(this.currentRowIndex, (this.currentCellIndex+1));
  else if (dir == "left")
    cell = getCellAt(this.currentRowIndex, (this.currentCellIndex-1));
  else if (dir == "down")
    cell = getCellAt((this.currentRowIndex+1), this.currentCellIndex);
  else if (dir == "up")
    cell = getCellAt((this.currentRowIndex-1), this.currentCellIndex);
  else
    return false;

  var len = moveCells.length;
  for (j=0; j<len; j++){
    if (cell.className == moveCells[j])
      return cell;
  }
  return false;
}

function getCellAt(row, left){
  if (pagman.isDead == true)
    return false;
  var grid = currentPlayer.bgGridEl;
  var row = grid.childNodes[row];
  var cell = row.childNodes[left];
  return cell;
}


function hitCheck(){
  if (pagman.isDead == true)
    return false;

  cell = getCellAt(this.currentRowIndex, this.currentCellIndex);

  if (this == pagman){
    if (cell.className == "dot"){
      currentPlayer.score += 50;
      cell.className = "blank";
      currentPlayer.dots--;
    }
    else if (cell.className == "powerup"){
      currentPlayer.score += 100;
      cell.className = "blank"
      powerUp();
    }
  }
  len = ghosts.length;
  for(d=0; d<len; d++){
    if ((ghosts[d].currentRowIndex == pagman.currentRowIndex) && (ghosts[d].currentCellIndex == pagman.currentCellIndex)){
      if (ghosts[d].scared){
        ghosts[d].sendToJail();
        currentPlayer.score += 500;
      }
      else
        finish(true, currentPlayer);

      break;
    }
  }

  var passDir = cell.getAttribute("pass");
  if (passDir != "" && passDir != this.currentDirection){
    this.pass(passDir);
  }
}

function finish(isDead, player){
  if (player != currentPlayer)
    return;
  if (isDead){
    pagman.isDead = true;
    currentPlayer.lives--;
    pagman.el.className = deadClassName;
    if (currentPlayer.lives < 0){
      gameOver(currentPlayer);
      setTimeout("startGame(true)", 5000);
    }
    else
      setTimeout("startGame(true)", 2000);
  }
  else{
    pagman.el.setAttribute("left", (pagman.startCellIndex*gridCellWidth));
    pagman.el.setAttribute("top", (pagman.startRowIndex*gridCellHeight));
    pagman.currentRowIndex = pagman.startRowIndex;
    pagman.currentCellIndex = pagman.startCellIndex;
    pagman.currentDirection = null;
    pagman.el.className = idleClassName;

    len = ghosts.length;
    for(f=0; f<len; f++){
      ghosts[f].sendToJail();
    }
    gameOver();
    setTimeout("resetGame()", 3000);   
  }
}

function powerUp(){
  if (pagman.isDead == true)
    return false;
  if (powerTime != null)
    clearTimeout(powerTime);
  len = ghosts.length;
  for(a=0; a<len; a++){
    if (ghosts[a].inJail == false){
      ghosts[a].scared = true;
      ghosts[a].el.className = scaredClassName;
    }
  }
  powerTime = setTimeout("resetGhosts()", 10000);
}

function resetGhosts(){
  len = ghosts.length;
  for(c=0; c<len;c++){
    ghosts[c].scared = false;
    ghosts[c].el.className = ghostClassName;
  }
  startGhosts();
}

function sendToJail(){
  this.inJail = true;
  this.el.setAttribute("top", (this.startRowIndex*gridCellHeight));
  this.el.setAttribute("left", (this.startCellIndex*gridCellWidth));
  this.el.className = ghostClassName;
  this.currentRowIndex = 13;
  this.currentCellIndex = 13;
}

function pass(dir){
  if (pagman.isDead == true)
    return false;
  if (dir == "left"){
    this.currentCellIndex = 0;
    this.el.setAttribute("left", 0);
    this.hitCheck();
  }
  else if (dir == "right"){
    this.currentCellIndex = gridWidth-1;
    this.el.setAttribute("left", gridWidthPx-this.width);
    this.hitCheck();
  }
  else if (dir == "up"){
    this.currentRowIndex = 0;
    this.el.setAttribute("top", 0);
    this.hitCheck();
  }
  else if (dir == "down"){
    this.currentRowIndex = gridHeight-1;
    this.el.setAttribute("top", gridHeightPx-this.height);
    this.hitCheck();
  }
  else
    return false;
}

function changeDir(){
  if (pagman.isDead == true)
    return false;
  dir = this.currentDirection;
  if (dir == "left" || dir == "right"){
    if (Math.round(Math.random()) == 0){
      if (this.canGo("up"))
        this.currentDirection = "up";
      else if (this.canGo("down"))
        this.currentDirection = "down";
    }
    else{
      if (this.canGo("down"))
        this.currentDirection = "down";
      else if (this.canGo("up"))
        this.currentDirection = "up";
    }
  }
  else if (dir == "up" || dir == "down"){
    if (Math.round(Math.random()) == 0){
      if (this.canGo("left"))
        this.currentDirection = "left";
      else if (this.canGo("right"))
        this.currentDirection = "right";
    }
    else{
      if (this.canGo("right"))
        this.currentDirection = "right";
      else if (this.canGo("left"))
        this.currentDirection = "left";
    }
  }
  else{
    num = generate(0,3);
    switch(num){
      case 0:
        this.currentDirection = "right";
        break;
      case 1:
        this.currentDirection = "left";
        break;
      case 2:
        this.currentDirection = "up";
        break;
      case 3:
        this.currentDirection = "down";
        break;
      deafult:
        return false;
    }
  }
}

function generate(x, y) {
  var range = y-x+1;
  var l = ("" + range).length;
  var num = (Math.floor(Math.random() * Math.pow(10,l)) %
  range) + parseInt(x);
  return num;
}

function switchPlayer(){
  if (currentPlayer == player1){
    if (player2.lives >= 0){
      player1.bgGridEl.setAttribute("hidden", "true");
      player2.bgGridEl.removeAttribute("hidden");
      currentPlayer = player2;
    }
  }
  else{
    if (player1.lives >= 0){
      player2.bgGridEl.setAttribute("hidden", "true");
      player1.bgGridEl.removeAttribute("hidden");
      currentPlayer = player1;
    }
  }
  document.getElementById("credit").setAttribute("value", currentPlayer.lives);
}

function gameOver(which){
  if (which != null){
    which.gameOver = true;
    document.getElementById("player").setAttribute("value", ("Player "+which.number));
    document.getElementById("gameover").removeAttribute("hidden");
  }
  else{
    if (player1.score > player2.score)
      document.getElementById("player").setAttribute("value", "Player 1");
    else
      document.getElementById("player").setAttribute("value", "Player 2");

    document.getElementById("winner").removeAttribute("hidden");
  }
}