/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.ui.JRexPrintPreviewToolBar;
import org.mozilla.jrex.ui.JRexResource;

public class JRexPrintPreviewToolBarImpl
implements JRexPrintPreviewToolBar {
    private static final String className = JRexPrintPreviewToolBarImpl.class.getName();
    private static final String PRINT = JRexResource.getString("PT_PRINT");
    private static final String PAGE_SETUP = JRexResource.getString("PT_PAGE_SETUP");
    private static final String PORTRAIT = JRexResource.getString("PT_PORTRAIT");
    private static final String LANDSCAPE = JRexResource.getString("PT_LANDSCAPE");
    private static final String CLOSE = JRexResource.getString("PT_CLOSE");
    private static final String NO_OF_PAGES = JRexResource.getString("PT_NO_OF_PAGES");
    private static Hashtable table = new Hashtable();

    public synchronized void show(JRexCanvas browser, Container browserContainer, Window window) {
        JRexPrintPreviewToolBarUI impl = (JRexPrintPreviewToolBarUI)table.get(window);
        if (impl == null) {
            impl = window instanceof Frame ? new JRexPrintPreviewToolBarUI(browser, (Frame)window) : new JRexPrintPreviewToolBarUI(browser, (Dialog)window);
        }
        table.put(window, impl);
        impl.showUI();
    }

    public synchronized void hide(Window window) {
        JRexPrintPreviewToolBarUI impl = (JRexPrintPreviewToolBarUI)table.get(window);
        if (impl != null) {
            impl.hideUI();
        }
    }

    private static class JRexPrintPreviewToolBarUI
    extends JDialog
    implements ActionListener {
        private JButton printBtn;
        private JButton pageSetupBtn;
        private JButton lpBtn;
        private JButton closeBtn;
        private JLabel label;
        private JRexCanvas browser;
        private Component northComp;
        private boolean isShowing = false;

        JRexPrintPreviewToolBarUI(JRexCanvas browser, Dialog root) {
            super(root, "JRex PrintPreview ToolBar", true);
            this.browser = browser;
            this.createPrintToolBar();
        }

        JRexPrintPreviewToolBarUI(JRexCanvas browser, Frame root) {
            super(root, "JRex PrintPreview ToolBar", true);
            this.browser = browser;
            this.createPrintToolBar();
        }

        private final void createPrintToolBar() {
            Dimension dim = new Dimension(100, 25);
            this.printBtn = new JButton(PRINT);
            this.printBtn.setPreferredSize(dim);
            this.printBtn.addActionListener(this);
            this.pageSetupBtn = new JButton(PAGE_SETUP);
            this.pageSetupBtn.setPreferredSize(dim);
            this.pageSetupBtn.addActionListener(this);
            this.lpBtn = new JButton(LANDSCAPE);
            this.lpBtn.setPreferredSize(dim);
            this.lpBtn.addActionListener(this);
            this.closeBtn = new JButton(CLOSE);
            this.closeBtn.setPreferredSize(dim);
            this.closeBtn.addActionListener(this);
            this.label = new JLabel();
            this.label.setPreferredSize(dim);
            this.getContentPane().setLayout(new FlowLayout());
            this.getContentPane().add(this.printBtn);
            this.getContentPane().add(this.pageSetupBtn);
            this.getContentPane().add(this.lpBtn);
            this.getContentPane().add(this.label);
            this.getContentPane().add(this.closeBtn);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ JRexPrintPreviewToolBarUI this$0;
                {
                    this.this$0 = this$0;
                }

                public void windowClosing(WindowEvent we) {
                    this.this$0.hideUI();
                }
            });
        }

        void showUI() {
            if (this.isShowing) {
                return;
            }
            try {
                this.label.setText(NO_OF_PAGES + ":" + Integer.toString(this.browser.getPrintPreviewNumPages()));
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
            this.pack();
            this.isShowing = true;
            super.show();
        }

        void hideUI() {
            if (this.isShowing) {
                try {
                    this.browser.cancelPrintPreview();
                }
                catch (JRexException ex) {
                    JRexL.printStackTrace(ex);
                }
                this.dispose();
            }
            this.isShowing = false;
            table.remove(this.getParent());
        }

        public void actionPerformed(ActionEvent ae) {
            String action = ae.getActionCommand();
            if (JRexL.on) {
                JRexL.log(className, "**** actionPerformed() -->action <" + action + "> ****");
            }
            try {
                if (action.equals(PRINT)) {
                    this.browser.print(true, true);
                } else if (action.equals(PAGE_SETUP)) {
                    this.browser.pageSetup();
                } else if (action.equals(PORTRAIT)) {
                    this.lpBtn.setText(LANDSCAPE);
                    this.browser.printPreview(true, false);
                    try {
                        while (this.browser.getPrintPreviewNumPages() == 0) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Exception ex) {}
                        }
                        this.label.setText(NO_OF_PAGES + ":" + Integer.toString(this.browser.getPrintPreviewNumPages()));
                    }
                    catch (JRexException ex) {
                        JRexL.printStackTrace(ex);
                    }
                } else if (action.equals(LANDSCAPE)) {
                    this.lpBtn.setText(PORTRAIT);
                    this.browser.printPreview(true, true);
                    try {
                        while (this.browser.getPrintPreviewNumPages() == 0) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Exception ex) {}
                        }
                        this.label.setText(NO_OF_PAGES + ":" + Integer.toString(this.browser.getPrintPreviewNumPages()));
                    }
                    catch (JRexException ex) {
                        JRexL.printStackTrace(ex);
                    }
                } else if (action.equals(CLOSE)) {
                    this.hideUI();
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }
}

