/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.dom.events;

import java.util.Hashtable;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class JRexEventTargetImpl
implements EventTarget {
    private static final String className = JRexEventTargetImpl.class.getName();
    private int peerEvtTarget = 0;
    private Hashtable evtListnerTable = new Hashtable();

    private JRexEventTargetImpl() {
        if (JRexL.on) {
            JRexL.log(className, "**** JRexEventTargetImpl I AM HERE ****");
        }
    }

    public Node getNode() {
        if (JRexL.on) {
            JRexL.log(className, "**** getNode I AM HERE ****");
        }
        Node myNode = null;
        try {
            myNode = this.GetNode();
            if (JRexL.on) {
                JRexL.log(className, "**** getNode myNode<" + myNode + "> ****");
            }
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        return myNode;
    }

    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        if (JRexL.on) {
            JRexL.log(className, "**** addEventListener type<" + type + "> listener<" + listener + "> useCapture<" + useCapture + "> ****");
        }
        try {
            EventListenerWrapper wrapObg = new EventListenerWrapper(type, listener, useCapture);
            Integer listnrPeer = (Integer)this.evtListnerTable.get(wrapObg);
            if (JRexL.on) {
                JRexL.log(className, "**** addEventListener listnrPeer<" + listnrPeer + "> ****");
            }
            if (listnrPeer != null && listnrPeer > 0) {
                if (JRexL.on) {
                    JRexL.log(className, "**** addEventListener Listener has been already Added!!! ****");
                }
                return;
            }
            int listnrPeerInt = this.AddEventListener(type, listener, useCapture);
            if (JRexL.on) {
                JRexL.log(className, "**** addEventListener listnrPeerInt<" + listnrPeerInt + "> ****");
            }
            if (listnrPeerInt > 0) {
                this.evtListnerTable.put(wrapObg, new Integer(listnrPeerInt));
            }
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        if (JRexL.on) {
            JRexL.log(className, "**** removeEventListener type<" + type + "> listener<" + listener + "> useCapture<" + useCapture + "> ****");
        }
        EventListenerWrapper wrapObg = new EventListenerWrapper(type, listener, useCapture);
        try {
            Integer listnrPeer = (Integer)this.evtListnerTable.get(wrapObg);
            if (JRexL.on) {
                JRexL.log(className, "**** removeEventListener listnrPeer<" + listnrPeer + "> ****");
            }
            if (listnrPeer != null && listnrPeer > 0) {
                this.RemoveEventListener(type, listnrPeer, useCapture);
            }
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        this.evtListnerTable.remove(wrapObg);
    }

    public boolean dispatchEvent(Event evt) throws EventException {
        if (JRexL.on) {
            JRexL.log(className, "**** dispatchEvent evt<" + evt + "> ****");
        }
        boolean retVal = false;
        try {
            retVal = this.DispatchEvent(evt);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** dispatchEvent retVal<" + retVal + "> ****");
        }
        return retVal;
    }

    public boolean equals(Object obj) {
        if (JRexL.on) {
            JRexL.log(className, "**** equals obj<" + obj + "> ****");
        }
        if (!(obj instanceof JRexEventTargetImpl)) {
            return false;
        }
        return ((JRexEventTargetImpl)obj).peerEvtTarget == this.peerEvtTarget;
    }

    public int hashCode() {
        if (JRexL.on) {
            JRexL.log(className, "**** hashCode ****");
        }
        return this.peerEvtTarget;
    }

    protected void finalize() throws Throwable {
        if (JRexL.on) {
            JRexL.log(className, "**** finalize ****");
        }
        this.dispose();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (JRexL.on) {
            JRexL.log(className, "**** dispose ****");
        }
        if (this.peerEvtTarget != 0) {
            try {
                this.Finalize();
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
            finally {
                this.peerEvtTarget = 0;
            }
        }
    }

    private native Node GetNode() throws JRexException;

    private native int AddEventListener(String var1, EventListener var2, boolean var3) throws JRexException;

    private native void RemoveEventListener(String var1, int var2, boolean var3) throws JRexException;

    private native boolean DispatchEvent(Event var1) throws EventException, JRexException;

    private native void Finalize() throws JRexException;

    private class EventListenerWrapper {
        String type;
        EventListener listener;
        boolean useCapture;

        EventListenerWrapper(String type, EventListener listener, boolean useCapture) {
            this.type = type;
            this.listener = listener;
            this.useCapture = useCapture;
        }

        public int hashCode() {
            return this.type.hashCode() + this.listener.hashCode() + Boolean.toString(this.useCapture).hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EventListenerWrapper)) {
                return false;
            }
            return ((EventListenerWrapper)obj).type.equals(this.type) && ((EventListenerWrapper)obj).listener == this.listener && ((EventListenerWrapper)obj).useCapture == this.useCapture;
        }
    }
}

