/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.mozilla.jrex.dom.JRexDocumentImpl;
import org.mozilla.jrex.dom.JRexElementImpl;
import org.mozilla.jrex.dom.JRexNodeImpl;
import org.mozilla.jrex.event.progress.ProgressChangeEventParam;
import org.mozilla.jrex.event.progress.ProgressEvent;
import org.mozilla.jrex.event.progress.ProgressListener;
import org.mozilla.jrex.event.progress.StateChangeEventParam;
import org.mozilla.jrex.event.progress.StatusChangeEventParam;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.ui.JRexResource;
import org.mozilla.jrex.ui.JRexStatusBar;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class JRexStatusBarImpl
implements JRexStatusBar,
ActionListener,
ProgressListener {
    private static final String className = JRexStatusBarImpl.class.getName();
    private static final String ACT_CMD_PI = JRexResource.getString("ACT_CMD_PI");
    private JPanel statusPanel = null;
    private JButton pageInfoBtn = null;
    private JLabel statusLabel = null;
    private JProgressBar progressBar = null;
    private JPanel progressPanel = null;
    private JRexCanvas browser = null;
    private JComponent statusBar = null;

    public JRexStatusBarImpl() {
        this.createStatusBar();
    }

    public synchronized void setBrowser(JRexCanvas browser) {
        if (this.browser != null) {
            this.browser.removeProgressListener(this);
        }
        this.statusLabel.setText("");
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(false);
        this.progressPanel.remove(this.progressBar);
        this.browser = browser;
        this.browser.addProgressListener(this);
    }

    public void setMode(int mode) {
    }

    public JComponent getStatusBar() {
        if (this.statusBar == null) {
            this.createStatusBar();
        }
        return this.statusBar;
    }

    private void createStatusBar() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.statusPanel = new JPanel(gbl);
        this.pageInfoBtn = new JButton(JRexResource.getIcon(ACT_CMD_PI));
        this.pageInfoBtn.setActionCommand(ACT_CMD_PI);
        this.pageInfoBtn.addActionListener(this);
        this.pageInfoBtn.setPreferredSize(new Dimension(20, 20));
        this.pageInfoBtn.setBorderPainted(false);
        this.pageInfoBtn.setFocusable(false);
        this.statusLabel = new JLabel();
        this.statusLabel.setForeground(Color.black);
        this.statusLabel.setPreferredSize(new Dimension(200, 20));
        this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(100, 20));
        Insets inset = new Insets(0, 2, 0, 0);
        JRexStatusBarImpl.addCompToGridBag(this.pageInfoBtn, this.statusPanel, gbc, gbl, 0, 0, 1, 1, 0.0, 0.0, 17, 0, inset, 0, 0);
        JRexStatusBarImpl.addCompToGridBag(this.statusLabel, this.statusPanel, gbc, gbl, 1, 0, 1, 1, 0.8, 0.0, 17, 2, inset, 0, 0);
        this.progressPanel = new JPanel(new BorderLayout());
        JRexStatusBarImpl.addCompToGridBag(this.progressPanel, this.statusPanel, gbc, gbl, 2, 0, 1, 1, 0.0, 0.0, 17, 0, inset, 0, 0);
        this.statusBar = this.statusPanel;
    }

    private static final void addCompToGridBag(Component comp, JPanel panel, GridBagConstraints gbc, GridBagLayout gbl, int gx, int gy, int gw, int gh, double wx, double wy, int anchor, int fill, Insets i, int ix, int iy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.anchor = anchor;
        gbc.fill = fill;
        gbc.insets = i;
        gbc.ipadx = ix;
        gbc.ipady = iy;
        gbl.setConstraints(comp, gbc);
        panel.add(comp);
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            this.browser.getNavigator().openWindow((short)0, "chrome://navigator/content/pageInfo.xul", null, "JRexCanvas - ", "centerscreen,chrome,modal,titlebar");
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void onStateChange(ProgressEvent event) {
        StateChangeEventParam scep;
        int statusFlag;
        if (JRexL.on) {
            JRexL.log(className, "**** onStateChange() -->event<" + event + "> param<" + event.getEventTypeParam() + ">****");
        }
        if (((statusFlag = (scep = (StateChangeEventParam)event.getEventTypeParam()).getStateFlags()) & 1) == 1 || (statusFlag & 0x10000) == 65536) {
            this.progressBar.setValue(0);
            this.progressBar.setIndeterminate(true);
            if (this.progressPanel.getComponents().length == 0) {
                this.progressPanel.add(this.progressBar);
                this.statusPanel.validate();
            }
        } else if ((statusFlag & 0x10) == 16 || (statusFlag & 0x40000) == 262144 || (statusFlag & 0x10000) == 65536) {
            this.progressBar.setIndeterminate(false);
            this.progressPanel.remove(this.progressBar);
            this.statusPanel.validate();
            this.statusLabel.setText(" Done.");
        }
    }

    private void dumpNodes1(Node node) throws Exception {
        NodeList list = node.getChildNodes();
        int len = list.getLength();
        if (JRexL.on) {
            JRexL.log(className, "**** dumpNodes() -->len<" + len + "> ****");
        }
        for (int i = 0; i < len; ++i) {
            if (JRexL.on) {
                JRexL.log(className, "**** dumpNodes() -->list<" + i + "> item<" + list.item(i) + "> ****");
            }
            if (list.item(i) instanceof JRexElementImpl) {
                Node jobj = list.item(i);
                if (JRexL.on) {
                    JRexL.log(className, "**** dumpNodes() -->jobj<" + jobj + "> ****");
                }
            }
            this.dumpNodes1(list.item(i));
        }
    }

    private Node dumpNodes(Node node, String name) throws Exception {
        NodeList list = node.getChildNodes();
        int len = list.getLength();
        if (JRexL.on) {
            JRexL.log(className, "**** dumpNodes() -->len<" + len + "> ****");
        }
        for (int i = 0; i < len; ++i) {
            if (JRexL.on) {
                JRexL.log(className, "**** dumpNodes() -->list<" + i + "> item<" + list.item(i) + "> ****");
            }
            if (list.item(i).getNodeName().equalsIgnoreCase(name)) {
                return list.item(i);
            }
            Node bullNode = this.dumpNodes(list.item(i), name);
            if (bullNode == null) continue;
            if (JRexL.on) {
                JRexL.log(className, "**** %%%%%%%%%%%%%%%%%%%%%%%% MATCH %%%%%%%%%%%%%%%%%%%%%%%% ****");
            }
            return bullNode;
        }
        return null;
    }

    private void doDOMClick() {
        try {
            JRexDocumentImpl myDoc = (JRexDocumentImpl)this.browser.getNavigator().getDocument();
            if (JRexL.on) {
                JRexL.log(className, "**** doDOMClick() -->myDoc<" + myDoc + "> ****");
            }
            JRexNodeImpl myNode = (JRexNodeImpl)this.dumpNodes(myDoc, "FORM");
            if (JRexL.on) {
                JRexL.log(className, "**** doDOMClick() -->myNode<" + myNode + "> ****");
            }
            if (myNode == null) {
                myNode = myDoc;
            }
            EventTarget relatedEventTarget = myNode.getEventTarget();
            if (JRexL.on) {
                JRexL.log(className, "**** doDOMClick() -->relatedEventTarget<" + relatedEventTarget + "> ****");
            }
            DocumentEvent docEvent = myDoc.getDocumentEvent();
            if (JRexL.on) {
                JRexL.log(className, "**** doDOMClick() -->docEvent<" + docEvent + "> ****");
            }
            Event mEvent = docEvent.createEvent("HTMLEvents");
            if (JRexL.on) {
                JRexL.log(className, "**** doDOMClick() -->mEvent<" + mEvent + "> ****");
            }
            mEvent.initEvent("submit", true, true);
            relatedEventTarget.dispatchEvent(mEvent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onLocationChange(ProgressEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** onLocationChange() -->event<" + event + "> param<" + event.getEventTypeParam() + ">****");
        }
    }

    public void onStatusChange(ProgressEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** onStatusChange() -->event<" + event + "> param<" + event.getEventTypeParam() + ">****");
        }
        StatusChangeEventParam scev = (StatusChangeEventParam)event.getEventTypeParam();
        this.statusLabel.setText(scev.getStatusMessage());
    }

    public void onSecurityChange(ProgressEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** onSecurityChange() -->event<" + event + "> param<" + event.getEventTypeParam() + ">****");
        }
    }

    public void onProgressChange(ProgressEvent event) {
        ProgressChangeEventParam pcep;
        int maxVal;
        if (JRexL.on) {
            JRexL.log(className, "**** onProgressChange() -->event<" + event + "> param<" + event.getEventTypeParam() + ">****");
        }
        if ((maxVal = (pcep = (ProgressChangeEventParam)event.getEventTypeParam()).getMaximumSelfProgress()) == -1) {
            this.progressBar.setIndeterminate(true);
            return;
        }
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMaximum(maxVal);
        this.progressBar.setValue(pcep.getCurrentSelfProgress());
    }

    public void onLinkStatusChange(ProgressEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** onLinkStatusChange() -->event<" + event + "> param<" + event.getEventTypeParam() + ">****");
        }
        StatusChangeEventParam scep = (StatusChangeEventParam)event.getEventTypeParam();
        this.statusLabel.setText(scep.getStatusMessage());
    }
}

