/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * c:/builds/1813/mozilla/extensions/webservices/public/nsIWebServiceProxy.idl
 */

package org.mozilla.interfaces;

public interface nsIWebServiceProxyFactory extends nsISupports {

  String NS_IWEBSERVICEPROXYFACTORY_IID =
    "{693611be-bb38-40e0-a98e-b46ff8a5bcca}";

  /**
   * Create a service proxy. Loading of the WSDL URL will occur
   * in a synchronous manner. Calls to web service can be made as
   * soon as this method completes.
   *
   * @param wsdlURL The URL of the WSDL service description. This
   *                description will be loaded and used as the basis
   *                for the service proxy.
   * @param portname The name of the port of the service that this 
   *                 service proxy represents. Currently the port
   *                 must represent a SOAP binding.
   * @param qualifier The user-specified qualifier is incorporated into
   *                  the names of XPCOM interfaces created for the 
   *                  service proxy. For C++ callers, this qualifier 
   *                  should be the  same one used in creating the IDL 
   *                  used at compile time. Script callers need not 
   *                  specify a qualifier.
   * @param isAsync If PR_TRUE, the method signatures of the service
   *                proxy represent an asynchronous calling convention.
   *                A callback instance must be registered with the proxy.
   *                A method call to a web service is only completed when
   *                the corresponding callback method is invoked.
   *                If PR_FALSE, the method signatures of the service
   *                proxy represent a synchronous callling convention.
   *                A method call to a web service is completed when the
   *                method call to the proxy returns.
   */
  nsIWebServiceProxy createProxy(String wsdlURL, String portname, String qualifier, boolean isAsync);

  /**
   * Create a service proxy. Loading of the WSDL URL will occur
   * in an asynchronous manner. Methods on the listener instance will
   * be invoked when the proxy has been created. Any method invocations
   * on the service proxy prior to asynchronous completion of the 
   * intialization step will fail. The caller is guaranteed that this
   * method will return before the listener is invoked.
   *
   * @param wsdlURL The URL of the WSDL service description. This
   *                description will be loaded and used as the basis
   *                for the service proxy.
   * @param portname The name of the port of the service that this 
   *                 service proxy represents. Currently the port
   *                 must represent a SOAP binding.
   * @param qualifier The user-specified qualifier is incorporated into
   *                  the names of XPCOM interfaces created for the 
   *                  service proxy. For C++ callers, this qualifier 
   *                  should be the same one used in creating the IDL 
   *                  used at compile time. Script callers need not 
   *                  specify a qualifier.
   * @param isAsync If PR_TRUE, the method signatures of the service
   *                proxy represent an asynchronous calling convention.
   *                A callback instance must be registered with the proxy.
   *                A method call to a web service is only completed when
   *                the corresponding callback method is invoked.
   *                If PR_FALSE, the method signatures of the service
   *                proxy represent a synchronous callling convention.
   *                A method call to a web service is completed when the
   *                method call to the proxy returns.
   * @param listener The callback instance which will be invoked when
   *                 the proxy is completely initialized.
   */
  void createProxyAsync(String wsdlURL, String portname, String qualifier, boolean isAsync, nsIWebServiceProxyCreationListener listener);

}