#include "HRBitset.h"
#include <prmem.h>
#include "common.h"
#include <algorithm>

NS_IMPL_ISUPPORTS1_CI(HRBitset, IHRBitset)

HRBitset::HRBitset()
{}

HRBitset::HRBitset(const value_type& other_bits)
  : mBits(other_bits)
{}

HRBitset::~HRBitset()
{}

/* void setBit (in unsigned long idx); */
NS_IMETHODIMP HRBitset::SetBit(PRUint32 idx)
{
  if(idx >= mBits.size()) {
    mBits.resize(idx+1);
  }

  mBits.set(idx, 1);
  return NS_OK;
}

/* void clearBit (in unsigned long idx); */
NS_IMETHODIMP HRBitset::ClearBit(PRUint32 idx)
{
  if(idx >= mBits.size()) {
    mBits.resize(idx+1);
  }

  mBits.set(idx, 0);
  return NS_OK;
}

/* boolean testBit (in unsigned long idx); */
NS_IMETHODIMP HRBitset::TestBit(PRUint32 idx, PRBool *_retval)
{
  if(idx >= mBits.size()) {
    return NS_ERROR_INVALID_ARG;
  }

  *_retval = mBits.test(idx);
  return NS_OK;
}

/* void flip (); */
NS_IMETHODIMP HRBitset::Flip()
{
  mBits.flip();
  return NS_OK;
}

/* void and (in IHRBitset other); */
NS_IMETHODIMP HRBitset::And(IHRBitset *other)
{
  if(unlikely(!other)) {
    return NS_ERROR_NULL_POINTER;
  }

  MatchSize(other);

  // XXX: this is evil, but oh so seductively efficient
  mBits &= static_cast<HRBitset*>(other)->mBits;
  return NS_OK;
}

/* IHRBitset clone (); */
NS_IMETHODIMP HRBitset::Clone(IHRBitset **_retval)
{
  *_retval = new HRBitset(mBits);
  NS_ADDREF(*_retval);
  return NS_OK;
}

/* void expandTo (in unsigned long size); */
NS_IMETHODIMP HRBitset::ExpandTo(PRUint32 size)
{
  if(mBits.size() < size) {
    mBits.resize(size);
  }

  return NS_OK;
}

/* void matchSize (in IHRBitset bitset); */
NS_IMETHODIMP HRBitset::MatchSize(IHRBitset *bitset)
{
  if(unlikely(!bitset)) {
    return NS_ERROR_NULL_POINTER;
  }

  HRBitset* other = static_cast<HRBitset*>(bitset);
  size_t this_size = mBits.size();
  size_t other_size = other->mBits.size();
  size_t size = std::max(this_size, other_size);
  if(this_size < size) {
    mBits.resize(size);
  }

  if(other_size < size) {
    other->mBits.resize(size);
  }

  return NS_OK;
}

/* unsigned long getHighestBit (); */
NS_IMETHODIMP HRBitset::GetHighestBit(PRUint32 *_retval)
{
  *_retval = 0;

  size_t idx = mBits.size();
  while(--idx >= 0) {
    if(mBits.test(idx)) {
      *_retval = idx + 1;
      break;
    }
  }

  return NS_OK;
}


/* void setBits (in unsigned long low, in unsigned long high); */
NS_IMETHODIMP HRBitset::SetBits(PRUint32 low, PRUint32 high)
{
  if(high >= mBits.size()) {
    mBits.resize(high+1);
  }

  for(; low <= high ; ++low) {
    mBits.set(low, true);
  }

  return NS_OK;
}

/* readonly attribute boolean anyBitSet; */
NS_IMETHODIMP HRBitset::GetAnyBitSet(PRBool *aAnyBitSet)
{
  *aAnyBitSet = mBits.any();
  return NS_OK;
}

/* readonly attribute unsigned long numberBitsSet; */
NS_IMETHODIMP HRBitset::GetNumberBitsSet(PRUint32 *aNumberBitsSet)
{
  *aNumberBitsSet = mBits.count();
  return NS_OK;
}

/* attribute unsigned long size; */
NS_IMETHODIMP HRBitset::GetSize(PRUint32 *aSize)
{
  *aSize = mBits.size();
  return NS_OK;
}
NS_IMETHODIMP HRBitset::SetSize(PRUint32 aSize)
{
  mBits.resize(aSize);
  return NS_OK;
}
