function hrp_open_cmd() {
  var nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"]
    .createInstance(nsIFilePicker);
  fp.init(window, "HRProfiler - Open Profile", nsIFilePicker.modeOpen);
  fp.appendFilter("HRProfiler Files", "*.hrprofiler");
  var rv = fp.show();

  if(rv === nsIFilePicker.returnOK) {
    hrp_open(fp.file, false);
  }
}

function hrp_open(file, is_tmp) {
  window.openDialog('chrome://ffhrtimer/content/ffhrprofiler_results.xul',
                    '_blank',
                    'dialog=no',
                    { db_file: file,
                      is_tmp: is_tmp
                    });
}

function hrp_find_window_by_type(inType) {
  var windowManager = Components.classes[
    '@mozilla.org/appshell/window-mediator;1'].getService();
  var windowManagerInterface = windowManager.QueryInterface(
    Components.interfaces.nsIWindowMediator);
  return windowManagerInterface.getMostRecentWindow(inType);
}

function hrc_start_cmd() {
  var hrc = Components.classes["@merrillpress.com/hrcov;1"];
  if(!hrc) {
    alert("HRCov not available");
    return;
  }

  var w = hrp_find_window_by_type('global:hrcov');
  if(w) {
    w.focus();
  } else {
    window.openDialog(
      'chrome://ffhrtimer/content/ffhrcov_results.xul',
      '_blank', 'dialog=no,toolbar=yes');
  }
}

function hrp_profile_cmd() {
  var hrp = Components.classes["@merrillpress.com/hrprofiler;1"];
  if(!hrp || !hrp.getService()) {
    alert('HRProfiler not available');
    return;
  }
  /* First, get preferences */
  var w = hrp_find_window_by_type(
    "global:hrprofiler-options");

  if(w) {
    w.focus();
    return;
  }

  w = hrp_find_window_by_type(
    "global:hrprofiler-profiling");

  if(w) {
    w.focus();
    return;
  }
  
  var optret = {};
  
  window.openDialog('chrome://ffhrtimer/content/ffhrprofiler_options.xul',
                    '_blank',
                    'modal,centerscreen',
                    {},
                    optret);

  if(!optret.doprofile) {
    return;
  }

  window.openDialog('chrome://ffhrtimer/content/ffhrprofiler_profiling.xul',
                    '_blank',
                    '',
                    {timer: optret.timer});
}

