var sThemeName = "nautipolis";
var sThemeVersion = "1.8";
var sChromeName = "nautipolis_18.jar";

//-------------------------------------------

var iErr;
var iChoice;
var fChrome;
var fJar;
var sChromeNode = sThemeName + "/" + sThemeVersion;
var sRegName    = "skins/mozilla/" + sChromeNode;
var fXPI = getFolder("file:///", jarfile);
var iXPISize = File.size(fXPI);
var iChromeType = SKIN;

iErr = initInstall(sThemeName, sRegName, sThemeVersion);
logComment("initInstall: " + iErr);

iChoice=confirm("Do you want to install " + sThemeName + " into the application chrome folder?\r\nThemes in the application chrome folder can not be uninstalled but are available to all users.\r\nIf you wish to install the theme into your profile folder instead, click the Cancel button.");
if (iChoice){
  fChrome = getFolder("Chrome");
}else{
  iChromeType |= PROFILE_CHROME;
  fChrome = getFolder(getFolder("Profile"),"chrome");
}
logComment("fChrome: " + fChrome);


addFile(sChromeNode, "placeholder", fChrome, sChromeName);
resetError();
fJar = getFolder(fChrome, sChromeName);
iErr = File.copy(fXPI, fJar);
logComment("File.copy() returned: " + iErr);

if (fileGetDiskSpaceAvailable(fChrome) < (iXPISize+10000)){
  cancelInstall(INSUFFICIENT_DISK_SPACE);
  alert("Installation of " + themeName + " theme canceled. Insufficient disk space.");
}else{
  setPackageFolder(fChrome);
  if (iErr == SUCCESS){

    registerChrome(iChromeType, fJar, "");
    iChoice=confirm("You are about to install " + sThemeName + " to \r\n\"" + fJar + ".");
    if(iChoice){
      iErr = performInstall();
      logComment("performInstall() returned: " + iErr);
      if (iErr == SUCCESS){
        alert("Installation of " + sThemeName + " theme finished successfully.");
      }else{
        alert("Installation of " + sThemeName + " theme failed. Error code was " + iErr);
      }
    }else{
      cancelInstall(INSTALL_CANCELLED);
    }

  }else{

    cancelInstall(iErr);
    logComment("cancelInstall due to error: " + iErr);
    alert("cancelInstall due to error: " + iErr);
    if (iErr == -202){
      alert("Installation of " + themeName + " theme canceled with error -202. It seems you have no write permission to the Mozilla 'chrome' directory. Please install as root / system administrator.");
    }else{
      alert("Installation of " + themeName + " theme canceled. Error code was " + iErr);
    }

  }
}
