/*$Id: Firekeeper.h,v 1.19 2008/06/01 12:21:01 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006, 2007, 2008 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FIREKEEPER_H
#define FIREKEEPER_H

#include "nsNetCID.h"
#include "nsCOMPtr.h"
#include "nsDataHashtable.h"
#include "nsHashKeys.h"
#include "nsIObserver.h"

#include "fkIFirekeeper.h"
#include "fkIJudge.h"
#include "fkIRule.h"

#include "fkRequestExaminator.h"
#include "RulesParser.h"


#define FIREKEEPER_CONTRACTID "@firekeeper.mozdev.org/firekeeper"
#define FKJUDGE_CONTRACTID "@firekeeper.mozdev.org/fkjudge"
#define IFIREKEEPER_CID_STR "eb2e6602-168f-4ff0-a378-c3c8c4214760"
#define FIREKEEPER_CID \
{0xeb2e6602, 0x168f, 0x4ff0, \
{0xa3, 0x78, 0xc3, 0xc8, 0xc4, 0x21, 0x47, 0x60}}

#define NS_ORIGSTREAMLISTENERTEE_CONTRACTID \
    "@mozilla.org/network/orig-stream-listener-tee;1"

#define NS_ORIGSTREAMLISTENERTEE_CID		     \
{  /* bbcbb928-ff43-49ea-aa43-383c550b5262 */        \
    0xbbcbb928,                                      \
    0xff43,            				     \
    0x49ea,                                          \
    {0xaa, 0x43, 0x38, 0x3c, 0x55, 0x0b, 0x52, 0x62} \
}

class nsIChannel;

/*Firekeeper object makes Firekeeper's services available for
  the outside world*/
class Firekeeper : public fkIFirekeeper
                 , public nsIObserver
{
 public:
	NS_DECL_ISUPPORTS
	NS_DECL_NSIOBSERVER
	NS_DECL_FKIFIREKEEPER

        Firekeeper();
	static Firekeeper *GetInstance();
 private:
	~Firekeeper();
	NS_IMETHODIMP Init();
	NS_IMETHODIMP ReplaceTeeListener();

	NS_IMETHODIMP examineRequest(nsIChannel *channel);
	NS_IMETHODIMP examineResponse(nsIChannel *channel);
	PRBool enabled;
};


extern Rules *rules;
extern nsCOMPtr<fkIJudge> fkJudge;
extern const char *rulesOrder[];

extern nsDataHashtable<nsISupportsHashKey, fkRequestExaminator *> *examinatorHashTable;

/*TODO: more configurable*/
#define NACTIONS 3

#endif
