/*$Id: rulesloader.js,v 1.19 2007/09/23 20:37:00 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */



function RulesSource(name, url)
{
	this.remote = false;
	this.name = name;
	this.url = url;
	this.loadError = null;
	this.parsingError = null;
	this.rules = "";
	this.backupAvailable = false;	
	this.disabled = false;
}

function fkRulesLoader(){	
	this.ContractID = RULESLOADER_CONTRACTID;	
	this.cid = Components.ID("2c91b023-fbb4-45b3-be81-5cc63cc6562d");
	this.defaultRulesFiles = ["blacklist", "whitelist", "default", "new_threats", "experimental", "xss", "malware"];
	this.loading = false;
	this.loadAll = false;
	
	/*nsISupports*/
	this.QueryInterface = function(iid) {
		if (iid.equals(Components.interfaces.nsISupports) || 
		    iid.equals(Components.interfaces
			       .nsISupportsWeakReference)         ||
		    iid.equals(Components.interfaces.nsIStreamListener) ||
		    iid.equals(Components.interfaces.nsIRequestObserver) ||
		    iid.equals(Components.interfaces.fkIRulesLoader))
		return this;
		
		//dump("Unimplemented fkRuleLoader interface " + iid + "\n");
		throw Components.results.NS_ERROR_NO_INTERFACE;
	}
	

	/*fkIRulesLoader*/
	this.getRulesSources = function(cnt){
		if (cnt){
			cnt.value = this.sources.length;
		}
		return this.sources;
	}
	
	this.reloadAllSources = function(){
		if (this.loading){
			debug.msg("incorrect execution flow 1");
			return;
		}
		
		firekeeper.resetRules();
		
		this.sources = new Array();
		this.sources.observerService = 
		Components.classes["@mozilla.org/observer-service;1"]
			.getService(Components.interfaces.nsIObserverService);
		
		this.sources.push_and_notify = function(value){
			this.push(value);
			this.notify();
		}
		this.sources.pop_and_notify = function(){
			this.pop();
			this.notify();
			
		}
		this.sources.notify = function(){
			this.observerService
			.notifyObservers(null, "fk_rules_sources_changed", null);
		}
		this.source = null;
		
		this.sourcesNames = this.sourcesBranch.getChildList("", {});
		this.sourceToLoad = 0;			
		
		this.remoteSourcesNames = this.remoteSourcesBranch
		.getChildList("", {});
		
		/* Make default the first entry. */
		for(var i = 0; i < this.remoteSourcesNames.length; i++){
			if (this.remoteSourcesNames[i] == "default"){
				if (i != 0){
					var tmp = this.remoteSourcesNames[0];
					this.remoteSourcesNames[0] = this.remoteSourcesNames[i];
					this.remoteSourcesNames[i] = tmp;
				}
				break;
			}
		}
		
		this.remoteSourceToLoad = 0;
		
		this.loadAll = true;
		this.loadStart();
		this.loadNextSource();
		
	}

	this.addLocalSource = function(file){
		if (this.loading){
			debug.msg("incorrect execution flow 2");
			return;
		}
		
		name = file.leafName;
		var url = this.fileHandler.getURLSpecFromFile(file);
		var cnt = 2;
		
		while(this.hasValue(this.sourcesNames, name)){
			name = file.leafName + cnt;
			cnt++;			
		}

		this.sourcesNames.push(name);
		this.sourcesBranch.setCharPref(name, url);
		this.source = new RulesSource(name, url);
		this.sources.push_and_notify(this.source);
		this.loadAll = false;
		this.loadStart();
		this.loadNextSource();
	}
	
	this.addRemoteSource = function(url){
		if (this.loading){
			debug.msg("incorrect execution flow 2");
			return;
		}
		
		var cnt = this.remoteSourcesNames.length + 1;
		name = "remote" + cnt;
		
		while(this.hasValue(this.remoteSourcesNames, name)){
			name = "remote" + ++cnt;
			//Make sure backup with this name doesn't exist
			this.removeBakup(name);			
		}
		this.remoteSourcesNames.push(name);
		this.remoteSourcesBranch.setCharPref(name, url);
		this.source = new RulesSource(name, url);
		this.sources.push_and_notify(this.source);
		this.loadAll = false;
		this.loadStart();
		this.loadNextRemoteSource();
	}
	
	this.changeLocalSource = function(idx, rules){
		if (this.loading){
			debug.msg("incorrect execution flow 6");
			return;
		}

		s = this.sources[idx];
		if (s.remote){
			throw("can't save remote file");
		}
		s.rules = rules;		
		s.loadError = null;
		s.parsingError = null;
		
		try{
			var file = this.fileHandler.getFileFromURLSpec(s.url);
			var foStream = 
				Components.classes["@mozilla.org/network/file-output-stream;1"]
				.createInstance(Components.interfaces
						.nsIFileOutputStream);
		
			//write, create, truncate
			foStream.init(file, 0x02 | 0x08 | 0x20, 0600, 0); 
			foStream.write(rules, rules.length);
			foStream.close();		
		}catch(e){
			s.loadError = "can't open " + url +" " + e;
			debug.msg(s.loadError);
		}
		this.parseSources();
	}

	this.removeBackup = function(name){
		var rules_dir = this.getRulesDir();
		rules_dir.append("backups");
		rules_dir.append(src.name);
		if (rules_dir.exists()){
			rules_dir.remove(false);
		}
	}

	this.enableSource = function(idx){
		if (this.loading){
			debug.msg("incorrect execution flow 3");
			return;
		}
		
		if (idx < 0 || idx >= this.sources.length){
			throw("incorrect source idx " + idx);
		}

		this.source = this.sources[idx];
		var branch;
		
		if (this.source.remote){			
			branch = this.prefs.getBranch("extensions.firekeeper.disabled.remote_rules.");
		}
		else{
			branch = this.prefs.getBranch("extensions.firekeeper.disabled.rules.");
		}
		branch.deleteBranch(this.source.name);

		this.source.disabled = false;
		this.source.loadError = null;
		this.source.parsingError = null;
		this.source.rules = "";
		this.source.backupAvailable = false;	
		
		this.loadAll = false;
		this.loadStart();
		if (this.source.remote){
			this.loadNextRemoteSource();
		}else{
			this.loadNextSource();
		}
	}
		
	this.disableSource = function(idx){
		if (this.loading){
			debug.msg("incorrect execution flow 4");
			return;
		}

		if (idx < 0 || idx >= this.sources.length){
			throw("incorrect source idx " + idx);
		}

		var src = this.sources[idx];
		var branch;
		
		if (src.remote){			
			branch = this.prefs.getBranch("extensions.firekeeper.disabled.remote_rules.");
		}
		else{
			branch = this.prefs.getBranch("extensions.firekeeper.disabled.rules.");
		}
		src.disabled = true;
		branch.setBoolPref(src.name, true);
		
		this.parseSources();
	}

	this.removeSource = function(idx){
		if (this.loading){
			debug.msg("incorrect execution flow 5");
			return;
		}

		if (idx < 0 || idx >= this.sources.length){
			throw("incorrect source idx " + idx);
		}
		
		var src = this.sources[idx];
		if (this.hasValue(this.defaultRulesFiles, src.name)){
			alert("This is Firekeeper default rules set. It can't be removed, only disabled.");
			return;
		}
		
		if (src.remote){			
			this.remoteSourcesBranch.deleteBranch(src.name);
			this.removeValue(this.remoteSourcesNames, src.name);
			this.removeBackup(src.name);			
		}
		else{
			this.sourcesBranch.deleteBranch(src.name);
			this.removeValue(this.sourcesNames, src.name);
		}
		
		this.removeItem(this.sources, idx);
		this.parseSources();
	}
	
		
	this.blacklist = function(options){
		var fileURL = this.sourcesBranch.getCharPref("blacklist");
		var rule = "drop (" + options + ")\n";
		
		this.addRule(fileURL, rule);
	}

	this.whitelist = function(options){
		var fileURL = this.sourcesBranch.getCharPref("whitelist");
		var rule = "pass (" + options + ")\n";
		
		this.addRule(fileURL, rule);
	}
	
	
	/*other methods*/

	this.getRulesDir = function(){
		// get profile directory
		var res = Components.classes["@mozilla.org/file/directory_service;1"]
		.getService(Components.interfaces.nsIProperties)
		.get("ProfD", Components.interfaces.nsIFile);
		res.append("firekeeper_rules");
		return res;
	}

	this.createDefaultFiles = function(){
		var rulesdir = this.getRulesDir();
		
		/*create firekeeper_rules dir if it doesn't exist*/		
		if( !rulesdir.exists()) {
			rulesdir.create(Components.interfaces.nsIFile
					.DIRECTORY_TYPE, 0700);
		}
		
		/*create black and whitelist file if they don't exist*/
		var t = ["blacklist", "whitelist"]
		for(i = 0; i < t.length; i++){
			s = t[i];
			if (this.sourcesBranch.prefHasUserValue(s)){
				continue;
			}
			
			rulesdir.append(s + ".rules");
			if(!rulesdir.exists()){
				rulesdir.create(Components.interfaces.nsIFile
						.NORMAL_FILE_TYPE, 0600);				
			}
			
			var fileURL = this.fileHandler
			.getURLSpecFromFile(rulesdir);
			this.sourcesBranch.setCharPref(s, fileURL); 
			
			/*move back to $ProfD/firekeeper_rules*/
			rulesdir = this.getRulesDir();
		}

		/*create directory for remote rules backups*/
		rulesdir.append("backups");
		if(!rulesdir.exists()){
			rulesdir.create(Components.interfaces.nsIFile
					.DIRECTORY_TYPE, 0700);
		}
		this.backupRulesDir = this.fileHandler
		.getURLSpecFromFile(rulesdir);
		
	}
	
	this.init = function(){
		this.ioService = Components.classes["@mozilla.org/network/io-service;1"]
		.getService(Components.interfaces.nsIIOService);
		
		this.fileHandler = this.ioService.getProtocolHandler("file")
		.QueryInterface(Components.interfaces.nsIFileProtocolHandler);
		
		this.prefs = Components.classes["@mozilla.org/preferences-service;1"]
		.getService(Components.interfaces.nsIPrefService);	

		this.observerService = Components.classes["@mozilla.org/observer-service;1"]
		.getService(Components.interfaces.nsIObserverService);
		
		this.sourcesBranch = this.prefs.getBranch("extensions.firekeeper.rules.");
		this.remoteSourcesBranch = this.prefs.getBranch("extensions.firekeeper.remote_rules.");
		this.disabledRemoteSourcesBranch = this.prefs.getBranch("extensions.firekeeper.disabled.remote_rules.");
		this.disabledSourcesBranch = this.prefs.getBranch("extensions.firekeeper.disabled.rules.");

		this.createDefaultFiles();		
		
		Components.manager.QueryInterface(Components.interfaces
						  .nsIComponentRegistrar)
		.registerFactory(this.cid, "Firekeeper Rules Loader", 
				 this.ContractID, 
				 new rulesLoaderFactory(this));
		
		this.reloadAllSources();
	}

	this.addRule = function(fileURL, rule){
		var file = this.fileHandler.getFileFromURLSpec(fileURL);
		var error = Object();
		
		firekeeper.addRule(rule, error);
		
		if (error.value && error.value.length){			
			var errmsg = "can't add new  rule: " + error.value;
			alert(errmsg);
			throw(errmsg);
		}

		var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
		.createInstance(Components.interfaces.nsIFileOutputStream);
		
                  		// write, create, append
		foStream.init(file, 0x02 | 0x08 | 0x10, 0600, 0); 
		foStream.write(rule, rule.length);
		foStream.close();		
		
		for(i = 0; i < this.sources.length; i++){
			if (this.sources[i].url == fileURL){
				this.sources[i].rules += rule;
				break;
			}			
		}
	}

	this.remoteSourceDisabled = function(name){
		try{
			return this.disabledRemoteSourcesBranch.getBoolPref(name);
		}catch(e){
			return false;
		}
	}
	
	this.sourceDisabled = function(name){
		try{
			return this.disabledSourcesBranch.getBoolPref(name);
		}catch(e){
			return false;
		}
	}

	
	this.loadNextSource = function(){
		var name;
		var url;
		
		if (!this.loadAll){
			name = this.source.name;
			url = this.source.url;
		}else{		
			if (this.sourceToLoad == this.sourcesNames.length){
				this.loadNextRemoteSource();
				return;
			}
			name = this.sourcesNames[this.sourceToLoad];
			url = this.sourcesBranch.getCharPref(name);
			this.source = new RulesSource(name, url);
			this.sourceToLoad++;
		}
		debug.msg("Loading source '" + name + "', url= " + url);
		
		if (this.sourceDisabled(name)){
			this.source.disabled = true;
			if (this.loadAll){
				this.sources.push_and_notify(this.source);			
				this.loadNextSource();
			}else{
				this.sources.notify();
				this.loadStop();
			}
			return;
		}
		
		try{
			var channel = this.ioService.newChannel(url, null, null);
			channel.asyncOpen(this, this);		
		}catch(e){
			this.source.loadError = "can't open " + url +" " + e;
			debug.msg(this.source.loadError);
			if (this.loadAll){
				this.sources.push_and_notify(this.source);
				this.loadNextSource();
			}else{
				this.sources.notify();
				this.loadStop();
			}
		}
	}
		
	this.loadNextRemoteSource = function(){
		var name;
		var url;
		
		if (!this.loadAll){
			name = this.source.name;
			url = this.source.url;
		}else{		
			if (this.remoteSourceToLoad == this.remoteSourcesNames.length){				
				this.loadStop();
				return;
			}
			name = this.remoteSourcesNames[this.remoteSourceToLoad];
			url = this.remoteSourcesBranch.getCharPref(name);
			this.source = new RulesSource(name, url);
			this.remoteSourceToLoad++;
		}
		
		this.source.remote = true;
		
		debug.msg("Loading remote source '" + name + "', url= " + url);
		
		if (this.remoteSourceDisabled(name)){
			this.source.disabled = true;
			if (this.loadAll){
				this.sources.push_and_notify(this.source);			
				this.loadNextRemoteSource();
			}else{
				this.sources.notify();
				this.loadStop();
			}
			return;
		}
		
		var channel = this.ioService.newChannel(url, null, null);
		try{
			channel.asyncOpen(this, this);		
		}catch(e){
			this.source.loadError = "can't open " + url +" " + e;
			debug.msg(this.source.loadError);
			this.loadBackupSource();
			
			if (this.loadAll){
				this.sources.push_and_notify(this.source);
				this.loadNextRemoteSource();
			}else{
				this.sources.notify();
				this.loadStop();
			}
		}
		
	}
	
	this.loadBackupSource = function(){
		var url = this.backupRulesDir + this.source.name;
		
		debug.msg("Loading backup Source '" + this.source.name + 
			  "', url= " + url);
		
		var scriptableStream=Components
 		     .classes["@mozilla.org/scriptableinputstream;1"]
   		     .getService(Components.interfaces
				 .nsIScriptableInputStream);
		
		//backups are stored locally		
		var channel = this.ioService.newChannel(url, null, null);
		try{
			var input = channel.open();			
			scriptableStream.init(input); 
			this.source.rules = 
				scriptableStream.read(input.available());
			scriptableStream.close(); 
			this.source.backupAvailable = true;
			debug.msg("backup loaded");
		}catch(e){
			
		}
		
	}
	
	this.saveBackup = function(){
		var url = this.backupRulesDir + this.source.name;
		var file = this.fileHandler.getFileFromURLSpec(url);
		var oStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
                      .createInstance(Components.interfaces.nsIFileOutputStream);
   		                 // write, create, truncate
		oStream.init(file, 0x02 | 0x08 | 0x20, 0600, 0); 
		oStream.write(this.source.rules, this.source.rules.length);
		oStream.close();		
	}

	this.onDataAvailable = function(request, context, inputStream, offset, count){
		//debug.msg("data available " + count);		
		var scriptableStream = Components.classes["@mozilla.org/scriptableinputstream;1"]
		    .getService(Components.interfaces.nsIScriptableInputStream);
		scriptableStream.init(inputStream);
		
		var len = this.source.rules.length;
		this.source.rules += scriptableStream.read(count);
		debug.assert(this.source.rules.length == len + count, 
			     "too few bytes read");
	}

	this.getValue = function(list, value){
		for(i = 0; i < list.length; i++){
			if (list[i] == value){
				return list[i];
			}			
		}
		return null;
	}
	
	this.hasValue = function(list, value){
		if (this.getValue(list, value)){
			return true;
		}
		return false;		
	}
	
	this.removeItem = function(list, idx){
		for(i = idx; i < list.length - 1; ++i){
			list[i] = list[i + 1];
		}
		list.pop();		
	}

	this.removeValue = function(list, value){
		for(i = 0; i < list.length; ++i){
			if (list[i] == value){
				this.removeItem(list, i);
				return;
			}
		}			
		debug.msg("list doesn't have a value " + value);
	}
		
	this.parseSources = function(){
		firekeeper.resetRules();
		for(i = 0; i < this.sources.length; i++){
			s = this.sources[i];
			if (!s.disabled && s.rules.length){
				var error = Object();
				firekeeper.addRules(s.rules, error);
				if (error.value && error.value.length){
					s.parsingError = error.value;
					debug.msg(s.parsingError);
				}
				else 
					s.parsingError = null;
			}
		}
		this.sources.notify();
	}
	
	this.loadStart = function(){
		this.loading = true;
		this.observerService
		.notifyObservers(null, "fk_rules_load_started", null);
	}

	this.loadStop = function(){
		this.loading = false;
		this.observerService
		.notifyObservers(null, "fk_rules_load_stopped", null);
	}
	
	this.loadInProgress = function(){
		return this.loading;
	}

	this.onStartRequest = function(request, context){
	}
				
	this.onStopRequest = function(request, context, statusCode){
		var backup_source = true;
		
		if (statusCode != 0){
			this.source.loadError = "request error";
			if (this.source.remote){
				this.loadBackupSource();
				backup_source = false;
			}
		}

		if (this.source.rules.length != 0){
			var error = Object();
			firekeeper.addRules(this.source.rules, error);
			if (error.value && error.value.length){
				this.source.parsingError = error.value;
				//debug.msg(this.source.parsingError);
			}
			if (this.source.remote && backup_source){
				this.saveBackup();
			}
		}
		
		if (this.loadAll){
			this.sources.push_and_notify(this.source);
			if (this.source.remote){
				this.loadNextRemoteSource();
			}
			else{
				this.loadNextSource();
			}
		}else{
			this.sources.notify();
			this.loadStop();
		}
		
		
	}	
}

function rulesLoaderFactory(rulesLoader){
	this.rulesLoader = rulesLoader;
	
	/*nsIFactory*/
	this.createInstance = function(outer, iid) {
		if (outer != null){
			dump("Exception outer != null\n");
			throw Components.results.NS_ERROR_NO_AGGREGATION;
		}
		if (iid.equals(Components.interfaces.fkIRulesLoader) ||
		    iid.equals(Components.interfaces.nsISupports)){
			    return this.rulesLoader;
		    }
		dump("Exception no interface\n");
		throw Components.results.NS_ERROR_NO_INTERFACE;
	}
			 
	/*nsISupports*/
	this.QueryInterface = function(iid) {
		if (iid.equals(Components.interfaces.nsISupports) ||
		    iid.equals(Components.interfaces.
			       nsISupportsWeakReference)          ||
		    iid.equals(Components.interfaces.nsIFactory)){
			    return this;
		    }
			
		dump("Unimplemented factory interface " + iid + "\n");
		throw Components.results.NS_ERROR_NO_INTERFACE;
	}
}







