/*$Id: common.js,v 1.15 2007/09/22 07:38:06 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  ViewURL function is from FireFTP Copyright Mime Cuvalo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

/*global services*/
var firekeeper = null;
var rulesLoader = null;
var judge = null;

var FIREKEEPER_CONTRACTID = "@firekeeper.mozdev.org/firekeeper";
var RULESLOADER_CONTRACTID = "@firekeeper.mozdev.org/fkrulesloader";
var JUDGE_CONTRACTID = "@firekeeper.mozdev.org/fkjudge";

var debug = {
	console: Components.classes["@mozilla.org/consoleservice;1"].
	getService(Components.interfaces.nsIConsoleService),
	
	msg: function(s){
		this.console.logStringMessage(s);
		//dump(s + "\n");
	},
	
	assert: function(val, str){
		if (!val){
			this.console.logStringMessage("Assertion failed: " + 
						      str);
			dump(str);
			close();
		}
	}
}

/*
  Change state between enabled, disabled and error
 */
function changeFirekeeperState(state, msg) {
	var statusBar = document.getElementById('firekeeper-status');
	if (statusBar != null){
		statusBar.setAttribute('status', state);
		statusBar.setAttribute('tooltiptext', msg);
	}
}


/*Get (or create) global services.*/
function getServices()
{
	firekeeper  = Components.classes[FIREKEEPER_CONTRACTID];
	if (firekeeper == null){
		var errMsg = "Firekeeper load failed: " + 
			"component " + FIREKEEPER_CONTRACTID + 
			" not registered";
		changeFirekeeperState("error", errMsg);
		throw(errMsg);
	}
	try{
		firekeeper = firekeeper.getService(Components.interfaces
						   .fkIFirekeeper);
	}catch(e){
		firekeeper = null;
	}

	if (firekeeper == null){
		var errMsg = "Firekeeper load failed: " +
			"can't obtain fkIFirekeeper interface";
		changeFirekeeperState("error", errMsg);
		throw(errMsg);
	}
	
	try{
		judge = Components.classes[JUDGE_CONTRACTID];	
		if (judge == null){
			debug.msg("creating judge");
			judge = new fkJudge();
			judge.init();
			firekeeper.setJudge(judge);
		}else
			judge = judge.getService(Components.interfaces.fkIJudge);
	
		rulesLoader = Components.classes[RULESLOADER_CONTRACTID];
		if (rulesLoader == null){
			debug.msg("creating rules loader");
			rulesLoader = new fkRulesLoader();
			rulesLoader.init();
		}else	
			rulesLoader = rulesLoader.getService(Components.interfaces
							     .fkIRulesLoader);
	}catch(e){
		changeFirekeeperState("error", e);		
		throw(e);
	}
}

function viewURLold(url)
{
	window.open(url, '_new', '');
}


/*
  From FireFTP by Mime Cuvalo - greetz 
 */
function viewURL(url) {
	var windowManager = Components.
		classes['@mozilla.org/appshell/window-mediator;1'].getService();
	var windowManagerInterface = windowManager.
		QueryInterface(Components.interfaces.nsIWindowMediator);
	var win = windowManagerInterface.
		getMostRecentWindow("navigator:browser");
	
	if (win){
		var theTab = win.gBrowser.addTab(url);
		win.gBrowser.selectedTab = theTab;
	}
	else{
		/*open new window*/
		window.open(url, '_new', '');
	}
}

function hideElement(id)
{
	var refnode = document.getElementById(id);	
	refnode.setAttribute('hidden', true);
}

function showElement(id)
{
	var refnode = document.getElementById(id);	
	refnode.setAttribute('hidden', false);
}

function disableElement(id)
{
	var refnode = document.getElementById(id);	
	refnode.setAttribute('disabled', true);
}

function enableElement(id)
{
	var refnode = document.getElementById(id);	
	refnode.setAttribute('disabled', false);
}

function checkboxVal(id)
{
	return document.getElementById(id).getAttribute('checked');
}

function checkboxSet(id, val)
{
	document.getElementById(id).setAttribute('checked', val)
}

function checkboxSetPref(boxid, pref)
{
	var prefService = Components.classes["@mozilla.org/preferences-service;1"]
		.getService(Components.interfaces.nsIPrefService);
	var branch = prefService.getBranch("extensions.firekeeper.");
	var checkbox = document.getElementById(boxid);		
	var val = branch.getBoolPref(pref);
	if (val)
		checkbox.setAttribute('checked', 'true');
	else
		checkbox.setAttribute('checked', 'false');
}
