/*$Id: fkRule.h,v 1.7 2007/09/17 22:18:56 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FKRULE_H
#define FKRULE_H

#include "fkIRule.h"
#include "fkIRuleReference.h"
#include "fkRuleReference.h"
#include "Rule.h"

/*
  Wraps Rule object and makes important parts of it available via xpcom.
 */
class fkRule : public fkIRule
{
 public:
	NS_DECL_ISUPPORTS
        NS_DECL_FKIRULE

        NS_IMETHODIMP Init(const Rule *rule);
        fkRule();
	virtual ~fkRule();
 private:
	char *ruleraw;
	char *action;
	char *msg;
	fkRuleReference **references;
	PRUint32 references_cnt;
	PRUint32 fid;
	PRUint32 rev;

};

#endif
