/* 
	FILEMANAGER  --  A FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
	Author: Duong Thanh An - dgthanhan@gmail.com (core)
	Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)

	Copyright (C) 2004 Anisolution.com

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Anisolution.com
	http://www.anisolution.com
	HCMC Vietnam
	Duong Thanh An
	dgthanhan@gmail.com


	$Id: edit-content.js,v 1.1 2004/11/27 11:58:07 thanh.an Exp $

*/

var path = null;
var WIDTH = 700;
var HEIGHT = 550;

function window_onLoad() {
	parsePath();
	setWindowTitle(path + " - File Manager Editor");

	var left = (screen.availWidth - WIDTH) / 2;
	var top = (screen.availHeight - HEIGHT) / 2;
	//window.resizeTo(WIDTH, HEIGHT);
	window.moveTo(left, top);

	setReadyStatus("Ready.");
	this.isMainWindow = true;
	runReloadCommandImpl();
	window.defaultStatus = "";
}
function parsePath(){
	if(window.location.href.match(/\?path=(.+)$/)) {
		path = unescape(RegExp.$1);
	}
}
function runReloadCommand() {
	if(confirm("Reloading file will discard all changes.\nDo you want to continue?")) runReloadCommandImpl();
}
	function runReloadCommandImpl() {
		setBusyStatus("Loading " + path + "...");
		var content = document.getElementById("content");

		var xHttpConnection = new XHttpConnection();
		xHttpConnection.url = SERVER_CONTENT_LOADER_PATH + "?token=" + escape(new Date()) + "&path=" + encodeURIComponent(path);
		xHttpConnection.async = true;
		var handler = new Object();
		handler.onError = function(connection) {
			alert(connection.httpError.description);
			setReadyStatus("Failed to load file content");
		};
		handler.onLoad = function(dom) {
			var s = "";
			for(var i = 0; i < dom.childNodes.length; i++) 
				if(dom.childNodes[i].nodeName == "#text") s += dom.childNodes[i].nodeValue;
				
			content.value = s;
			setReadyStatus("Ready.");
		};
		xHttpConnection.setAsyncHandler(handler);
		xHttpConnection.execute();
	}
function runSaveCommand() {
	var handler = new Object();
	handler.onError = function(connection) {
		alert(connection.httpError.description);
		setReadyStatus("Failed to save file content");
	};
	handler.onLoad = function(dom) {
		setReadyStatus("File saved.");
	};
	runSaveCommandImpl(handler);
}
function runSaveAndQuitCommand() {
	var handler = new Object();
	handler.onError = function(connection) {
		alert(connection.httpError.description);
		setReadyStatus("Failed to save file content");
	};
	handler.onLoad = function(dom) {
		setReadyStatus("File saved.");
		setTimeout("window.close();", 100);
	};
	runSaveCommandImpl(handler);
}
function betterEscape(s) {
	var t = encodeURIComponent(s);
	return t;
}
	function runSaveCommandImpl(handler) {
		setBusyStatus("Saving " + path + "...");
		var content = document.getElementById("content");

		var xHttpConnection = new XHttpConnection();
		xHttpConnection.url = SERVER_CONTENT_LOADER_PATH + "?action=save&token=" + escape(new Date());
		var postData = "";
		postData += "path=" + encodeURIComponent(path);
		postData += "&content=" + encodeURIComponent(content.value);
		xHttpConnection.postData = postData;
		xHttpConnection.method = "post";

		xHttpConnection.async = true;
		xHttpConnection.setAsyncHandler(handler);
		xHttpConnection.execute();
	}

function setReadyStatus(message) {
	document.getElementById("statusLabel").setAttribute("value", message);
	document.getElementById("statusImage").setAttribute("src", "images/globe-stopped.png");
	setWindowCursor("auto");
	requestAttention();
}
function setBusyStatus(message) {
	document.getElementById("statusLabel").setAttribute("value", message);
	document.getElementById("statusImage").setAttribute("src", "images/globe.gif");
	setWindowCursor("wait");
}

var windowCursor = null;
var backupCursor = null;

function setWindowCursor(cursor) {
	getWindow().style.cursor = cursor;
	windowCursor = cursor;
}
function getWindowCursor() {
	return windowCursor;
}
function setWindowCursorTmp(cursor) {
	backupCursor = getWindowCursor();
	setWindowCursor(cursor);
}
function restoreWindowCursor() {
	setWindowCursor(backupCursor);
}
function runQuitCommand() {
	window.close();
}

function content_onKeyUp(event, target) {
}
