﻿/** Copyright (c) 2007-2008 eMusic.com Inc.
 
This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.  The GNU Lesser General Public License can be viewed by clicking on the following link:  http://www.gnu.org/licenses/lgpl.html#SEC4.  
 
This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**/

var prefBranch_eMusic = null;
var prefBranch_themeChanged = null;

var eDownloadsView = null
var eTrackPreview = null

var bInitializing = false
var bPopupOff = false

var eSaveAlbumArt = nsPreferences.getBoolPref("eMusic.saveAlbumArt")
var bActivelySwitching = false

var eCurrentDeck = nsPreferences.getIntPref("eMusic.currentDeck")
var eDownloadDeck = nsPreferences.getIntPref("eMusic.downloadDeck")
var bForcedCheck = false

var prefObserver = {

  getBranchPrefInterface: function (thisBranch) {
    return thisBranch.QueryInterface(Ci.nsIPrefBranch2); // 1.5+ support
  },
  
  register: function() {
    var prefService = Cc["@mozilla.org/preferences-service;1"].
      getService(Ci.nsIPrefService);

    if(!prefBranch_eMusic) {
      prefBranch_eMusic = prefService.getBranch("eMusic.");
      var pbi = prefObserver.getBranchPrefInterface(prefBranch_eMusic);
      pbi.addObserver("", this, false);
    }

    if (!prefBranch_themeChanged) {
      prefBranch_themeChanged = prefService.getBranch("extensions.lastSelectedSkin");
      var themeObs = prefObserver.getBranchPrefInterface(prefBranch_themeChanged);
      themeObs.addObserver("", themeObserver, false);
    }
    
  },

  unregister: function() {
    if(!prefBranch_eMusic) return;
    var pbi = prefObserver.getBranchPrefInterface(prefBranch_eMusic);
    pbi.removeObserver("", this);

    if(!prefBranch_themeChanged) return;
    var themeObs = prefObserver.getBranchPrefInterface(prefBranch_themeChanged);
    themeObs.removeObserver("", themeObserver);

  },

  observe: function(aSubject, aTopic, aData) {
    if (aTopic != "nsPref:changed") return;

    switch (aData) {
      case "update.enabled":
        if (nsPreferences.getBoolPref("eMusic.update.enabled")) {
          if (eUpdateInterval) {
            clearInterval(eUpdateInterval);
          }
          checkForDLMUpdates();
          eUpdateInterval = setInterval(function() {checkForDLMUpdates()}, nsPreferences.getIntPref("eMusic.update.interval"))
        } else {
          if (eUpdateInterval) {
            clearInterval(eUpdateInterval);
          }
        }
        break;

      case "dir":
      case "folderList":
        setTimeout(initAutoDownloadDisplay, 250);
        break;
      case "cmdLineValue":
        var thisCmdLine = nsPreferences.copyUnicharPref("eMusic.cmdLineValue");

        if (thisCmdLine != "") {
          setTimeout(processCmdLinePref, 500);
        }
        break;
      case "download.dir":
        //var prefs = nsPreferences.mPrefService;
        setTimeout(function() {initAutoDownloadDisplay();}, 250);
        break;
      case "defaultMediaPlayerObj":
      case "defaultMediaSync":
        if (eMediaSync != "NoSync" && mediaManagers[eMediaSync].observerInitialized == true) {
          try {
            if (mediaManagers[eMediaSync].observerInitialized && mediaManagers[eMediaSync].observerObj) {
              mediaManagers[eMediaSync].cleanup();
              mediaManagers[eMediaSync].removeObserver();
            }
          } catch (ex) {
            edebug(ex)
          }
        }

        setTimeout(refreshDefaultPlayer, 250);
        break;
      case "defaultHomePage":
        eDefaultHomePage = nsPreferences.copyUnicharPref('eMusic.defaultHomePage');
        break;
      case "defaultServer":
        eDefaultServer = nsPreferences.copyUnicharPref('eMusic.defaultServer');
        break;
      case "currentDeck":
        eCurrentDeck = nsPreferences.getIntPref('eMusic.currentDeck');
        break;
      case "downloadDeck":
        eDownloadDeck = nsPreferences.getIntPref("eMusic.downloadDeck");
        break;
      case "saveAlbumArt":
        eSaveAlbumArt = nsPreferences.getBoolPref("eMusic.saveAlbumArt");
        break
      case "download.max-connections":
        var maxConnections = nsPreferences.getIntPref("eMusic.download.max-connections");

        switch (maxConnections) {
          case 1:
            nsPreferences.setIntPref("network.http.max-persistent-connections-per-server", 2);
            maxConnections = 2;
            break;
          default:
            nsPreferences.setIntPref("network.http.max-persistent-connections-per-server", maxConnections);
            break;
        }

        nsPreferences.setIntPref("network.http.max-persistent-connections-per-proxy", maxConnections * 2);
        nsPreferences.setIntPref("network.http.max-connections-per-server", maxConnections * 4);
        nsPreferences.setIntPref("network.http.max-connections", maxConnections * 12);

        processDownloadQueue();
        break;
    }

    return;
  }
}

function processCmdLinePref() {
  try {
    var branchService = Cc["@mozilla.org/preferences-service;1"]
                                   .getService(Ci.nsIPrefBranch);

    if (branchService.prefHasUserValue("eMusic.cmdLineValue")) {
    	var myURL = nsPreferences.copyUnicharPref("eMusic.cmdLineValue")
      branchService.clearUserPref("eMusic.cmdLineValue");

      var myURLExtension = "emx";

      if (/^emusic\:\/\/|^https?\:\/\//i.test(myURL)) {
        myURL = myURL.replace(/^emusic:\/\//, "http://")
        processEM(myURL, "http", myURLExtension)
      } else {
        processEM(myURL, "file", myURLExtension)
      }
    }
  } catch (ex) {
    edebug(ex);
    branchService.clearUserPref("eMusic.cmdLineValue");
  }
}

function showThisDeck(thisDeck) {

  bActivelySwitching = true;
  var hideBrowserParts = false
  var disableExpanding = false;

  if (thisDeck) {
    thisDeck = parseInt(thisDeck)
  }
  eCurrentDeck = (!thisDeck) ? eCurrentDeck : thisDeck;

  if (eDownloadsView && eDownloadsView.columns) {
    eDownloadsView.columns.restoreNaturalOrder()
  }
  
  if (!bInitializing) {
    dlm_base.manuallySetPlayer('player-CustomPlayerPath');
  }

  switch (thisDeck) {
    case VIEW_TRACKS:
      var query = document.getElementById("eQuery");
      query.setAttribute("type", "tracks");

      var col = document.getElementById("dlmTree2_album");
      col.removeAttribute("hidden");
      col.removeAttribute("ignoreincolumnpicker");
      col.setAttribute("sortActive", "false");
      //col.removeAttribute("sort");

      col = document.getElementById("dlmTree2_track");
      col.removeAttribute("primary");
      //col.removeAttribute("sort");
      col.setAttribute("sortActive", "false");
      col.setAttribute("label", "Title");
      
      col = document.getElementById("dlmTree2_genre");
      col.setAttribute("sortActive", "false");

      col = document.getElementById("dlmTree2_artist");
      col.setAttribute("sortActive", "false");

      col = document.getElementById("dlmTree2_ended");
      col.setAttribute("sortActive", "true");
      col.setAttribute("sortDirection", "ascending");
      col.setAttribute("sort", "?end_date");

      eDownloadDeck = thisDeck;
      disableExpanding = true;

      document.getElementById("eStackBox").setAttribute("selectedIndex", 0);
      document.getElementById("view_trackDeck").setAttribute("checked", true);

      //setTimeout(function () {document.title = dlm_base.getName()}, 0);
      break;

    case VIEW_ALBUMS:
      var query = document.getElementById("eQuery");
      query.setAttribute("type", "albums");

      var col = document.getElementById("dlmTree2_album");
      col.setAttribute("hidden", "true");
      col.setAttribute("ignoreincolumnpicker", "true");
      //col.removeAttribute("sort");
      col.setAttribute("sortActive", "false");

      col = document.getElementById("dlmTree2_track");
      col.setAttribute("primary", "true");
      col.setAttribute("label", "Album - Track");
      //col.removeAttribute("sort");
      col.setAttribute("sortActive", "false");
      
      col = document.getElementById("dlmTree2_genre");
      col.setAttribute("sortActive", "false");

      col = document.getElementById("dlmTree2_artist");
      col.setAttribute("sortActive", "false");

      col = document.getElementById("dlmTree2_ended");
      col.setAttribute("sortActive", "true");
      col.setAttribute("sortDirection", "ascending");
      col.setAttribute("sort", "?end_date");

      eDownloadDeck = thisDeck;

      document.getElementById("eStackBox").setAttribute("selectedIndex", 0);
      document.getElementById("view_albumDeck").setAttribute("checked", true);

      //setTimeout(function () {document.title = dlm_base.getName()}, 0);
      break;

    case VIEW_AUDIOBOOKS:
      var query = document.getElementById("eQuery");
      query.setAttribute("type", "audiobooks");

      var col = document.getElementById("dlmTree2_album");
      col.setAttribute("hidden", "true");
      col.setAttribute("ignoreincolumnpicker", "true");
      col.setAttribute("sortActive", "false");

      col = document.getElementById("dlmTree2_track");
      col.setAttribute("primary", "true");
      col.setAttribute("label", "Book");
      col.setAttribute("sortActive", "false");
      
      col = document.getElementById("dlmTree2_genre");
      col.setAttribute("sortActive", "false");

      col = document.getElementById("dlmTree2_artist");
      col.setAttribute("sortActive", "false");

      col = document.getElementById("dlmTree2_ended");
      col.setAttribute("sortActive", "true");
      col.setAttribute("sortDirection", "ascending");
      col.setAttribute("sort", "?end_date");

      document.getElementById("eStackBox").setAttribute("selectedIndex", 0);
      document.getElementById("view_audiobooksDeck").setAttribute("checked", true);

      //setTimeout(function () {document.title = dlm_base.getName()}, 0);
      break;

    case VIEW_MEDIA_SYNC:
      document.getElementById("eStackBox").setAttribute("selectedIndex", 1);
      document.getElementById("view_mediaSyncOptions").setAttribute("checked", true);

      hideBrowserParts = true;
      disableExpanding = true;
      break;
  }

  if (thisDeck != VIEW_MEDIA_SYNC && thisDeck != VIEW_BROWSER) {
    if (eDownloadsView.builder) {
      eDownloadsView.builder.rebuild();
    }
    initAutoDownloadDisplay();
  }

  if (eDownloadsView.view && eDownloadsView.view.rowCount == 0) {
    hideBrowserParts = true;
    eDownloadsView.setAttribute("class", "tree-bodybox-blank")
  } else {
    eDownloadsView.setAttribute("class", "tree-bodybox-full")
  }
  
  document.getElementById("main-splitter").setAttribute("collapsed", hideBrowserParts);
  document.getElementById("navBrowserTrackBox").setAttribute("collapsed", hideBrowserParts);

  document.getElementById("view_expandAll").setAttribute("disabled", disableExpanding);
  document.getElementById("view_collapseAll").setAttribute("disabled", disableExpanding);

  nsPreferences.setIntPref("eMusic.currentDeck", eCurrentDeck);
  nsPreferences.setIntPref("eMusic.downloadDeck", eDownloadDeck);

  if (eDownloadsView && eDownloadsView.view && eDownloadsView.view.rowCount > 0) {
    reselectTrack();
  }  

  if (eDownloadsView && eDownloadsView.view && eDownloadsView.view.rowCount == 0) {
    document.getElementById("dlButtonClearAll").setAttribute("disabled", true)
  } else {
    document.getElementById("dlButtonClearAll").setAttribute("disabled", false)
  }

  bActivelySwitching = false;

}

function reselectTrack(thisFilename) {

  eDownloadsView.builder.rebuild();

  if (thisFilename && eDownloadsView && eDownloadsView.view) {
    for (var i=0; i < eDownloadsView.view.rowCount; i++) {
      var tid = eDownloadsView.view.getCellText(i, eDownloadsView.columns.getNamedColumn('treeFilename'))
      if (tid == thisFilename){
        nsPreferences.setIntPref("eMusic.last-selected." + eCurrentDeck, i)
        break;
      }
    }
  }

  var i = 0
  var lastSelected = nsPreferences.getIntPref("eMusic.last-selected." + eCurrentDeck)

  if (eDownloadsView.view.rowCount > 0 && lastSelected == -1) {
    lastSelected = 0;
    nsPreferences.setIntPref("eMusic.last-selected." + eCurrentDeck, lastSelected)
  }

  if (eDownloadsView.view.rowCount < lastSelected) {
    if (eDownloadsView.view.rowCount > 0) {
      lastSelected = 0;
    } else {
      lastSelected = -1;
    }
    nsPreferences.setIntPref("eMusic.last-selected." + eCurrentDeck, lastSelected)
  }

  if (lastSelected == -1) {
    eTrackPreview.loadURI("chrome://emusic/locale/custom.html", null, null);
    return false;
  } else {
    try {
      eDownloadsView.view.selection.select(lastSelected)

      var boxobject = eDownloadsView.boxObject;
      boxobject.QueryInterface(Ci.nsITreeBoxObject);
      boxobject.ensureRowIsVisible(lastSelected);

    } catch (ex) {
      //nsPreferences.setIntPref("eMusic.last-selected." + eCurrentDeck, -1)
      edebug(ex);
    }
  }

  return true;
}

function displayTrackInfo() {
  var templateURL
  //var currentTrack = eDownloadsView.currentIndex
  if (!bActivelySwitching) {
    nsPreferences.setIntPref("eMusic.last-selected." + eCurrentDeck, eDownloadsView.currentIndex)
  }

  var currentTrack = nsPreferences.getIntPref("eMusic.last-selected." + eCurrentDeck)

  if (eCurrentDeck == VIEW_BROWSER || currentTrack == -1) {
    return false;
  }

  if (eCurrentDeck != VIEW_AUDIOBOOKS) {
    templateURL = nsPreferences.copyUnicharPref("eMusic.templateFile")
  } else {
    templateURL = nsPreferences.copyUnicharPref("eMusic.templateFileAudioBooks")
  }

  if (eDownloadsView.view.rowCount > 0 && currentTrack == -1) {
    currentTrack = 0;
    nsPreferences.setIntPref("eMusic.last-selected." + eCurrentDeck, currentTrack)
  }

  try {
    var tmpSQL
    var currentID = null
    
    try {
      currentID = eDownloadsView.view.getCellText(currentTrack, eDownloadsView.columns.getNamedColumn("treeFilename"))
    } catch (ex) {
    }

    if (currentID) {
      tmpSQL = "SELECT distinct a.album_art_url, a.artist, a.album, d.track_name, a.genre, d.duration, a.artist_url, a.album_url, a.genre_url, a.albumid FROM downloads d , albums a where d.album_id = a.albumid and filename = ?1"
    } else {
      //currentID = eDownloadsView.view.getCellValue(currentTrack, eDownloadsView.columns.getNamedColumn("dlmTree2_status"))
      currentID = eDownloadsView.view.getCellValue(eDownloadsView.currentIndex, eDownloadsView.columns.getNamedColumn("dlmTree2_album"))

      tmpSQL = "SELECT a.album_art_url, a.artist, a.album, d.track_name, a.genre, d.duration, a.artist_url, a.album_url, a.genre_url, a.albumid  FROM downloads d , albums a where d.album_id = a.albumid and a.albumid = ?1 order by d.track_number limit 1";
    }

    var sqlStatement = eDownloadsDB.mDBConn.createStatement(tmpSQL);
    sqlStatement.bindUTF8StringParameter(0, currentID);

    var rc =  sqlStatement.executeStep();

    if (rc) {
      var req = new XMLHttpRequest();
      req.open("GET", templateURL, false); 
      req.send(null);
    
      var thisTemplate = req.responseText;
    
      thisTemplate = thisTemplate.replace(/%albumart%/g, sqlStatement.getUTF8String(0));
      thisTemplate = thisTemplate.replace(/%artist%/g, sqlStatement.getUTF8String(1));
      thisTemplate = thisTemplate.replace(/%album%/g, sqlStatement.getUTF8String(2));
      thisTemplate = thisTemplate.replace(/%title%/g, sqlStatement.getUTF8String(3));
      thisTemplate = thisTemplate.replace(/%genre%/g, sqlStatement.getUTF8String(4));
      thisTemplate = thisTemplate.replace(/%duration%/g, sqlStatement.getUTF8String(5));
      thisTemplate = thisTemplate.replace(/%albumid%/g, sqlStatement.getInt32(9));

      var tmpStr = sqlStatement.getUTF8String(6)
      var tmpHomepage = nsPreferences.copyUnicharPref("eMusic.defaultHomePage")

      if (!tmpStr) { tmpStr = tmpHomepage }
      thisTemplate = thisTemplate.replace(/%artisturl%/g, tmpStr);

      tmpStr = sqlStatement.getUTF8String(7)
      if (!tmpStr) { tmpStr = tmpHomepage }
      thisTemplate = thisTemplate.replace(/%albumurl%/g, tmpStr);

      tmpStr = sqlStatement.getUTF8String(8)
      if (!tmpStr) { tmpStr = tmpHomepage }
      thisTemplate = thisTemplate.replace(/%genreurl%/g, tmpStr);

      //sqlStatement.reset();

      var tmpAlbumInfoFile = dlm_base.getSpecialFolder("ProfD")
      tmpAlbumInfoFile.append("tmpAlbumInfo.html")

      dlm_base.writeContents(tmpAlbumInfoFile, thisTemplate)

      eTrackPreview.loadURI(tmpAlbumInfoFile.path, null, null);

      dlm_base.removeFile(tmpAlbumInfoFile.path)
    } else {
      eTrackPreview.loadURI("chrome://emusic/locale/custom.html", null, null);
    }
  } catch (ex) {
    edebug(ex)
  } finally {
    if (sqlStatement) {
      sqlStatement.reset();
    }
  }

  return true;
}

function setMinimizeToTray(thisToggle) {

  if (!thisToggle) {
    thisToggle = false
  } else {
    thisToggle = true
  }
  nsPreferences.setBoolPref("extensions.minimizetotray.always", thisToggle);
}

function setCloseToTray(thisToggle) {

  if (!thisToggle) {
    thisToggle = false
  } else {
    thisToggle = true
  }
  nsPreferences.setBoolPref("extensions.minimizetotray.minimize-on-close", thisToggle);
}

function targetBrowser(event) {

  var myURL 
  var target = event.target;
  var linkNode;

  if (target instanceof HTMLAnchorElement || target instanceof HTMLAreaElement ||
      target instanceof HTMLLinkElement) {
    if (target.hasAttribute("href")) {
     linkNode = target;
    }

    // xxxmpc: this is kind of a hack to work around a Gecko bug (see bug 266932)
    // we're going to walk up the DOM looking for a parent link node,
    // this shouldn't be necessary, but we're matching the existing behaviour for left click
    var parent = target.parentNode;
    while (parent) {
     if (parent instanceof HTMLAnchorElement ||
         parent instanceof HTMLAreaElement ||
         parent instanceof HTMLLinkElement) {
         if (parent.hasAttribute("href"))
           linkNode = parent;
     }
     parent = parent.parentNode;
    }

  } else {
    linkNode = event.originalTarget;
    while (linkNode && !(linkNode instanceof HTMLAnchorElement))
      linkNode = linkNode.parentNode;
    if (linkNode && !linkNode.hasAttribute("href"))
      linkNode = null;
  }

  if (!linkNode) return true;

  dlm_web.goThere(linkNode.href);

  return false;
}

function processEM(empURL, empScheme, empFileExtension) {

  switch (empScheme) {
    case "http":
      var req = new XMLHttpRequest();
      req.open('GET', empURL, true);
      req.onreadystatechange = function (aEvt) {
        if (req.readyState == 4) {
          if (req.status == 200) {
            var empSample = req.responseText;
            eval("eParser." + empFileExtension + "(empSample, empURL)");
          } else {
            edebug("Error loading page: " + empURL);
            toggleTotalProgress(false);
          }
        }
      };

      req.send(null);
      break;
    default: // should be local link, try reading it
      try {
        empURL = dlm_base.scrubPath(empURL)

        var empSample = dlm_base.getContents(empURL)
        eval("eParser." + empFileExtension + "(empSample, empURL)")
      } catch (ex) {
       edebug("Error loading page: " + empURL);
       edebug(ex);
       toggleTotalProgress(false);
      }
      break;
  }
}

function buildDownloadLocation(objDownloadItem) {

  var prefs = nsPreferences.mPrefService;

  dlm_base.verifyDownloadDirectory();

  var fileToSaveTemplate = prefs.getComplexValue("eMusic.download.dir", Ci.nsILocalFile)
  var fileToSave = fileToSaveTemplate.clone();

  var tmpSeparator = nsPreferences.copyUnicharPref("eMusic.FileNamingSeparator")
  var myRegEx = new RegExp(/\\|\/|\:|\*|\?|\"|\<|\>|\|/g);
  tmpSeparator = tmpSeparator.replace(myRegEx, "-")
  nsPreferences.setUnicharPref("eMusic.FileNamingSeparator", tmpSeparator)

  var tmpFileName = nsPreferences.copyUnicharPref("eMusic.FileNamingTemplate") 
  tmpFileName = tmpFileName.replace(myRegEx, "-")
  nsPreferences.setUnicharPref("eMusic.FileNamingTemplate", tmpFileName)

  var tmpALBUM                 = dlm_base.scrub(objDownloadItem["ALBUM"]);
  var tmpTITLE                 = dlm_base.scrub(objDownloadItem["TITLE"]);
  var tmpARTIST                = dlm_base.scrub(objDownloadItem["ARTIST"]);

  // Linux: Fix path settings for leading and trailing periods
  if (eMusicPlatform.ident == "Linux") {
    tmpALBUM = tmpALBUM.replace(/^\.+|\.+$/g, "");;
    tmpARTIST = tmpARTIST.replace(/^\.+|\.+$/g, "");;
  }

  objDownloadItem["DURATION"]  = dlm_base.secondsToTime(objDownloadItem["DURATION"])

  // clean strings to build proper path/file to save
  objDownloadItem["TRACKNUM"]   = dlm_base.padZero(objDownloadItem["TRACKNUM"], objDownloadItem["TRACKCOUNT"].toString().length);
  objDownloadItem["TEMPTRACKNUM"] = objDownloadItem["TRACKNUM"];
  objDownloadItem["DISCCOUNT"]  = dlm_base.padZero(objDownloadItem["DISCCOUNT"], 2);
  objDownloadItem["DISCNUM"]    = dlm_base.padZero(objDownloadItem["DISCNUM"], 2);
  
  if (!objDownloadItem["STYLES"]) objDownloadItem["STYLES"] = "" // temporary patch

  // force disc count in file name
  if (objDownloadItem["DISCCOUNT"] != "01") {
    objDownloadItem["TEMPTRACKNUM"] = objDownloadItem["DISCNUM"] + tmpSeparator + objDownloadItem["TRACKNUM"]
  }

  if (nsPreferences.getBoolPref("eMusic.CreateArtistDirectory")) {
    fileToSave.append(tmpARTIST);
  }

  if (nsPreferences.getBoolPref("eMusic.CreateAlbumDirectory")) {
    fileToSave.append(tmpALBUM);
  }
  
  //template values = artist - track - album - number
  tmpFileName = tmpFileName.replace(/album/, tmpALBUM)
  tmpFileName = tmpFileName.replace(/artist/, tmpARTIST)
  tmpFileName = tmpFileName.replace(/number/, objDownloadItem["TEMPTRACKNUM"])
  tmpFileName = tmpFileName.replace(/track/, tmpTITLE)
  tmpFileName += objDownloadItem["EXTENSION"]

  // Windows: Fix path and file names that are too long - First we test default template
  // Total path + filename can't be more than 255 characters
  if (eMusicPlatform.ident == "WINNT" && fileToSave.path.length + tmpFileName.length > 254) {
    tmpFileName = nsPreferences.copyUnicharPref("eMusic.FileNamingTemplate")

    // remove artist from song title
    var tmpString = "artist" + tmpSeparator 
    tmpFileName = tmpFileName.replace(tmpString, "")
    tmpFileName = tmpFileName.replace(/album/, tmpALBUM)
    tmpFileName = tmpFileName.replace(/number/, objDownloadItem["TEMPTRACKNUM"])
    tmpFileName = tmpFileName.replace(/track/, tmpTITLE)
    tmpFileName += objDownloadItem["EXTENSION"]

    // remove artist & album from song title
    if (fileToSave.path.length + tmpFileName.length > 254) {
      tmpFileName = nsPreferences.copyUnicharPref("eMusic.FileNamingTemplate")

      tmpString = "artist" + tmpSeparator 
      tmpFileName = tmpFileName.replace(tmpString, "")

      tmpString = "album" + tmpSeparator 
      tmpFileName = tmpFileName.replace(tmpString, "")

      tmpFileName = tmpFileName.replace(/number/, objDownloadItem["TEMPTRACKNUM"])
      tmpFileName = tmpFileName.replace(/track/, tmpTITLE)
      tmpFileName += objDownloadItem["EXTENSION"]

      // if still to long, just trim the track's title
      if (fileToSave.path.length + tmpFileName.length > 254) {
        // Avoid Windows headaches with long Artist and Album names by recloning base dir and make a short version
        fileToSave = fileToSaveTemplate.clone();

        if (nsPreferences.getBoolPref("eMusic.CreateArtistDirectory") && tmpARTIST.length > 50) {
          tmpARTIST = tmpARTIST.substring(0, 50)
          tmpARTIST = tmpARTIST.trim();
        }
        fileToSave.append(tmpARTIST);

        if (nsPreferences.getBoolPref("eMusic.CreateAlbumDirectory") && tmpALBUM.length > 50) {
          tmpALBUM = tmpALBUM.substring(0, 50)
          tmpALBUM = tmpALBUM.trim();
        }
        fileToSave.append(tmpALBUM);

        if (fileToSave.path.length + tmpFileName.length > 250) { // 250 is max 254 minus 4 for ".mp3"
          tmpFileName = tmpFileName.substring(0, 254 - fileToSave.path.length) + objDownloadItem["EXTENSION"];
        }
      }
    }
  }

  // Mac OS: Fix file names that are too long - Filename can't be more than 255 characters
  if (eMusicPlatform.ident == "Darwin" && tmpFileName.length > 254) {
    tmpFileName = nsPreferences.copyUnicharPref("eMusic.FileNamingTemplate")

    // remove artist from song title template
    var tmpString = "artist" + tmpSeparator 
    tmpFileName = tmpFileName.replace(tmpString, "")
    tmpFileName = tmpFileName.replace(/album/, tmpALBUM)
    tmpFileName = tmpFileName.replace(/number/, objDownloadItem["TEMPTRACKNUM"])
    tmpFileName = tmpFileName.replace(/track/, tmpTITLE)
    tmpFileName += objDownloadItem["EXTENSION"]

    // If still too long remove artist & album from song title template
    if (tmpFileName.length > 254) {
      tmpFileName = nsPreferences.copyUnicharPref("eMusic.FileNamingTemplate")

      tmpString = "artist" + tmpSeparator 
      tmpFileName = tmpFileName.replace(tmpString, "")

      tmpString = "album" + tmpSeparator 
      tmpFileName = tmpFileName.replace(tmpString, "")

      tmpFileName = tmpFileName.replace(/number/, objDownloadItem["TEMPTRACKNUM"])
      tmpFileName = tmpFileName.replace(/track/, tmpTITLE)
      tmpFileName += objDownloadItem["EXTENSION"]

      // if still to long, just trim the track's title
      if (tmpFileName.length > 254) {
        tmpFileName = nsPreferences.copyUnicharPref("eMusic.FileNamingTemplate")

        tmpString = "artist" + tmpSeparator 
        tmpFileName = tmpFileName.replace(tmpString, "")

        tmpString = "album" + tmpSeparator 
        tmpFileName = tmpFileName.replace(tmpString, "")

        // also check for track number length, this may vary for multi-discs
        tmpTITLE = tmpTITLE.substring(0, 250 - objDownloadItem["TEMPTRACKNUM"].length);

        tmpFileName = tmpFileName.replace(/number/, objDownloadItem["TEMPTRACKNUM"])
        tmpFileName = tmpFileName.replace(/track/, tmpTITLE)
        tmpFileName = tmpFileName.substring(0, 250) + objDownloadItem["EXTENSION"];
      }
    }
  }

  objDownloadItem["PHOTOPATH"] = fileToSave.path;
  fileToSave.append(tmpFileName);
  objDownloadItem["LOCALFILE"] = fileToSave.path;
  
  return objDownloadItem;
}

var eParser = {

  emx: function(empSample, empURL) {

    try {
      if (!empSample) 
        return false

      var isAudiobooks = false;

      eMuNotifier("emusic-status-update", "Generating Download Requests");

      var xmlParser = new DOMParser();
      var xmlDoc = xmlParser.parseFromString(empSample, "text/xml");

      var iu = Components.classes["@emusic.com/insertutils;1"]
                 .createInstance(Components.interfaces.mozIInsertUtils);
      iu.batchProcessEMXData(xmlDoc);

      if (/XML Parsing Error/i.test(xmlDoc.documentElement.firstChild.nodeValue) ? true : false) {
        edebug(xmlDoc.documentElement.firstChild.nodeValue);
        edebug(empSample);
        return false;
      }
      // Traverse through all tracks that are available

      var trackCount = xmlDoc.evaluate("count(PACKAGE/TRACKLIST/TRACK)", xmlDoc, null, XPathResult.ANY_TYPE, null).numberValue;
      // edebug("This document contains " + trackcount + " tracks");

      eShowAlerts = nsPreferences.getBoolPref("eMusic.showAlerts") //document.getElementById("view_popupAlerts").getAttribute("checked")

      if (!bPopupOff && eShowAlerts) {
        var thisMessage = "Downloading " + trackCount

        if (!isAudiobooks) {
          if (trackCount > 1) {
            thisMessage += " tracks"
          } else {
            thisMessage += " track"
          }
        } else {
          if (trackCount > 1) {
            thisMessage += " files"
          } else {
            thisMessage += " file"
          }
        }

        dlm_base.popup(thisMessage, "dlm-downloading");
      }

      var allTracks = xmlDoc.evaluate("PACKAGE/TRACKLIST/TRACK", xmlDoc, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);

      var res = allTracks.iterateNext()

      while (res) {
        var objDownloadItem = {};

        var trackelements = xmlDoc.evaluate("*", res, null, XPathResult.ANY_TYPE, null);
        var nodes = trackelements.iterateNext()

        while (nodes) {
          if (nodes.nodeType==1 && nodes.firstChild) {
            objDownloadItem[nodes.nodeName] = nodes.firstChild.data
          } else if (nodes.nodeType==1) {
            objDownloadItem[nodes.nodeName] = ""
          }
          nodes = trackelements.iterateNext()
        }
 
        objDownloadItem = buildDownloadLocation(objDownloadItem)
 
        isAudiobooks = (objDownloadItem["GENRE"] == "Audiobooks") ? true : false;

        eTrackQueue.push(objDownloadItem);

        res = allTracks.iterateNext()
      }

      eMuNotifier("emusic-status-update", "Queuing Downloads");

      if (eCurrentDeck != VIEW_BROWSER) {
        if (isAudiobooks && eCurrentDeck != VIEW_AUDIOBOOKS) {
          eMuNotifier("emusic-refresh-list", VIEW_AUDIOBOOKS);
        } else {
          eMuNotifier("emusic-refresh-list", eDownloadDeck);
        }
      }
      
      processSQLInserts(isAudiobooks);

      processDownloadQueue();

    } catch (ex) {
      edebug("Parsing error (eParser): Probably parsing error or has exceeded monthly download, just redirect");
      bPopupOff = true;
      toggleTotalProgress(false);
      bPopupOff = false;
      edebug(ex);
      edebug(empURL)
    }

    try {
      var obj_TargetFile = dlm_base.removeFile(empURL);
    } catch (ex) {
    }

    return true;
  }

}

function processSQLInserts(isAudiobooks) {
  
  var ourTransaction = false;
  if (eDownloadsDB.mDBConn.transactionInProgress){
    ourTransaction = true;
    eDownloadsDB.mDBConn.beginTransactionAs(eDownloadsDB.mDBConn.TRANSACTION_DEFERRED);
  }
  //eDownloadsDB.mDBConn.beginTransactionAs(eDownloadsDB.mDBConn.TRANSACTION_DEFERRED);

  for (var i=0; i < eTrackQueue.length; i++) {
    var objDownloadItem = eTrackQueue[i];
    var sqlUpgradeStatement = eDownloadsDB.mDBConn.createStatement("UPDATE downloads set filename = ?, duration = ? WHERE trackid = ?");

    sqlUpgradeStatement.bindUTF8StringParameter(0, objDownloadItem["LOCALFILE"]);
    sqlUpgradeStatement.bindUTF8StringParameter(1, objDownloadItem["DURATION"]);
    sqlUpgradeStatement.bindInt32Parameter(2, objDownloadItem["TRACKID"]);

    try {
      rc =  sqlUpgradeStatement.executeStep();
    } catch (ex) {
      edebug(eDownloadsDB.mDBConn.lastErrorString)
      //edebug(ex)
    } finally {
      sqlUpgradeStatement.reset();
    }
  }  

  if (ourTransaction){
    eDownloadsDB.mDBConn.commitTransaction();
    ourTransaction = false;
  }
  //eDownloadsDB.mDBConn.commitTransaction();
  eDownloadsView.builder.rebuild(); 
}

function processDownloadQueue() {

  var myActiveDownloadCount = 0

  var maxConnections = nsPreferences.getIntPref("eMusic.download.max-connections")

  var ourTransaction = false;
  if (eDownloadsDB.mDBConn.transactionInProgress){
    ourTransaction = true;
    eDownloadsDB.mDBConn.beginTransactionAs(eDownloadsDB.mDBConn.TRANSACTION_DEFERRED);
  }

  var sqlStatement = eDownloadsDB.mDBConn.createStatement("SELECT count() FROM downloads WHERE download_state in (2,5);");

  try {
    var rc =  sqlStatement.executeStep();

    if (rc) {
      myActiveDownloadCount = sqlStatement.getInt32(0);
    }
  } catch (ex) {
    edebug(eDownloadsDB.mDBConn.lastErrorString)
    edebug(ex)
  } finally {
    sqlStatement.reset();
  }

  if (ourTransaction){
    eDownloadsDB.mDBConn.commitTransaction();
  }

  if (myActiveDownloadCount >= maxConnections) {
    return;
  }

  maxConnections = maxConnections - myActiveDownloadCount
  for (var i=1; i <= maxConnections; i++) {
    if (eTrackQueue.length > 0) {
      downloadTrack();
    }
  }
}

function downloadTrack() {
  if (eTrackQueue.length > 0) {
    var thisDLFileObj = eTrackQueue.shift()
    goGetIt(thisDLFileObj);
  }
}

function goGetIt(myDownloadItem) {

  var prefs = nsPreferences.mPrefService;

  dlm_base.verifyDownloadDirectory();
  var baseDirectory = prefs.getComplexValue("eMusic.download.dir", Ci.nsILocalFile)
  
  var photoPath
  
  if (myDownloadItem["PHOTOPATH"]) {
    photoPath = dlm_base.getLocalFileInterface(myDownloadItem["PHOTOPATH"])
  }

  var isAudiobook = (myDownloadItem["GENRE"] == "Audiobooks") ? true : false;

  try {
    // Create directory
    if (!baseDirectory.exists()) {
      try {
        baseDirectory.create(0x01,0755);
      } catch (ex) {
        edebug(ex);
      }
    }

    downloadMP3File(myDownloadItem["TRACKURL"], myDownloadItem["LOCALFILE"], isAudiobook);

    if (eSaveAlbumArt && photoPath) {
      if (eMusicPlatform.ident == "Linux") {
        var tmpInfoFile = photoPath.clone()
        tmpInfoFile.append(".directory")

        dlm_base.writeContents(tmpInfoFile, "[Desktop Entry]\rIcon=./Folder.jpg")
      }

      photoPath.append("Folder.jpg");

      if (!photoPath.exists()) {
        if (myDownloadItem["ALBUMARTLARGE"] && myDownloadItem["ALBUMARTLARGE"] != "") {
          silentFileDownload(myDownloadItem["ALBUMARTLARGE"], photoPath.path)
        } else {
          silentFileDownload(myDownloadItem["ALBUMART"], photoPath.path)
        }
      }
    }

  } catch (ex) {
    edebug(ex);
    return false;
  }

  return true;
}

function downloadMP3File(thisURL, thisLocalFile, isAudiobook, isForced) {
  var ioService = Cc["@mozilla.org/network/io-service;1"]
                    .getService(Ci.nsIIOService);

  thisLocalFile = dlm_base.getLocalFileInterface(thisLocalFile);

  isForced = (!isForced) ? true : isForced;
  if (isForced) {
    dlm_base.removeFile(thisLocalFile.path);
  }  

  var req = new XMLHttpRequest();
  req.open('GET', thisURL, false);
  req.setRequestHeader("DLM", "true"); // tells dl-srv don't redirect if not found, ie: 302
  req.setRequestHeader("Range", "bytes=0-1");
  req.channel.loadFlags |= Components.interfaces.nsIRequest.LOAD_BYPASS_CACHE;
  req.send(null);

  var emusicDatabase = Cc["@emusic.com/emusic/database;1"].getService(Ci.nsIEmusicDatabase);

  switch (req.status) {
    case 200:
    case 206:
      //edebug("Media File Detected")

      // Make sure that path and filename can and are created
      if (!thisLocalFile.exists()) {
        try {
          thisLocalFile.create(0x00,0755);
        } catch (ex) {
          edebug(ex);
        }
      }

      var fileuri = ioService.newFileURI(thisLocalFile);

      var persistBag = Cc["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"]
                        .createInstance(Ci.nsIWebBrowserPersist);
      var nsIWBP = Ci.nsIWebBrowserPersist;

      persistBag.persistFlags = nsIWBP.PERSIST_FLAGS_NO_CONVERSION |
                                nsIWBP.PERSIST_FLAGS_IGNORE_REDIRECTED_DATA |
                                nsIWBP.PERSIST_FLAGS_REPLACE_EXISTING_FILES |
                                nsIWBP.PERSIST_FLAGS_BYPASS_CACHE |
                                nsIWBP.PERSIST_FLAGS_DONT_CHANGE_FILENAMES |
                                nsIWBP.PERSIST_FLAGS_CLEANUP_ON_FAILURE |
                                nsIWBP.PERSIST_FLAGS_SERIALIZE_OUTPUT;
      // var req = Cc["@mozilla.org/network/incremental-download;1"]
                  // .createInstance(Ci.nsIIncrementalDownload);    

      var uriObj = ioService.newURI(thisURL, null, null);

      // Hook into download manager
      // var transObj = Cc["@mozilla.org/transfer;1"]
                       // .createInstance(Ci.nsITransfer);
      // transObj.init(uriObj, fileuri, thisLocalFile.leafName, null, null, null, persistBag);

      // do the progress listener thing and update status
      var eDownloadListener = new dlmlistener()
      eDownloadListener.init(thisLocalFile.leafName, uriObj, thisLocalFile, null);
      eDownloadListener.dlType = (isAudiobook) ? "Audiobooks" : "notAudiobooks";

      persistBag.progressListener = eDownloadListener;

      // const DOWNLOAD_CHUNK_SIZE  = 40960; // bytes
      try {
        // req.init(uriObj, thisLocalFile, DOWNLOAD_CHUNK_SIZE, 0);
        // req.start(eDownloadListener, null);

        emusicDatabase.updateDownloadState(thisLocalFile.path, 2);

        persistBag.saveURI(uriObj, null, null, null, "DLM: true\r\n", fileuri);
        
      } catch(ex) {
        edebug(ex)
        if (persistBag) {
          persistBag.cancelSave();
        }
      }
      
      break;
    default:
      edebug(thisURL, req.status)
      //edebug(thisURL, "\n\n", req.getAllResponseHeaders())
      edebug(req.getResponseHeader("Content-Length"))

      gHadDownloadErrors = true;
      emusicDatabase.updateDownloadState(thisLocalFile.path, 8);
      reselectTrack(thisLocalFile.path)
      toggleTotalProgress(false);
      downloadTrack();
      break;
  }

}

function silentFileDownload(thisURL, thisPath, serializeFile, thisListener) {
  try {
    var ios = Cc["@mozilla.org/network/io-service;1"].getService(Ci.nsIIOService);
    var obj_URI = ios.newURI(thisURL, null, null);

    // xulrunner 1.9 xmlhtmlrequest changes: 
    // https://developer.mozilla.org/En/NsIJSXMLHttpRequest
    var req = new XMLHttpRequest();
    req.open('GET', thisURL, false);
    req.setRequestHeader("Range", "bytes=0-1");
    req.channel.loadFlags |= Components.interfaces.nsIRequest.LOAD_BYPASS_CACHE;
    req.send(null);

    // A 404 is return but the content of the call is a no album art image, don't download
    if (req.status == 404) {
      return false;
    }

    var obj_TargetFile = dlm_base.getLocalFileInterface(thisPath);
    
    if (obj_TargetFile.exists()) {
      //return false;
    } else {
      try {
        obj_TargetFile.create(0x00,0755);
      } catch(ex) {
        return false;
        edebug(ex);
      }
    }

    var persistBag = Cc["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"]
                        .createInstance(Ci.nsIWebBrowserPersist);
    var nsIWBP = Ci.nsIWebBrowserPersist;

    persistBag.persistFlags = nsIWBP.PERSIST_FLAGS_REPLACE_EXISTING_FILES |
                              nsIWBP.PERSIST_FLAGS_BYPASS_CACHE |
                              nsIWBP.PERSIST_FLAGS_FAIL_ON_BROKEN_LINKS |
                              nsIWBP.PERSIST_FLAGS_CLEANUP_ON_FAILURE;
                            
    if (serializeFile) {
      persistBag.persistFlags = nsIWBP.PERSIST_FLAGS_REPLACE_EXISTING_FILES |
                                 nsIWBP.PERSIST_FLAGS_BYPASS_CACHE |
                                 nsIWBP.PERSIST_FLAGS_SERIALIZE_OUTPUT |
                                 nsIWBP.PERSIST_FLAGS_FAIL_ON_BROKEN_LINKS |
                                 nsIWBP.PERSIST_FLAGS_CLEANUP_ON_FAILURE;
    }

  	if (thisListener) {
  	  persistBag.progressListener = thisListener;
  	}
  	
    persistBag.saveURI(obj_URI, null, null, null, null, obj_TargetFile);

  } catch (ex) {
    edebug(ex);
    if (persistBag) {
      persistBag.cancelSave();
    }
    return false;
  }

  return true;
}

function reQueueDownloads() {
  var ourTransaction = false;
  if (eDownloadsDB.mDBConn.transactionInProgress){
    ourTransaction = true;
    eDownloadsDB.mDBConn.beginTransactionAs(eDownloadsDB.mDBConn.TRANSACTION_DEFERRED);
  }

  var sqlStatement = eDownloadsDB.mDBConn.createStatement("SELECT d.trackid, d.filename, d.src_url, d.album_id, d.album, d.track_name, d.track_number, d.track_count, d.duration, d.disc_number, d.disc_count, a.genre, a.artist, a.album_art_url FROM downloads AS d, albums AS a WHERE download_state IN (-1, 2, 4, 5, 8) AND d.album_id = a.albumid ORDER BY d.end_date, d.disc_number, d.track_number;");

  try {
    while (sqlStatement.executeStep()){
      var myDownloadItem = {};
      var newDate = new Date()

      myDownloadItem["TRACKID"] = sqlStatement.getInt32(0);
      myDownloadItem["LOCALFILE"] = sqlStatement.getUTF8String(1);
      myDownloadItem["TRACKURL"] = sqlStatement.getUTF8String(2);
      myDownloadItem["ALBUMID"] = sqlStatement.getInt32(3);
      myDownloadItem["ALBUM"] = sqlStatement.getUTF8String(4);
      myDownloadItem["TITLE"] = sqlStatement.getUTF8String(5);
      myDownloadItem["TRACKNUM"] = sqlStatement.getInt32(6);
      myDownloadItem["TRACKCOUNT"] = sqlStatement.getInt32(7);
      myDownloadItem["DURATION"] = sqlStatement.getUTF8String(8);
      myDownloadItem["DISCNUM"] = sqlStatement.getInt32(9);
      myDownloadItem["DISCCOUNT"] = sqlStatement.getInt32(10);
      myDownloadItem["GENRE"] = sqlStatement.getUTF8String(11);
      myDownloadItem["ARTIST"] = sqlStatement.getUTF8String(12);
      myDownloadItem["ALBUMART"] = sqlStatement.getUTF8String(13);
      myDownloadItem["EXTENSION"] = ".mp3"
      myDownloadItem["DATESTARTED"] = newDate.getTime()
      myDownloadItem["DATEENDED"] = newDate.getTime()

      if (myDownloadItem["DURATION"].length == 3) {
        myDownloadItem["DURATION"] = dlm_base.secondsToTime(myDownloadItem["DURATION"])
      }

      myDownloadItem = buildDownloadLocation(myDownloadItem)

      eTrackQueue.push(myDownloadItem);
    }

  } catch (ex) {
    edebug(eDownloadsDB.mDBConn.lastErrorString)
    edebug(ex)
  } finally {
    sqlStatement.reset();
  }

  if (ourTransaction){
    eDownloadsDB.mDBConn.commitTransaction();
    ourTransaction = false;
  }

  if (eDownloadsDB.mDBConn.transactionInProgress){
    ourTransaction = true;
    eDownloadsDB.mDBConn.beginTransactionAs(eDownloadsDB.mDBConn.TRANSACTION_DEFERRED);
  }

  for (var i=0; i < eTrackQueue.length; i++) {
    var objDownloadItem = eTrackQueue[i];
    var sqlStatement = eDownloadsDB.mDBConn.createStatement("UPDATE downloads SET filename = ? WHERE trackid = ?");

    sqlStatement.bindUTF8StringParameter(0, objDownloadItem["LOCALFILE"]);
    sqlStatement.bindInt32Parameter(1, objDownloadItem["TRACKID"]);

    try {
      rc =  sqlStatement.executeStep();
    } catch (ex) {
      edebug(eDownloadsDB.mDBConn.lastErrorString)
      edebug(ex)
    } finally {
      sqlStatement.reset();
    }
  }  

  if (ourTransaction){
    eDownloadsDB.mDBConn.commitTransaction();
    ourTransaction = false;
  }

  if (eTrackQueue.length > 0) {
    if (eDownloadsDB.mDBConn.transactionInProgress){
      ourTransaction = true;
      eDownloadsDB.mDBConn.beginTransactionAs(eDownloadsDB.mDBConn.TRANSACTION_DEFERRED);
    }

    sqlStatement = eDownloadsDB.mDBConn.createStatement("UPDATE downloads SET download_state = -1 WHERE download_state IN (2, 4, 5, 8)");

    try {
      var rc =  sqlStatement.executeStep();
    } catch (ex) {
      edebug(eDownloadsDB.mDBConn.lastErrorString)
      edebug(ex)
    } finally {
      sqlStatement.reset();
    }

    if (ourTransaction){
      eDownloadsDB.mDBConn.commitTransaction();
    }

    eDownloadsView.builder.rebuild();
    setTimeout(processDownloadQueue, 250);
  }
}

function toggleTotalProgress(forced) {
  var thisToggle = false
  var downloadCount = document.getElementById("download-count")

  var ourTransaction = false;
  if (eDownloadsDB.mDBConn.transactionInProgress){
    ourTransaction = true;
    eDownloadsDB.mDBConn.beginTransactionAs(eDownloadsDB.mDBConn.TRANSACTION_DEFERRED);
  }

  var sqlStatement = eDownloadsDB.mDBConn.createStatement("SELECT count() FROM downloads WHERE download_state in (-1,2);");

  try {
    var rc =  sqlStatement.executeStep();

    if (rc) {
      eActiveDownloadCount = sqlStatement.getInt32(0);
    }
  } catch (ex) {
    edebug(eDownloadsDB.mDBConn.lastErrorString)
    edebug(ex)
  } finally {
    sqlStatement.reset();
  }

  if (ourTransaction){
    eDownloadsDB.mDBConn.commitTransaction();
  }

  if (eActiveDownloadCount == 0 && !forced) {
    thisToggle = true

    eShowAlerts = nsPreferences.getBoolPref("eMusic.showAlerts") 

    if (!bInitializing && !bPopupOff && eShowAlerts) {
      var thisMessage = null

      var bundle = eBundleService.createBundle("chrome://growl/locale/notifications.properties");

      thisMessage = bundle.GetStringFromName("downloading.complete");
      if (gHadDownloadErrors) {
        gHadDownloadErrors = false
        thisMessage = bundle.GetStringFromName("downloading.complete.with.errors");
        document.getElementById("dlButtonResume").setAttribute("disabled", false)
        
        if (gHadDownloadErrorsMsg) {
          thisMessage = gHadDownloadErrorsMsg;
          gHadDownloadErrorsMsg = null
        }
      }

      eMuNotifier("emusic-status-update", thisMessage);

      //setTimeout(function() {showThisDeck()}, 500);

      dlm_base.popup(thisMessage, "dlm-complete");

      bPopupOff = false;
    }

    if (eDownloadsView) {
      document.getElementById("dlButtonCancel").setAttribute("disabled", true)
      document.getElementById("dlButtonPause").setAttribute("disabled", true)
      //document.getElementById("dlButtonResume").setAttribute("disabled", true)
    }

    if (!bInitializing ) {
      if (eMediaSync == "iTunes" && ePlaylistQueue.length > 0 && eMusicPlatform.ident == "WINNT") {
        mediaManagers[eMediaSync].createPlaylist(ePlaylistQueue);
        ePlaylistQueue = new Array;
      }
    }

    setTimeout(function() { eMuNotifier("emusic-status-update", "");}, 2000);
    
  } else if (eActiveDownloadCount > 0 && eDownloadsView) {
    document.getElementById("dlButtonCancel").setAttribute("disabled", false)
    document.getElementById("dlButtonPause").setAttribute("disabled", false)

    if (downloadCount) {
      downloadCount.setAttribute("value", " (" + eActiveDownloadCount + ")");
    }

    eMuNotifier("emusic-status-update", "Downloads Remaining (" + eActiveDownloadCount + ")");
  }

  if (downloadCount) {
    downloadCount.setAttribute("collapsed", thisToggle);
    document.getElementById("dlm-throbber").setAttribute("busy", !thisToggle);
  }

  if (nsPreferences.getIntPref("eMusic.download.retention") == 0) {
    var thisSQL = "delete from downloads where download_state = 1";
    eDownloadsDB.mDBConn.executeSimpleSQL(thisSQL);
    eMuNotifier("emusic-refresh-list", null);
  }

  if (!bInitializing && eActiveDownloadCount == 0
        && nsPreferences.getBoolPref("eMusic.QuitWhenDone")) {
    //setTimeout(function() {showThisDeck()}, 250);
    setTimeout(function() {dlm_base.quit(true);}, 2000);
  }

  if (eDownloadsView && eDownloadsView.view && eDownloadsView.view.rowCount == 0) {
    document.getElementById("dlButtonClearAll").setAttribute("disabled", true)
  } else if (eDownloadsView) {
    document.getElementById("dlButtonClearAll").setAttribute("disabled", false)
  }
}

function initAutoDownloadDisplay() {
  var pref = Cc["@mozilla.org/preferences-service;1"]
                       .getService(Ci.nsIPrefBranch);

  var autodownload = pref.getBoolPref("eMusic.download.useDownloadDir");  
  if (autodownload) {
    var autodownloadInfo = document.getElementById("autodownloadInfo");
    autodownloadInfo.hidden = false;

    function getSpecialFolderKey(aFolderType) {
      if (aFolderType == "Desktop")
        return "Desk";

      if (aFolderType == "Downloads") {
        switch (eMusicPlatform.ident) {
          case "WINNT":
            return "Pers"
            break;
          default:
            return "UsrDocs"
         }
      }
      throw "ASSERTION FAILED: folder type should be 'Desktop' or 'Downloads'";
    }
    
    function getDownloadsFolder(aFolder) {
      var fileLocator = Cc["@mozilla.org/file/directory_service;1"].getService(Ci.nsIProperties);
      var dir = fileLocator.get(getSpecialFolderKey(aFolder), Ci.nsILocalFile);
      
      var bundle = eBundleService.createBundle("chrome://mozapps/locale/downloads/unknownContentType.properties");

      var description = bundle.GetStringFromName("myDownloads");
      if (aFolder != "Desktop")
        dir.append(description);
      return dir;
    }

    var displayName = null;
    var folder;
    switch (pref.getIntPref("eMusic.download.folderList")) {
    case 0:
      folder = getDownloadsFolder("Desktop");
      displayName = document.getElementById("downloadStrings").getString("displayNameDesktop");
      break;
    case 1:
      folder = getDownloadsFolder("Downloads");
      break;
    case 2: 
      dlm_base.verifyDownloadDirectory();

      folder = pref.getComplexValue("eMusic.download.dir", Ci.nsILocalFile);

      break;
    }

    if (folder) {    
      var folderObj = document.getElementById("saveToFolder");
      if (folderObj) {
        folderObj.label = displayName || folder.leafName;
        folderObj.setAttribute("path", folder.path);
      }

      folderObj = document.getElementById("saveToFolderDirectory")
      if (folderObj) {
        folderObj.label = displayName || folder.leafName;
        folderObj.setAttribute("path", folder.path);
      }

      folderObj = document.getElementById("saveToFolderAlbum")
      if (folderObj) {
        folderObj.label = displayName || folder.leafName;
        folderObj.setAttribute("path", folder.path);
      }
      folderObj = document.getElementById("saveToFolderBrowser")
      if (folderObj) {
        folderObj.label = displayName || folder.leafName;
        folderObj.setAttribute("path", folder.path);
      }
      
      folderObj = document.getElementById("saveToFolderAudiobooks")
      if (folderObj) {
        folderObj.label = displayName || folder.leafName;
        folderObj.setAttribute("path", folder.path);
      }

      if (eMusicPlatform.ident == "WINNT") {
        // backwards compatibility and for the new installer logic
        var thisRegBase = eMusicRegistry.eMusicBaseReg;
        eMusicRegistry.setValue(winRegKeys["HKCU"], thisRegBase, "DownloadDirectory", folder.path)
      }
    }
  }
  else {
    var autodownloadInfo = document.getElementById("autodownloadInfo");
    autodownloadInfo.hidden = true;
  }
}

function onDownloadShowFolder() {
  dlm_base.verifyDownloadDirectory();

  //var folderName = document.getElementById("saveToFolder").getAttribute("path");
  var prefs = nsPreferences.mPrefService;
  var thisFolder = prefs.getComplexValue("eMusic.download.dir", Ci.nsILocalFile);

  dlm_base.showThisPath(thisFolder.path)
}

function fullScreenKeys(event) {
  
  if (event.keyCode == event.DOM_VK_F4 && event.atlKey) { // || event.keyCode == event.DOM_VK_Q && event.ctrlKey
    event.preventDefault();
    dlm_base.quit(true);
  }

  //if (event.keyCode == VK_ESCAPE) {
  //  dlm_base.quit(true);
  //}
}

var themeObserver = {
  observe: function(aSubject, aTopic, aData) {
    if (aTopic != "nsPref:changed") return;

    setTimeout(function() { restartPrompt(true); }, 250);
  }
}

function restartPrompt(promptMe){

  if (typeof canQuitApplication == "function" && canQuitApplication()) {
    if (promptMe != false) {
      var myPrompts = Cc["@mozilla.org/embedcomp/prompt-service;1"]
            .getService(Ci.nsIPromptService);
      var myLocalStrings = eBundleService
            .createBundle("chrome://emusic/locale/emusic.properties");

      var retVal  = myPrompts.confirm(window, myLocalStrings.GetStringFromName("appName"), 
                                          myLocalStrings.GetStringFromName("promptRestart"));

      if (!retVal) {
         return true;
      }
    }

    var appStartup = Ci.nsIAppStartup;
    Cc["@mozilla.org/toolkit/app-startup;1"]
      .getService(appStartup).quit(appStartup.eRestart | appStartup.eAttemptQuit);
  }

  return true;
}

function checkForDLMUpdates(thisForcedCheck){

  if (!bForcedCheck) {
    updatesContinueStartup();
  }

  if (thisForcedCheck) bForcedCheck = thisForcedCheck 

  if (nsPreferences.getBoolPref("eMusic.update.enabled") || bForcedCheck) {
    var updateXMLURL = nsPreferences.copyUnicharPref("eMusic.update.url");
    var req = new XMLHttpRequest();
    
    var mySysInfo = Cc["@mozilla.org/system-info;1"]
                      .getService(Ci.nsIPropertyBag2);

    var myOSVersion = encodeURIComponent(mySysInfo.getProperty("name") + "_" +  
                                    mySysInfo.getProperty("version"));

    var myAppVars  = Cc["@mozilla.org/xre/app-info;1"].getService(Ci.nsIXULAppInfo)
                       .QueryInterface(Ci.nsIXULRuntime);
    var myABI = myAppVars.XPCOMABI

    if (eMusicPlatform.ident == "Darwin") {
      var macutils = Cc["@mozilla.org/xpcom/mac-utils;1"].getService(Ci.nsIMacUtils);

      if (macutils.isUniversalBinary) {
        myABI = "Universal-gcc3";
      }
    }

    updateXMLURL = updateXMLURL.replace("%OS%", myOSVersion)
    updateXMLURL = updateXMLURL.replace("%TARGET%", myABI)

    var formatter = Cc["@mozilla.org/toolkit/URLFormatterService;1"]
                      .getService(Ci.nsIURLFormatter);
    updateXMLURL = formatter.formatURL(updateXMLURL);

    var newDate = new Date()
    updateXMLURL += "&rec=" + newDate.getTime();

    req.open('GET', updateXMLURL, true);

    var thisPrompts = Cc["@mozilla.org/embedcomp/prompt-service;1"].getService(Ci.nsIPromptService);
    var eStrings = eBundleService.createBundle("chrome://emusic/locale/emusic.properties");
    var updateTitle = eStrings.GetStringFromName("updateTitle")
    var retVal

    req.onerror = checkForUpdatesError
 
    req.onreadystatechange = function (aEvt) {
      if (req.readyState == 4) {
        if (req.status && req.status == 200) {
          var reqResponseText = req.responseText;
          var xmlParser = new DOMParser();
          var xmlDoc = xmlParser.parseFromString(reqResponseText, "text/xml");

          if (/XML Parsing Error/i.test(xmlDoc.documentElement.firstChild.nodeValue) ? true : false) {
            throw(xmlDoc.documentElement.firstChild.nodeValue)
          }
          var allEntries = xmlDoc.getElementsByTagName("root");
          
          var objUpdateItem = {};
          if (allEntries.length > 0) {
            // Process all child nodes and add to associative array.
            var nodes = allEntries[0].childNodes
            for (var x=0; x < nodes.length; x++) {
              if (nodes[x].nodeType == 1 && allEntries[0].getElementsByTagName(nodes[x].nodeName)[0].firstChild) {
                objUpdateItem[nodes[x].nodeName] = allEntries[0].getElementsByTagName(nodes[x].nodeName)[0].firstChild.data
              } else if (nodes[x].nodeType==1) {
                objUpdateItem[nodes[x].nodeName] = ""
              }
            }
          }

          var verCheck = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                           .getService(Components.interfaces.nsIVersionComparator)
                           .compare(objUpdateItem["version"], dlm_base.getAppVersion());

          if (verCheck > 0) {
            var updateMsg = objUpdateItem["message"] + eStrings.GetStringFromName("updateOptional")

            eDownloadsView.PauseResumeAll(true, true);

            if (objUpdateItem["required"] == "true") {
              updateMsg = objUpdateItem["message"] + eStrings.GetStringFromName("updateRequired");
              retVal  = thisPrompts.alert(window, updateTitle, updateMsg);

              dlm_web.goThere(objUpdateItem["upgrade_url"])

              setTimeout(function() {dlm_base.quit(true);}, 500);
            } else {
              retVal  = thisPrompts.confirm(window, updateTitle, updateMsg);

              if (retVal) {
                dlm_web.goThere(objUpdateItem["upgrade_url"])

                setTimeout(function() {dlm_base.quit(true);}, 500);
              } else if (!bForcedCheck) {
                updatesContinueStartup();
              }
            }
          } else if (bForcedCheck) {
            retVal  = thisPrompts.alert(window, updateTitle, eStrings.GetStringFromName("updateNotAvailable"));
          }
          bForcedCheck = false;

        } else {
          if (bForcedCheck) {
            retVal  = thisPrompts.alert(window, updateTitle, eStrings.GetStringFromName("updateCheckIssues"));
          }
        }
      }
    };
 
    req.send(null);
  }
}

function checkForUpdatesError(ex) {
  edebug("Error checking for updates");
}

function updatesContinueStartup() {
  //setTimeout(function() {reQueueDownloads(); processCmdLinePref();}, 250);
  processCmdLinePref();
  reQueueDownloads();
}

function expandTheTree(expandValue) {
  try {
    var whereClause
    
    if (eCurrentDeck == VIEW_AUDIOBOOKS) {
      whereClause = " where genre == 'Audiobooks'"
    } else {
      whereClause = " where genre != 'Audiobooks'"
    }

    eDownloadsDB.mDBConn.executeSimpleSQL("UPDATE albums SET open = " + expandValue + whereClause);

    eDownloadsView.builder.rebuild();
    
    nsPreferences.setIntPref("eMusic.last-selected." + eCurrentDeck, -1)

  } catch (ex) {
    edebug(eDownloadsDB.mDBConn.lastErrorString)
    edebug(ex)
  }
}

function toggleShowAlerts() {
  var eShowAlerts = document.getElementById("view_popupAlerts").getAttribute("checked")
  
  nsPreferences.setBoolPref("eMusic.showAlerts", (eShowAlerts == "true") ? true : false);
}

function listenToTrack(trackLocation) {

  if (!trackLocation) return false;

  var prefs = nsPreferences.mPrefService;
  var branchService = Cc["@mozilla.org/preferences-service;1"]
                                 .getService(Ci.nsIPrefBranch);

  trackLocation = dlm_base.scrubPath(trackLocation);
  
  // remove trailing slash for directories so that Winamp  
  // (and possibly others) will read as directory
  if (eMediaPlayer == "Winamp") trackLocation = trackLocation.replace(/\\$/g, "")

  try {
    var defaultMediaPlayerValue

    if (eMediaPlayer == "CustomPlayer" && 
        branchService.prefHasUserValue("eMusic.defaultMediaPlayerCustom")) {
      defaultMediaPlayerValue = "eMusic.defaultMediaPlayerCustom";
    } else {
      defaultMediaPlayerValue = "eMusic.defaultMediaPlayer";
    }

    var defaultMediaPlayer = prefs.getComplexValue(defaultMediaPlayerValue,
                               Ci.nsILocalFile);
    var params = [trackLocation]

    switch (eMusicPlatform.ident) {
      case "Linux":
        if (eMediaPlayer == "DefaultPlayer" || !defaultMediaPlayer) {
          defaultMediaPlayer = prefs.getComplexValue("eMusic.defaultMediaPlayer.Linux",
                                 Ci.nsILocalFile);
        }
        break;
      case "WINNT":
        switch(eMediaPlayer) {
          case "WMP":
            params = ["/Service:emusic", "/play", trackLocation];
            break;
        }
        break;
      case "Darwin":
        params = ["-a", defaultMediaPlayer.path, trackLocation];
        defaultMediaPlayer = dlm_base.getLocalFileInterface("/usr/bin/open");
        break;
    }

    var thisProcess = Cc["@mozilla.org/process/util;1"].
                        getService(Ci.nsIProcess);
    thisProcess.init(defaultMediaPlayer);
    
    thisProcess.run(false, params, params.length);
    
  } catch (ex) {
    //try {
      var launchMP3 = dlm_base.getLocalFileInterface(trackLocation)
      launchMP3.launch();
    /*} catch(ex) {
                dlm_base.loadExternalURL(trackLocation)
              }*/
  }

  return true;
}

function resetWindowObjects() {
  var tempWin = dlm_base.mostRecentWindow("emusic:window").document.getElementById("main-window");
  tempWin.removeAttribute("laststate");
  tempWin.removeAttribute("windowState");
  
  document.getElementById("menu_FileTrayMinimize").setAttribute("checked", true);
  document.getElementById("menu_FileTrayClose").setAttribute("checked", true);

  setMinimizeToTray(document.getElementById("menu_FileTrayMinimize").getAttribute("checked"));
  setCloseToTray(document.getElementById("menu_FileTrayClose").getAttribute("checked"));

  document.getElementById("view_popupAlerts").setAttribute("checked", true)
  document.persist("view_popupAlerts", "collapsed");
}

function initOnLoad() {
  prefObserver.register();

  eMainObserver = new eMuObserver();
  eMainObserver.init();

  window.addEventListener("keydown", fullScreenKeys, true);
}

function shutdownCleanup() {
  if (eUpdateInterval) {
    clearInterval(eUpdateInterval);
  }

  prefObserver.unregister();
  eMainObserver.cleanUp();

  window.removeEventListener("keydown", fullScreenKeys, true);
}

function init_remote() {

  bInitializing = true;

  if (gDebugMode) {
    document.getElementById("debug_menu").hidden = false;
    document.getElementById("window-menu").hidden = false;
  }

  eDownloadsView = document.getElementById("dlmTree2");

  eDefaultServer = nsPreferences.copyUnicharPref('eMusic.defaultServer')
  eDefaultHomePage = nsPreferences.copyUnicharPref('eMusic.defaultHomePage')
  
  eTrackPreview = document.getElementById("navBrowserTrackPreview");

  if (nsPreferences.getBoolPref("eMusic.firstrun")) {
    nsPreferences.setBoolPref("eMusic.firstrun", false);
    
    dlm_base.flushPreferences();

    eMusicPlatform.firstTimeRun(); // platform specific resets

    window.openDialog("chrome://emusic/content/theWizard.xul", "setup:wizard", "chrome,centerscreen,titlebar=no,alwaysRaised=yes")

    setTimeout(resetWindowObjects, 100);
    
    if (sqliteUpgrade) {
      setTimeout(sqliteUpgrade.init, 250);
    }

  }  
  
  setMinimizeToTray(document.getElementById("menu_FileTrayMinimize").getAttribute("checked"))
  setCloseToTray(document.getElementById("menu_FileTrayClose").getAttribute("checked"))

  toggleTotalProgress();

  prepMediaManagers();

  try {
    refreshDefaultPlayer();
  } catch (ex) {
    edebug("Error in selecting Media Player and/or Default Syncing Icons");
    edebug(ex);
    //setTimeout(refreshDefaultPlayer, 250);
  }

    // Mark expired tracks before requeuing or displaying deck
  eDownloadsDB.mDBConn.executeSimpleSQL("UPDATE downloads SET download_state = 9 WHERE start_date + 86400000 < strftime('%s', 'now') * 1000 AND download_state != 1;")

  showThisDeck(eCurrentDeck);

  nsPreferences.setBoolPref("eMusic.pauseSyncing", false);
  nsPreferences.setBoolPref("eMusic.template.track", true);

  if (nsPreferences.getBoolPref("eMusic.update.enabled")) {
    checkForDLMUpdates();
    eUpdateInterval = setInterval(function() {checkForDLMUpdates()}, nsPreferences.getIntPref("eMusic.update.interval"))
  } else {
    reQueueDownloads();
    processCmdLinePref();
  }

  bInitializing = false
  
}

function sqlCreateBaseTables(forced) {
  if (forced) {
    eDownloadsDB.mDBConn.executeSimpleSQL("DROP TABLE IF EXISTS albums;");
    eDownloadsDB.mDBConn.executeSimpleSQL("DROP TABLE IF EXISTS downloads;");
  }

  if (!eDownloadsDB.mDBConn.tableExists("albums")) {
    eDownloadsDB.mDBConn.createTable("albums", 'albumid INTEGER PRIMARY KEY DEFAULT 0, album TEXT, album_url LONGVARCHAR, album_art_url LONGVARCHAR, artist TEXT, artist_id INTEGER DEFAULT 0, artist_url LONGVARCHAR, genre TEXT, genre_id INTEGER DEFAULT 0, genre_url LONGVARCHAR, label_name TEXT, label_id INTEGER DEFAULT 0, label_url LONGVARCHAR, styles TEXT, percent_complete INTEGER DEFAULT 0, open INTEGER DEFAULT 1');
  }

  if (!eDownloadsDB.mDBConn.tableExists("downloads")) {
    eDownloadsDB.mDBConn.createTable("downloads", 'trackid INTEGER PRIMARY KEY DEFAULT 0, filename LONGVARCHAR, src_url LONGVARCHAR, album_id INTEGER REFERENCES "albums(albumid)", album TEXT, track_name LONGVARCHAR, track_number INTEGER DEFAULT 1, track_count INTEGER, duration TEXT, disc_number INTEGER DEFAULT 0, disc_count INTEGER DEFAULT 0, start_date INTEGER, end_date INTEGER, download_state INTEGER DEFAULT -1, percent_complete INTEGER DEFAULT 0');
  }
  
  if (forced) {
    eDownloadsDB.mDBConn.executeSimpleSQL("CREATE TRIGGER 'autoDeleteAlbums' AFTER DELETE ON downloads FOR EACH ROW WHEN (select albumid from albums, downloads where albumid = old.album_id and albums.albumid = downloads.album_id) is null  BEGIN delete from albums where albumid = old.album_id; END;")
    eDownloadsDB.mDBConn.executeSimpleSQL("CREATE TRIGGER 'updateAlbumDownloadPercentage' AFTER UPDATE ON downloads BEGIN UPDATE albums SET percent_complete = (SELECT sum(percent_complete) / count(*) FROM downloads WHERE album_id = old.album_id)  WHERE albumid = old.album_id; END")
    eDownloadsDB.mDBConn.executeSimpleSQL("CREATE INDEX IF NOT EXISTS idxAlbumName ON albums ('album');")
    eDownloadsDB.mDBConn.executeSimpleSQL("CREATE INDEX IF NOT EXISTS idxDownloadsAlbumName ON downloads ('album');")
    eDownloadsDB.mDBConn.executeSimpleSQL("CREATE INDEX IF NOT EXISTS idxAlbumID ON albums ('albumid');")
    eDownloadsDB.mDBConn.executeSimpleSQL("CREATE INDEX IF NOT EXISTS idxDownloadsAlbumID ON downloads ('album_id');")
  }
}

var sqlUpgradeVersion = "1.8";

try {
  if (!eDownloadsDB.mDBConn.tableExists("sqlUpdates")) {
    eDownloadsDB.mDBConn.createTable("sqlUpdates", "version TEXT");

    sqlCreateBaseTables(true);

  } else {

    // Repair potential crashers
    eDownloadsDB.mDBConn.executeSimpleSQL("DELETE FROM albums WHERE albumid = 0")
    eDownloadsDB.mDBConn.executeSimpleSQL("DELETE FROM downloads WHERE filename = ''")

    var sqlUpgradeStatement = eDownloadsDB.mDBConn.createStatement("SELECT version FROM sqlUpdates WHERE version = ?1");
    sqlUpgradeStatement.bindUTF8StringParameter(0, sqlUpgradeVersion);

    var rc =  sqlUpgradeStatement.executeStep();

    if (!rc) {
      eDownloadsDB.mDBConn.executeSimpleSQL("INSERT INTO sqlUpdates VALUES ('" + sqlUpgradeVersion +"');")

      switch (sqlUpgradeVersion) {
        case "1.8":
          // eDownloadsDB.mDBConn.executeSimpleSQL("ALTER TABLE albums ADD COLUMN download_date INTEGER")
          // var newDate = new Date()
          // eDownloadsDB.mDBConn.executeSimpleSQL("UPDATE albums SET download_date = " + newDate.getTime() + " where download_date ISNULL")
          // break;
      }        
    }
  }

} catch (ex) {
  edebug(eDownloadsDB.mDBConn.lastErrorString)
  edebug(ex)
} finally {

  if (sqlUpgradeStatement) {
    sqlUpgradeStatement.reset();
  }

  eDownloadsDB.mDBConn.executeSimpleSQL("VACUUM;");
  eDownloadsDB.mDBConn.executeSimpleSQL("REINDEX;");
  eDownloadsDB.mDBConn.executeSimpleSQL("ANALYZE;");
}

function sqliteInsertDownload(myDownloadItem, importing) {

  var emusicDatabase = Cc["@emusic.com/emusic/database;1"]
                       .getService(Ci.nsIEmusicDatabase);

  var dlState = -1
  var dlPercent = 0
  
  if (importing) {
    dlState = 1
    dlPercent = 100
  } else {
    myDownloadItem["DURATION"] = dlm_base.secondsToTime(myDownloadItem["DURATION"])
  }

  emusicDatabase.addAlbum(
    dlm_base.sqlScrub(myDownloadItem["ALBUMID"]),
    dlm_base.sqlScrub(myDownloadItem["ALBUM"]),
    dlm_base.sqlScrub(myDownloadItem["ALBUMURL"]),
    dlm_base.sqlScrub(myDownloadItem["ALBUMART"]),
    dlm_base.sqlScrub(myDownloadItem["ARTIST"]),
    dlm_base.sqlScrub(myDownloadItem["ARTISTID"]),
    dlm_base.sqlScrub(myDownloadItem["ARTISTURL"]),
    dlm_base.sqlScrub(myDownloadItem["GENRE"]),
    dlm_base.sqlScrub(myDownloadItem["GENREID"]),
    dlm_base.sqlScrub(myDownloadItem["GENREURL"]),
    dlm_base.sqlScrub(myDownloadItem["LABEL"]),
    dlm_base.sqlScrub(myDownloadItem["LABELID"]),
    dlm_base.sqlScrub(myDownloadItem["LABELURL"]),
    dlm_base.sqlScrub(myDownloadItem["STYLES"]),
    dlPercent);

  var newDate = new Date()
  //var newDate = newDate.toLocaleString() + " (" + newDate.valueOf() + ")"

  if (!myDownloadItem["DATESTARTED"]) myDownloadItem["DATESTARTED"] = newDate.getTime()
  if (!myDownloadItem["DATEENDED"]) myDownloadItem["DATEENDED"] = newDate.getTime()

  emusicDatabase.addDownload(
    dlm_base.sqlScrub(myDownloadItem["TRACKID"]),
    dlm_base.sqlScrub(myDownloadItem["LOCALFILE"]),
    dlm_base.sqlScrub(myDownloadItem["TRACKURL"]),
    dlm_base.sqlScrub(myDownloadItem["ALBUMID"]),
    dlm_base.sqlScrub(myDownloadItem["ALBUM"]),
    dlm_base.sqlScrub(myDownloadItem["TITLE"]),
    dlm_base.sqlScrub(myDownloadItem["TRACKNUM"]),
    dlm_base.sqlScrub(myDownloadItem["TRACKCOUNT"]),
    dlm_base.sqlScrub(myDownloadItem["DURATION"]),
    dlm_base.sqlScrub(myDownloadItem["DISCNUM"]),
    dlm_base.sqlScrub(myDownloadItem["DISCCOUNT"]),
    myDownloadItem["DATESTARTED"],
    myDownloadItem["DATEENDED"],
    dlState, dlPercent);

  emusicDatabase.updateDownloadState(dlm_base.sqlScrub(myDownloadItem["LOCALFILE"]), dlState);
}

var sqliteUpgrade = {

  dlmEntries: null,

  init: function() {

    var profileRDFPath = dlm_base.getSpecialFolder("ProfD")
    profileRDFPath.append("downloads.rdf")

    if (!dlm_base.fileExists(profileRDFPath.path)) return true;


    eMuNotifier("emusic-status-update", "Upgrading List of Downloads, please be patient.");

    try {
      sqliteUpgrade.legacyFix();

      try {
        var RDF = Cc["@mozilla.org/rdf/rdf-service;1"]
                    .getService(Ci.nsIRDFService);
        var Container = Cc["@mozilla.org/rdf/container;1"]
                          .getService(Ci.nsIRDFContainer);
        var ContainerUtils = Cc["@mozilla.org/rdf/container-utils;1"]
                               .getService(Ci.nsIRDFContainerUtils);
        var DS = eDownloadManager.datasource

        Container.Init(DS, RDF.GetResource("NC:DownloadsRoot"));
      
      	sqliteUpgrade.dlmEntries = Container.GetElements();

        // while(sqliteUpgrade.dlmEntries.hasMoreElements()) {
          // setTimeout(sqliteUpgrade.insertParsed, 250);
        // }
        sqliteUpgrade.insertParsed();

        eMuNotifier("emusic-refresh-list", eCurrentDeck);

        if (eDownloadsView.view.rowCount > 0) {
          eDownloadsView.view.selection.select(1)
        }
      } catch (ex) {
        edebug(ex);
      }

      dlm_base.removeFile(profileRDFPath.path)

      eDownloadManager = Cc[dlmgrContractID].getService(dlmgrIID)

      if (typeof gDownloadManager == "undefined")      var gDownloadManager = eDownloadManager
    } catch (ex) {
      edebug(ex);
    }
    return true;
  },
  
  insertParsed: function() {
    eMuNotifier("emusic-status-update", "Download list upgrade in progress, please be patient.");

    var myDownloadItem = {};
    var dlmEntry = sqliteUpgrade.dlmEntries.getNext();
    var dlmEntryID = dlmEntry.QueryInterface(Ci.nsIRDFResource).ValueUTF8

    myDownloadItem["ALBUMID"]     = getRDFProperty(dlmEntryID, "albumid")
    myDownloadItem["ALBUM"]       = getRDFProperty(dlmEntryID, "album")
    myDownloadItem["ALBUMURL"]    = getRDFProperty(dlmEntryID, "albumurl")
    myDownloadItem["ALBUMART"]    = getRDFProperty(dlmEntryID, "albumart")
    myDownloadItem["ARTIST"]      = getRDFProperty(dlmEntryID, "artist")
    myDownloadItem["ARTISTID"]    = getRDFProperty(dlmEntryID, "artistid")
    myDownloadItem["ARTISTURL"]   = getRDFProperty(dlmEntryID, "artisturl")
    myDownloadItem["GENRE"]       = getRDFProperty(dlmEntryID, "genre")
    myDownloadItem["GENREID"]     = getRDFProperty(dlmEntryID, "genreid")
    myDownloadItem["GENREURL"]    = getRDFProperty(dlmEntryID, "genreurl")
    myDownloadItem["LABEL"]       = getRDFProperty(dlmEntryID, "label")
    myDownloadItem["LABELID"]     = getRDFProperty(dlmEntryID, "labelid")
    myDownloadItem["LABELURL"]    = getRDFProperty(dlmEntryID, "labelurl")
    myDownloadItem["STYLES"]      = getRDFProperty(dlmEntryID, "styles")
   
    myDownloadItem["TRACKID"]     = getRDFProperty(dlmEntryID, "trackid")
    myDownloadItem["LOCALFILE"]   = dlmEntryID
    myDownloadItem["TRACKURL"]    = getRDFProperty(dlmEntryID, "URL")
    myDownloadItem["TITLE"]       = getRDFProperty(dlmEntryID, "title")
    myDownloadItem["TRACKNUM"]    = getRDFProperty(dlmEntryID, "tracknum")
    myDownloadItem["TRACKCOUNT"]  = getRDFProperty(dlmEntryID, "trackcount")
    myDownloadItem["DURATION"]    = getRDFProperty(dlmEntryID, "duration")
    myDownloadItem["DISCCOUNT"]   = getRDFProperty(dlmEntryID, "disccount")
    myDownloadItem["DISCNUM"]     = getRDFProperty(dlmEntryID, "discnum")
    myDownloadItem["DATESTARTED"] = new Date(getRDFProperty(dlmEntryID, "DateStarted"))
    myDownloadItem["DATEENDED"]   = new Date(getRDFProperty(dlmEntryID, "DateEnded"))

    myDownloadItem["DATESTARTED"] = myDownloadItem["DATESTARTED"].getTime()
    myDownloadItem["DATEENDED"]   = myDownloadItem["DATEENDED"].getTime()

    if (myDownloadItem["ALBUMID"] && myDownloadItem["ALBUMID"] != "" && myDownloadItem["ALBUMID"] != "0") {
      sqliteInsertDownload(myDownloadItem, true);
    }
    
    if (sqliteUpgrade.dlmEntries.hasMoreElements()) {
      setTimeout(sqliteUpgrade.insertParsed, 50);
    } else {
      eMuNotifier("emusic-status-update", "Download list upgrade complete.");
    }
  },

  legacyFix: function() {
    //Attempt fixing legacy importing of download queue
    try {
      eDownloadManager = Cc[dlmgrContractID].getService(dlmgrIID)
    } catch(ex) {
      edebug(ex);
      try {
        var downloadsRDFcontents = dlm_base.getContents(profileRDFPath.path)
      
        var myRegEx = new RegExp(/[â€™||\`]/g);
        downloadsRDFcontents = downloadsRDFcontents.replace(myRegEx, "'");
        
        dlm_base.writeContents(profileRDFPath, downloadsRDFcontents)

      } catch(ex) {
        edebug(ex);
        dlm_base.removeFile(profileRDFPath.path)
        eDownloadManager = Cc[dlmgrContractID].getService(dlmgrIID)
        eDownloadManager.saveState();
      }
    }
  }
}

window.addEventListener("load", function() { initOnLoad(); } , false);
window.addEventListener("unload", function() { shutdownCleanup(); } , false);

