// Firefox specific functions for MinimizeToTray


if (!('extensions' in window))
    window.extensions = new Array();

if (!('mook' in window.extensions))
    window.extensions.mook = new Array();

if (!('minimizetotray' in window.extensions.mook))
    window.extensions.mook.minimizetotray = 
    function(){
        // this is a stub only
        throw Components.results.NS_ERROR_ABORT;
    };

    window.extensions.mook.minimizetotray
.trayCallback = 
function ( aEvent, aParam, aKeyMask, aMouseX, aMouseY ) {
    // note that |this| is the function itself
    var self = window.extensions.mook.minimizetotray;
    var iface = Components.interfaces.trayIWindowCallback;
    var rv = false;

    switch (aEvent) {        
        case iface.EVENT_MOUSEDBLCLK_LEFT:
            //regardless of options, if something goes bad, we
            //want to have double click default to restore.
            self.restore();
            rv = true;
            break;
        case iface.EVENT_MOUSEUP_LEFT:
            try {
 	        //if the user selected the option to only have a double
	        //click restore the window, then don't process this
                if (!self.m_prefs.getBoolPref(
                        self.k_pref_prefix + 'two-click-restore')) { 
                    self.restore();
                    rv = true;	         
                }
            }
            catch (ex) {}
            break;	
        case iface.EVENT_MOUSEUP_RIGHT:
            var popup = document.getElementById(
                self.k_xul_prefix + 'traypopup');
            self.showPopup( popup, aMouseX, aMouseY );
            rv = true;
            break;
    }
    
    return rv;
};

    window.extensions.mook.minimizetotray
.trayTurboCallback = 
function ( aEvent, aParam, aKeyMask, aMouseX, aMouseY ) {
    // callback for -turbo mode (quicklaunch)
    // note that |this| is the function itself
    var self = window.extensions.mook.minimizetotray;
    var iface = Components.interfaces.trayIWindowCallback;
    var rv = false;
    switch (aEvent) {
        case iface.EVENT_MOUSEDBLCLK_LEFT:
            window.OpenBrowserWindow();
            rv = true;
            break;
        case iface.EVENT_MOUSEUP_RIGHT:
            var popup = document.getElementById(
                self.k_xul_prefix + 'trayturbopopup');
            self.showPopup( popup, aMouseX, aMouseY );
            rv = true;
            break;
    }
    return rv;
};

    window.extensions.mook.minimizetotray
.trayTurboClose = 
function () {
    var wm = 
        Components.classes["@mozilla.org/appshell/window-mediator;1"]
            .getService(Components.interfaces.nsIWindowMediator);
    var e = wm.getEnumerator(null);
    while (e.hasMoreElements()) {
        var w = e.getNext();
        if ('extensions' in w && 'mook' in w.extensions &&
          'minimizetotray' in w.extensions.mook &&
          w.extensions.mook.minimizetotray.m_isTurboMode) {
            // |w| is a turbo-mode window
            w.extensions.mook.minimizetotray.restore();
            w.close();
        }
    }
}

    window.extensions.mook.minimizetotray
.turboMode = 
function ( ) {
    var self = window.extensions.mook.minimizetotray;
    self.noBinaryComponentWarning();
    
    // look for existing -turbo mode windows
    var wm = 
        Components.classes["@mozilla.org/appshell/window-mediator;1"]
            .getService(Components.interfaces.nsIWindowMediator);
    var e = wm.getEnumerator(null);
    while (e.hasMoreElements()) {
        var w = e.getNext();
        if ('extensions' in w && 'mook' in w.extensions &&
          'minimizetotray' in w.extensions.mook &&
          w.extensions.mook.minimizetotray.m_isTurboMode)
            // a turbo mode window already exists
            return;
    }
    
    // make the -turbo mode window
    self.m_windowHider =
        Components.classes[self.k_contractid_windowHider]
            .createInstance(Components.interfaces.trayIWindowHider);
    var baseWindows = [self.getBaseWindow(window)];
    
    self.m_windowHider.minimize(
        baseWindows.length, 
        baseWindows,
        null,
        self.trayTurboCallback);
    
    self.m_isTurboMode = true;
    self.m_isHidden = true;
};

// WA: Fullscreen minimize-button Overlay
function mtt_minimizebuttonOnClick(event) {
    if(event.button==2) {
        if(event.ctrlKey) {
            window.extensions.mook.minimizetotray.minimizeAll();
        } else {
            window.extensions.mook.minimizetotray.minimizeWindow();
        }
    } else if(event.button==1) {
        window.extensions.mook.minimizetotray.minimizeAll();
    }
}

function mtt_minimizebuttonOnCommand() {
    if(window.extensions.mook.minimizetotray.
       m_prefs.getBoolPref(window.extensions.mook.minimizetotray.
                           k_pref_prefix + 'always')) {
        window.extensions.mook.minimizetotray.minimizeWindow();
    } else {
        window.minimize();
    }
}

// signal that the app-specific parts have done loading
window.extensions.mook.minimizetotray.m_bLoadedApp = true;
