/*-*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

  ***** BEGIN LICENSE BLOCK *****
* Version: MPL 1.1/GPL 2.0/LGPL 2.1
*
* The contents of this file are subject to the Mozilla Public License Version
* 1.1 (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an "AS IS" basis,
* WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
* for the specific language governing rights and limitations under the
* License.
*
* The Original Code is:
* ChattyTunes - a ChatZilla Media Player plugin utilizing the FoxyTunes
* Firefox Extension by Alex Sirota (alex@elbrus.com)
*
* The Initial Developers of the Original Code are:
* David Corry <dmcorry@gmail.com> and Gijs Kruitbosch <gijskruitbosch@gmail.com>.
*
* Portions created by David Corry and Gijs Kruitbosch are Copyright (C) 2006
* David Corry and Gijs Kruitbosch. All Rights Reserved.
*
* Contributor(s): David Corry & Gijs Kruitbosch
*
* Alternatively, the contents of this file may be used under the terms of
* either the GNU General Public License Version 2 or later (the "GPL"), or
* the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
* in which case the provisions of the GPL or the LGPL are applicable instead
* of those above. If you wish to allow use of your version of this file only
* under the terms of either the GPL or the LGPL, and not to allow others to
* use your version of this file under the terms of the MPL, indicate your
* decision by deleting the provisions above and replace them with the notice
* and other provisions required by the LGPL or the GPL. If you do not delete
* the provisions above, a recipient may use your version of this file under
* the terms of any one of the MPL, the GPL or the LGPL.
*
* A big "thank you" to the ChatZilla IRC channel members, for helping us
* whenever we needed it! :-)
*
****** END LICENSE BLOCK ***** */

/****** BEGIN FOXYTUNES LICENSE BLOCK *****
*
* FoxyTunes Extension and Engine - Copyright (C) 2004-2006 FoxyTunes. All Rights Reserved.
*
* FoxyTunes extension is used with written permission.
*
* Contact FoxyTunes at info@foxytunes.com for more information.
*
* FoxyTunes Home Page - http://www.foxytunes.com/
*
****** END FOXYTUNES LICENSE BLOCK ******/

plugin.id = "ChattyTunes";
const CT_ERROR = "tunes-error";
const CT_PLAY = "tunes-play";
const CT_INFO = "tunes-info";
const CT_PAUSE = "tunes-pause";
const CT_STOP = "tunes-stop";
const CT_MUTE = "tunes-mute";

plugin.init =
function initPlugin (glob)
{
    //Setting up any global things that might come of use to anybody.
    plugin.major = 0;
    plugin.minor = 8;
    plugin.version = plugin.major + "." + plugin.minor;
    plugin.urlString = String(plugin.url).replace(/\/[^\/]*$/, "/");
    plugin.bundleURL = plugin.urlString + "locale/locale.properties";
    plugin.bundle = client.messageManager.addBundle(plugin.bundleURL);
    plugin.updateURL = "http://downloads.mozdev.org/czplugins/utility/chattytunes/update.ini";
    plugin.description = MSG_CHATTYTUNES_DESCRIPTION;
    plugin.onPrefChanged = onPrefChanged;

    //Player map.
    plugin.playersMap = {
        iTunes: {
            shortName: "iTunes",
            accessKey: "u",
            longName: "iTunes"
        },
        Pandora: {
            shortName: "Pandora",
            accessKey: "P",
            longName: "Pandora"
        },
        YahooMusicEngine: {
            shortName: "Yahoo!",
            accessKey: "Y",
            longName: "Yahoo! Music"
        },
        XboxMediaCenter: {
            shortName: "XBMC",
            accessKey: "X",
            longName: "Xbox Media Center"
        },
        musikCube: {
            shortName: "musikCube",
            accessKey: "u",
            longName: "musikCube"
        },
        WindowsMediaPlayer: {
            shortName: "WMP",
            accessKey: "W",
            longName: "Windows Media Player"
        },
        WinAmp: {
            shortName: "Winamp",
            accessKey: "W",
            longName: "Winamp"
        },
        WinAmp3: {
            shortName: "Winamp",
            accessKey: "W",
            longName: "Winamp 3"
        },
        XMPlay: {
            shortName: "XMPlay",
            accessKey: "X",
            longName: "XMPlay"
        },
        JetAudio: {
            shortName: "jetAudio",
            accessKey: "A",
            longName: "jetAudio"
        },
        Apollo: {
            shortName: "Apollo",
            accessKey: "a",
            longName: "Apollo",
        },
        MusicMatchJukeBox: {
            shortName: "MusicMatch",
            accessKey: "M",
            longName: "MusicMatch Jukebox"
        },
        wxMusik: {
            shortName: "wxMusik",
            accessKey: "w",
            longName: "wxMusik"
        },
        GenericPlayer: {
            shortName: "Tunes",
            accessKey: "u",
            longName: "my music player"
        },
        foobar2000: {
            shortName: "foobar2000",
            accessKey: "b",
            longName: "foobar2000"
        },
        MediaMonkey: {
            shortName: "MediaMonkey",
            accessKey: "M",
            longName: "MediaMonkey"
        },
        JRiverMediaCenter: {
            shortName: "JRiver",
            accessKey: "J",
            longName: "JRiver Media Center",
        },
        Sonique: {
            shortName: "Sonique",
            accessKey: "S",
            longName: "Sonique"
        },
        TheCoreMediaPlayer: {
            shortName: "CoreMedia",
            accessKey: "C",
            longName: "The Core Media Player"
        },
        QuintessentialPlayer: {
            shortName: "QCD",
            accessKey: "Q",
            longName: "Quintessential Player"
        },
        XMMS: {
            shortName: "XMMS",
            accessKey: "X",
            longName: "XMMS"
        },
        Noatun: {
            shortName: "Noatun",
            accessKey: "N",
            longName: "Noatun"
        },
        Juk: {
            shortName: "Juk",
            accessKey: "J",
            longName: "Juk"
        },
        MusicPlayerDaemon: {
            shortName: "MPD",
            accessKey: "P",
            longName: "Music Player Daemon"
        },
        Amarok: {
            shortName: "Amarok",
            accessKey: "A",
            longName: "Amarok"
        },
        Rhythmbox: {
            shortName: "Rhythmbox",
            accessKey: "R",
            longName: "Rhythmbox"
        },
        RealPlayer: {
            shortName: "RealPlayer",
            accessKey: "R",
            longName: "RealPlayer"
        }
    }

    //Prefrences ahoy!
    var myprefs = [
        ["NPFormat", MSG_CHATTYTUNES_DEFAULTNPFORMAT, ""],
        ["infoFormat", MSG_CHATTYTUNES_DEFAULTINFOSTRING, ""],
        ["idleString", MSG_CHATTYTUNES_DEFAULTIDLESTRING, ""],
        ["noMetaData", MSG_CHATTYTUNES_DEFAULTNODATASTRING, ""],
        ["maxDoubleTakes", 20, ""],
        ["maxSearchErrors", 10, ""],
        ["outputFilterEnabled", "true", ""]
    ];
    plugin.prefary.stringBundle = plugin.bundle;
    plugin.prefary = plugin.prefary.concat(myprefs);

    //Response maps for those who stylize Chatzilla.
    client.responseCodeMap["tunes"] = "[TUNES]";
    client.responseCodeMap["tunes-error"] = "[TUNES]";
    client.responseCodeMap["tunes-play"] = "[TUNES]";
    client.responseCodeMap["tunes-pause"] = "[TUNES]";
    client.responseCodeMap["tunes-stop"] = "[TUNES]";
    client.responseCodeMap["tunes-mute"] = "[TUNES]";
    
    //Replace regexp for title, player, position, length
    plugin.re = /\$\((player|track|length|position|artist|album|title)\)/gi;

    //Event pump. Thanks to Silver.
    plugin.newEvent =
    function _newEvent (set, type, obj, fun) 
    {
        return new CEvent(set, type, obj, fun);
    }
}

plugin.enable =
function enablePlugin ()
{
    var cmdManager = client.commandManager;
    plugin.cmdlist = [
        ["np", cmdCTGeneral, CMD_CONSOLE | CMD_NEED_CHAN],
        ["ctplay", cmdCTPlay, CMD_CONSOLE, "[<terms>]"],
        ["ctsearch", cmdCTGeneral, CMD_CONSOLE],
        ["ctpause", cmdCTGeneral, CMD_CONSOLE],
        ["ctstop", cmdCTGeneral, CMD_CONSOLE],
        ["ctplaying", cmdCTGeneral, CMD_CONSOLE],
        ["ctnext", cmdCTGeneral, CMD_CONSOLE],
        ["ctprev", cmdCTGeneral, CMD_CONSOLE],
        ["ctmute", cmdCTGeneral, CMD_CONSOLE],
        ["ctshowplayer", cmdCTGeneral, CMD_CONSOLE],
        ["cthideplayer", cmdCTGeneral, CMD_CONSOLE],
        ["ctplayfile", cmdCTGeneral, CMD_CONSOLE],
        ["ctinsertsong", cmdCTInsertSong, 0],
        ["ctoptions", cmdCTOptions, 0],
        ["ctmenuinsertsong", "ctinsertsong", 0]
    ];
    plugin.cmdlist.stringBundle = plugin.bundle;
    plugin.cmdlist = cmdManager.defineCommands(plugin.cmdlist);
    cmdManager.argTypes["terms"] = cmdManager.argTypes["rest"];

    plugin.prefManager.defaultBundle = plugin.bundle;

    if (!("outputFilters" in client))
        client.outputFilters = new Object();
    var enableFilter = false;
    if (plugin.prefs["outputFilterEnabled"].match(/on|1|true/))
        enableFilter = true;
    client.outputFilters["chattytunes"] = { func: textFilter,
                                            enabled: enableFilter };

    //Check if FoxyTunes exists. Only needs to be run on init,
    //seeing as nothing is going to happen while Cz is open.
    var foxyTunes2 = Components.classes["@foxytunes.org/FoxyTunesEngine/FoxyTunesService;1"]
    if (foxyTunes2)
    {
        var foxyTunesPrefService = Components.classes["@mozilla.org/preferences-service;1"]
                                   .getService(Components.interfaces.nsIPrefService);
        
        //Check if prefs exist.
        try
        {
            plugin.fTPrefs = foxyTunesPrefService.getBranch("foxytunes.");
            plugin.playerClass = plugin.fTPrefs.getCharPref("player_class");
            plugin.playerId = plugin.playerClass.split(/(\/|;)/)[4];
            plugin.encoding = plugin.fTPrefs.getCharPref("character_encoding")
        }
        catch (e)
        {
            //Back out because prefs aren't set.
            client.display(MSG_CHATTYTUNES_NOFOXYPREFS, CT_ERROR);
            plugin.enabled = false;
            plugin.prefs["enabled"] = false;
            plugin.disable();
            return false;
        }
        plugin.foxyTunesInstalled = true;
    }

    if (plugin.foxyTunesInstalled)
    {
        display(getMsg(MSG_CHATTYTUNES_ENABLED, plugin.version));
    }
    else
    {
        client.display(getMsg(MSG_CHATTYTUNES_NOFOXYTUNES, client.host),
                           CT_ERROR);
        plugin.enabled = false;
        plugin.prefs["enabled"] = false;
        plugin.disable();
        return false;
    }

    //Now we can set up FoxyTunes only once.
    plugin.foxyTunes = Components.classes['@foxytunes.org/FoxyTunesEngine/FoxyTunesService;1']
                       .getService(Components.interfaces.IFoxyTunesService);
    plugin.foxyTunesData = plugin.foxyTunes.GetCurrentTrackData;


    //That damn menu.
    var menuPresence = ("mainmenu:chatty" in client.menuManager.menuSpecs);
    if (plugin.playerId in plugin.playersMap)
        var playerId = plugin.playersMap[plugin.playerId];
    else
        var playerId = plugin.playersMap["GenericPlayer"];
    var aKey = playerId.accessKey;
    var menuLabel = playerId.shortName.replace(aKey, "&" + aKey);

    client.menuManager.menuSpecs["mainmenu:chatty"] = {
        label: menuLabel,
        getContext: getTunesContext,
        items: [
            ["ctplay",           {label: MSG_CHATTYTUNES_MENUPLAY}],
            ["ctstop",           {label: MSG_CHATTYTUNES_MENUSTOP}],
            ["ctpause",          {label: MSG_CHATTYTUNES_MENUPAUSE}],
            ["ctnext",           {label: MSG_CHATTYTUNES_MENUNEXT}],
            ["ctprev",           {label: MSG_CHATTYTUNES_MENUPREV}],
            ["ctmute",           {label: MSG_CHATTYTUNES_MENUMUTE,
                                  type: "checkbox",
                                  checkedif: "cx.isMuted != false"}],
            ["-"],
            ["ctsearch",         {label: MSG_CHATTYTUNES_MENUSEARCH}],
            ["-"],
            ["ctoptions",        {label: MSG_CHATTYTUNES_MENUOPTIONS}],
            ["-",                {visibleif: "cx.currentSong != null"}],
            ["ctmenuinsertsong", {format: "$currentSong", label: "ChattyTunes",
                                  style: "font-weight: bold", 
                                  visibleif: "cx.currentSong != null"}]
        ]
    };
    client.updateMenus();

    //Commands:
    plugin.chattyTunesCmds = {
        ctmute: plugin.foxyTunes.ToggleMute,
        cthideplayer: plugin.foxyTunes.HidePlayer,
        ctshowplayer: plugin.foxyTunes.ShowPlayer,
        ctplayfile: plugin.foxyTunes.PlayFile,
        ctpause: function () {
            plugin.foxyTunes.Pause();
            display(MSG_CHATTYTUNES_PAUSED, CT_PAUSE);
        },
        ctstop: function () {
            plugin.foxyTunes.Stop();
            display(MSG_CHATTYTUNES_STOPPED, CT_STOP);
        },
        ctnext: function () {
            plugin.foxyTunes.Next();
            if(plugin.playerId == "GenericPlayer")
                display(MSG_CHATTYTUNES_NEXT, CT_PLAY);
            else
                timeOutNPMsg();
        },
        ctprev: function () {
            plugin.foxyTunes.Previous();
            if(plugin.playerId == "GenericPlayer")
                display(MSG_CHATTYTUNES_PREV, CT_PLAY);
            else
                timeOutNPMsg();
        },
        ctplaying: function () {
            display(getInfoString(plugin.prefs["infoFormat"]), CT_PLAY);
        },
        ctsearch: function () {
            var searchString = prompt(MSG_CHATTYTUNES_SEARCHFORM, "");
            if (searchString)
                dispatch("ctplay " + searchString);
        },
        np: function () {
            // Hack in order not to double-replace all the variables...
            var commandStr = stringTrim(getInfoString(plugin.prefs["NPFormat"]));
            if (/^(me|say)/.test(commandStr) && plugin.enabled)
                client.outputFilters["chattytunes"].enabled = false;
            dispatch(commandStr);
            client.outputFilters["chattytunes"].enabled = true;
        }
    }

    return true;
}

plugin.disable =
function disablePlugin ()
{
    plugin.chattyTunesCmds = null;
    if ("chattytunes" in client.outputFilters)
        client.outputFilters["chattytunes"].enabled = false;
    document.getElementById("mainmenu:chatty").collapsed = true;
    client.commandManager.removeCommands(plugin.cmdlist);
    display(getMsg(MSG_CHATTYTUNES_DISABLED, plugin.version));
    return true;
}

function getTunesContext ()
{
    checkForNewFT();
    cx = new Object();
    cx.isMuted = plugin.foxyTunes.IsMuted();
    cx.currentSong = plugin.foxyTunes.GetCurrentTrackTitle();
    if (cx.currentSong === "" || plugin.foxyTunes == null)
        cx.currentSong = null;
    if ("encoding" in plugin && plugin.encoding != "default" && cx.currentSong != null)
        cx.currentSong = toUnicode(cx.currentSong, plugin.encoding);
    else
        cx.currentSong = toUnicode(cx.currentSong, "UTF-8");
    return cx;
}

function checkForNewFT ()
{
    var playerClass = plugin.fTPrefs.getCharPref("player_class");
    var encoding = plugin.fTPrefs.getCharPref("character_encoding");
    var identical = ("encoding" in plugin && "playerClass" in plugin &&
                     plugin.playerClass == playerClass && plugin.encoding == encoding);
    if ("foxyTunes" in plugin && plugin.foxyTunes != null && identical)
        return true;
    if ("encoding" in plugin && plugin.encoding != encoding)
        display(MSG_CHATTYTUNES_CHANGEDENCODING, CT_INFO);
    if ("playerClass" in plugin && plugin.playerClass != playerClass)
        display(MSG_CHATTYTUNES_CHANGEDPLAYER, CT_INFO);
    plugin.encoding = plugin.fTPrefs.getCharPref("character_encoding");
    plugin.playerClass = plugin.fTPrefs.getCharPref("player_class");
    plugin.playerId = plugin.playerClass.split(/(\/|;)/)[4];
    updateMenuLabel();
    return true;
}

function getInfoString (message)
{
    message = message.replace(plugin.re, replaceVars);
    if (client.prefs["outgoing.colorCodes"] == true)
        message = replaceColorCodes(message);
    return message;
}

function textFilter (msg, msgtype)
{
    if (!plugin.enabled)
        return msg;
    if (!checkForNewFT())
        return msg;
    msg = msg.replace(plugin.re, replaceVars);
    return msg;
}

function getTimeString (seconds) 
{
    if (!parseInt(seconds, 10))
        return "0:00";
    seconds = parseInt(seconds);
    if (seconds == 4294967 || seconds == 4294967295) //Winamp & QCD
        seconds = 0;
    var time_hours = Math.floor(seconds / 3600);
    var time_seconds = seconds % 60;
    var time_minutes = ((seconds % 3600) - time_seconds) / 60;
    if (time_seconds < 10)
        time_seconds = "0" + time_seconds;
    var timeStr = time_minutes + ":" + time_seconds;
    if (time_hours > 0)
    {
        if (time_minutes < 10)
            timeStr = "0" + timeStr;
        timeStr = time_hours + ":" + timeStr;
    }
    return timeStr;
}

function replaceVars (match, type)
{
    var currentInfo = plugin.foxyTunesData(false).wrappedJSObject;
    switch (type)
    {
        case "player":
            if(plugin.playerId in plugin.playersMap)
                return plugin.playersMap[plugin.playerId].longName;
            return plugin.playersMap["GenericPlayer"].longName;
        case "track":
            return getTrackTitle();
        case "length":
            return getTrackLength();
        case "position":
            return getTrackPos();
        case "artist":
            if (currentInfo.artist != undefined)
                return setEncoding(currentInfo.artist);
            return plugin.prefs["noMetaData"];
        case "album":
            if (currentInfo.album != undefined)
                return setEncoding(currentInfo.album);
            return plugin.prefs["noMetaData"];
        case "title":
            if (currentInfo.title != undefined)
                return setEncoding(currentInfo.title);
            else if (getTrackTitle() === plugin.prefs["idleString"])
                return plugin.prefs["idleString"];
            return plugin.prefs["noMetaData"];
    }
}

function setEncoding (string)
{
    if ("encoding" in plugin && plugin.encoding != "default")
        string = toUnicode(string, plugin.encoding);
    else
        string = toUnicode(string, "UTF-8");
    return string;
}


function getTrackTitle ()
{
    try
    {
        var song = plugin.foxyTunes.GetCurrentTrackTitle();
    }
    catch (ex)
    {
        var song = null;
    }
    if (song === "" || song == null)
        song = plugin.prefs["idleString"];

   return setEncoding(song);
}

function getTrackLength ()
{
    try
    {
        return getTimeString(plugin.foxyTunes.GetCurrentTrackLength());
    }
    catch (ex)
    {
        return "0:00";
    }
}

function getTrackPos ()
{
    try
    {
        return getTimeString(plugin.foxyTunes.GetCurrentTrackPosition());
    }
    catch (ex)
    {
        return "0:00";
    }
}

function updateMenuLabel () 
{
    if (plugin.playerId in plugin.playersMap)
        var playerId = plugin.playersMap[plugin.playerId];
    else
        var playerId = plugin.playersMap["GenericPlayer"];
    var aKey = playerId.accessKey;
    var menuLabel = playerId.shortName.replace(aKey, "&" + aKey);
    client.menuManager.menuSpecs["mainmenu:chatty"].label = menuLabel;
    client.updateMenus();
}

function timeOutNPMsg ()
{
    setTimeout("display('" + getInfoString(plugin.prefs["infoFormat"]) + 
               "', 'tunes-play')", 1500);
}

function cmdCTGeneral (e)
{
    checkForNewFT();
    var commandname = e.command.name.toLowerCase();
    try
    {
        plugin.chattyTunesCmds[commandname]();
    }
    catch(ex)
    {
        var pms = [commandname, ex.message];
        display(getMsg(MSG_CHATTYTUNES_ERRORGENERAL, pms), MT_ERROR);
    }
    return;
}

function cmdCTInsertSong (e) {
    checkForNewFT();
    var song = getTrackTitle();
    var input = document.getElementById("input");
    var text = input.value;
    if (!text) 
    {
        input.value = song;
        return;
    }

    var selStart = input.selectionStart;
    var selEnd = input.selectionEnd;
    var textBeginning = text.substring(0, selStart);
    var textEnd = text.substring(selEnd);
    if (selStart != selEnd)
    {
        textBeginning += song;
        input.value = textBeginning + textEnd;
        input.selectionEnd = input.selectionStart + (selEnd - selStart);
    } 
    else 
    {
        if (textBeginning.match(/\s$/))
        {
            textBeginning += song;
        } 
        else if (textBeginning.match(/\"$/)) 
        {
            var quoteNumber = textBeginning.split("\"");
            quoteNumber = quoteNumber.length - 1;
            if (quoteNumber % 2 == 0)
                textBeginning += " " + song;
            else
                textBeginning += song + "\"";
        } 
        else 
        {
            textBeginning += " " + song;
        }

        if (!textEnd.match(/^\s/))
            textEnd = " " + textEnd;
        input.value = textBeginning + textEnd;
    }
}

function cmdCTPlay (e)
{
    checkForNewFT();
    var searcherrors = 0;
    if (e.terms == null)
    {
        plugin.foxyTunes.Play();
        timeOutNPMsg();
    }
    else
    {
        plugin.foxyTunes.Stop();
        var searchExpression = new RegExp(e.terms, "gi");
        display(MSG_CHATTYTUNES_SEARCHING, CT_INFO);

        try 
        {
            var oldtitle = plugin.foxyTunes.GetCurrentTrackTitle();
        } 
        catch (ex) 
        {
            display(getMsg(MSG_CHATTYTUNES_ERRORORIGINALTITLE, ex), CT_ERROR);
            var oldtitle = null;
            return;
        }
        var searchfailed = false;
        var currenttitle = "";
        var lasttitle = oldtitle;
        var searcherrors = 0;
        var doubletakes = 0;

        do
        {
            plugin.foxyTunes.Next();
            try 
            {
                currenttitle = plugin.foxyTunes.GetCurrentTrackTitle();
            } 
            catch (ex) 
            {
                searcherrors++;
                currenttitle = null;
            }
            while (currenttitle == null || currenttitle == lasttitle)
            {
                doubletakes++;
                try
                {
                    currenttitle = plugin.foxyTunes.GetCurrentTrackTitle();
                } 
                catch (ex) 
                {
                    currenttitle = null;
                    searcherrors++;
                    if (searcherrors >= plugin.prefs["maxSearchErrors"])
                    {
                        display(MSG_CHATTYTUNES_ERRORMAXERRORS, CT_ERROR);
                        return;
                    }
                }
                if (doubletakes >= plugin.prefs["maxDoubleTakes"])
                {
                    display(MSG_CHATTYTUNES_ERRORDOUBLETAKES, CT_ERROR);
                    return;
                }
            }
            doubletakes = 0;
            if (currenttitle == oldtitle)
            {
                searchfailed = true;
                setTimeout(plugin.foxyTunes.Play, 2000);
            }
            else
            {
                if (currenttitle.match(searchExpression) != null)
                {
                     display(getMsg(MSG_CHATTYTUNES_FOUND, currenttitle), CT_PLAY);
                     setTimeout(plugin.foxyTunes.Play, 2000);
                     return;
                }
                lasttitle = currenttitle;
                if (searcherrors > plugin.prefs["maxSearchErrors"])
                {
                    display(MSG_CHATTYTUNES_ERRORMAXERRORS, CT_ERROR);
                    searcherrors = 0;
                    return;
                }
            }
        }
        while (!searchfailed)
        display(getMsg(MSG_CHATTYTUNES_NOTFOUND, e.terms), CT_INFO);
    }
}

function cmdCTOptions () 
{
    var options = new Object();
    options.NPFormat = plugin.prefs["NPFormat"];
    options.idleString = plugin.prefs["idleString"];
    options.infoFormat = plugin.prefs["infoFormat"];
    options.noMetaData = plugin.prefs["noMetaData"];
    options.maxDoubleTakes = plugin.prefs["maxDoubleTakes"];
    options.maxSearchErrors = plugin.prefs["maxSearchErrors"];
    options.outputFilterEnabled = plugin.prefs["outputFilterEnabled"];
    //Place the dialog with cZ, not randomly off to the side.
    var x = (window.outerWidth-500)/2+window.screenX;
    var y = (window.outerHeight-325)/3+window.screenY;
    var windowArgs = "dialog,dependent,resizable,dialog,width=500,height=325";
        windowArgs += ",screenX=" + x + ",screenY=" + y;
    var dialogURL = plugin.urlString + "dialog/dialog.xul";
    var nickname = client.prefs["nickname"]; //Pass nickname
    var errNoPreview = MSG_CHATTYTUNES_ERRORNOPREVIEW;
    if (client.prefs["outgoing.colorCodes"] = true)
        var replFunc = replaceColorCodes;
    else
        var replFunc = function (msg) { return msg; };
    plugin.options = window.openDialog(dialogURL, "_blank", windowArgs, client,
                                       plugin, replFunc, options, nickname, 
                                       errNoPreview);
}

function setPrefs (e) 
{
    plugin.prefs["NPFormat"] = e.NPFormat;
    plugin.prefs["infoFormat"] = e.infoFormat;
    plugin.prefs["idleString"] = e.idleString;
    plugin.prefs["noMetaData"] = e.noMetaData;
    plugin.prefs["maxDoubleTakes"] = e.maxDoubleTakes;
    plugin.prefs["maxSearchErrors"] = e.maxSearchErrors;
    plugin.prefs["outputFilterEnabled"] = e.outputFilterEnabled;
}

function replaceLiveEditVars (e) 
{
    e.message = getInfoString(e.message);
    var span = document.createElementNS("http://www.w3.org/1999/xhtml",
                                        "html:span");
    e.munged = client.munger.munge(replaceColorCodes(e.message), span, {}).innerHTML;
    plugin.options.fillInVars(e);
}

function onPrefChanged (prefName, newValue, oldValue) {
    if (prefName != "outputFilterEnabled" || plugin.prefs["enabled"] == false)    
        return true;
    if (newValue.match(/on|1|true/))
        client.outputFilters["chattytunes"].enabled = true;
    else
        client.outputFilters["chattytunes"].enabled = false;
}

