/*
<!-- 
****** BEGIN LICENSE BLOCK *****
Version: MPL 1.1/GPL 2.0/LGPL 2.1

The contents of this file are subject to the Mozilla Public License Version 
1.1 (the "License"); you may not use this file except in compliance with 
the License. You may obtain a copy of the License at 
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is Checky.

The Initial Developer of the Original Code is
Joachim Schreiber (yobiz@users.sourceforge.net).
Portions created by the Initial Developer are Copyright (C) 2002-2004
the Initial Developer. All Rights Reserved.

Contributor(s):
Mike Hommey (mh@glandium.org)

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

Checky - Resource Validation and Analysis Extension for Mozilla and Firefox.
Easy to use Interface to many different free and commercial Online 
Validation and Analysis Services. Any rights not expressly granted herein 
are reserved by their owners. 
Please visit all Service Web Sites for more informations about terms of usage 
before using Checky the first time. Hyperlinks are located at 
http://checky.sourceforge.net/#Services

***** END LICENSE BLOCK *****
-->

*/


/*
* mozilla constants
*/
const nsILocalFile        = Components.interfaces.nsILocalFile;
const nsIProperties       = Components.interfaces.nsIProperties;
const nsIFile             = Components.interfaces.nsIFile;
const nsIFilePicker       = Components.interfaces.nsIFilePicker;

/*
* checky constants
*/
const tempDirectoryComplex = "ext.checky.pref.global.tempdirectory";
const tempDirectoryField = "ext.checky.pref.global.tempdirectory.value";
const bundleChecky = "bundle_checky";
const filePickerWindowTitleBundleProperty = "tempdirectory";
const updateUrl = "http://checky.mozdev.org/Install/";

function getSystemPathSeparator(){
	var winPathSeparator = "\\";
	var unixPathSeparator = "/";
	if( getNavigatorPlatform() == 1 ){
		return winPathSeparator;
	}
	return unixPathSeparator;
}

/*
* Executes every time the globals preferences panel opens
*/
function Startup(){

	var path = null;
	var pref = null;

	//check if temporary directory is already set 
	try {
		pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
		path = pref.getComplexValue( tempDirectoryComplex, nsILocalFile );
	}
	catch (ex){
		//if not no prob we do this now...
	}

	//if we have no temp directory path at this moment
	if(!path){
		//we have a look if a profile directory exists
		try{
			var dirSvc = Components.classes["@mozilla.org/file/directory_service;1"].getService(nsIProperties);
			var ifile = dirSvc.get("ProfD", nsIFile);
			path = ifile.QueryInterface(nsILocalFile);
			// now remember the new assumption
			if (pref){
				pref.setComplexValue( tempDirectoryComplex, nsILocalFile, path);
			}
		}
		catch(ex){
			//hm.... also fails so leave everythind as it is
		}
	}

	// if both pref and dir svc fail leave this field blank else show path
	if (path){
		document.getElementById( tempDirectoryField ).value = path.path;
	}

	// set the text to include the version number
	var msg = document.getElementById("bundle_checky").getString("versionlabel");
	var re_1 = /(.*)\.(.*?)$/;
	re_1.test(InstallTrigger.getVersion("checky"));
	msg = msg.replace(new RegExp("#1"), RegExp.$1);
	document.getElementById("ext.checky.pref.global.version").setAttribute("value", msg);
}


function extCheckyPrefTempDirectory(){

	//nsIFilePicker
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	
	//nsIPrefBranch
	var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	
	//property bundle
	var prefBundle = document.getElementById( bundleChecky );

	//nsIFilePicker window title
	var title = prefBundle.getString( filePickerWindowTitleBundleProperty );

	//initialize nsIFilePicker
	fp.init(window, title, nsIFilePicker.modeGetFolder);

	try {
		//read property from preferences
		var initialDir = pref.getComplexValue( tempDirectoryComplex, nsILocalFile);
		if (initialDir){
			fp.displayDirectory = initialDir;
		}
	}
	catch (ex){
		// ignore exception: file picker will open at default location
	}

	//show all
	fp.appendFilters(nsIFilePicker.filterAll);
	
	//show file picker dialog
	var ret = fp.show();

	//if user hits ok 
	if (ret == nsIFilePicker.returnOK) {
		var localFile = fp.file.QueryInterface(nsILocalFile);
		var viewable = fp.file.path;
		
		//our directory field in the preferences panel
		var tempDirectoryFieldValue = document.getElementById( tempDirectoryField );
		
		//show choosen directory in directory field of preferences panel
		tempDirectoryFieldValue.value = viewable;
		
		//set new preference
		pref.setComplexValue( tempDirectoryComplex, nsILocalFile, localFile)
	}

}

function extCheckyUpdate() {
	document.commandDispatcher.focusedWindow.open( updateUrl );
}



