/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;

namespace LocaleInpector
{

internal sealed class Glossary
{

private Glossary()
{
}

public static void Create(string originalDir, string translatedDir, string pathGlossary)
{
    Output.OpenH2("Creating glossary");
    Output.Write("Saving to " + pathGlossary);
    System.Text.Encoding enc = System.Text.Encoding.GetEncoding("iso-8859-1");

    using (System.IO.StringWriter txt = new System.IO.StringWriter()) {

        //txt.WriteLine(BPIO.LoadText(pathGlossary, enc));
        List<string> fileList = BPIO.GetFileList(originalDir, "*");
        for (int idx = 0; idx < fileList.Count; idx++) {
            CreateFile(originalDir, translatedDir, fileList[idx], txt);
        }

        BPIO.Save(txt.ToString(), pathGlossary, enc);
    }

    Output.WriteLine(" OK");
    Output.Close();
}

private static void CreateFile(string originalDir, string translatedDir, string file, System.IO.StringWriter txt)
{
    NameValueFile originalFile = NameValueFile.Load(originalDir + file);
    if (originalFile == null) {
        // unknown format (binary, html, ...)
        return;
    }

    Dictionary<string, string> originalKeys;
    Dictionary<string, string> translatedKeys;

    originalKeys = originalFile.LoadHashtableDecoded();

    NameValueFile translatedFile = NameValueFile.LoadTranslated(translatedDir + file);
    if (translatedFile == null) {
        // translated file is empty
        translatedKeys = new Dictionary<string, string>();
    } else {
        translatedKeys = translatedFile.LoadHashtableDecoded();
    }

    // [0] path/subdir
    // [1] file
    // [2] key
    // [3] original
    // [4] translated
    // [5] original [ascii]
    // [6] translated [ascii]
    string[] fields = new string[7];

    Dictionary<string, string>.Enumerator originalKeyNames = originalKeys.GetEnumerator();
    while (originalKeyNames.MoveNext()) {
        string key = originalKeyNames.Current.Key;
        string orig = translatedFile.Sanitize(originalKeyNames.Current.Value);
        string trans = (translatedKeys.ContainsKey(originalKeyNames.Current.Key))
                            ? translatedFile.Sanitize(translatedKeys[key])
                            : string.Empty;
        if (orig.Length == 0 && trans.Length == 0) {
            continue;
        }

        if (orig.Length == 1 || trans.Length == 1) {
            continue;
        }

        string[] arr = file.Split(System.IO.Path.DirectorySeparatorChar);

        fields[0] = string.Join("/", arr, 0, arr.Length - 1);
        fields[1] = arr[arr.Length - 1];
        fields[2] = key;
        fields[3] = Strings.RemoveWhite(orig);
        fields[4] = Strings.RemoveWhite(trans);
        fields[5] = Strings.ReplaceHighChars(fields[3]).ToLower();
        fields[6] = Strings.ReplaceHighChars(fields[4]).ToLower();

        txt.WriteLine(string.Join("<&item&>", fields));
    }
}

}//class
}//ns