/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace LocaleInpector
{

internal abstract class Merge
{

protected readonly NameValueFile m_dic;

protected Merge(NameValueFile dic)
{
    m_dic = dic;
}

protected abstract string MergeFile(string translatedDir, string file);

protected abstract string MergeFileEx(Dictionary<string, string> translation, string path);

//                                              dir/xpi/jar         dir/zip
public static Status SavePo(Dictionary<string, Dictionary<string, string>> allFiles, string originalDir, string outputDir)
{
    // originalDir   = c:\moz\cvs\en-US
    // translatedDir = c:\MT\pt-BR
    // outputDir     = c:\moz\cvs\pt-BR

    Status stat = new Status();
    //Contributors contrib = new Contributors("");


    XpiList files = new XpiList(originalDir);
    System.IO.FileStream streamArchive = System.IO.File.OpenWrite(outputDir);
    ICSharpCode.SharpZipLib.Zip.ZipOutputStream outputArchive = new ICSharpCode.SharpZipLib.Zip.ZipOutputStream(streamArchive);
    outputArchive.SetLevel(0);


    for (int idx = 0; idx < files.Count; idx++) {

        string pathFile = PoEntry.FormatRef(files.GetFile(idx));
        NameValueFile originalFile = NameValueFile.Load(files.GetFile(idx));
        if (originalFile == null) {
            //Console.WriteLine("Ignoring file " + pathFile);
            stat.Warnings++;
            continue;
        }
        stat.Files++;
        Merge merged = originalFile.GetMerge();
        Dictionary<string, string> translatedEntries = allFiles[pathFile];
        if (translatedEntries == null) {
            // pathFile is a new file or all entries in translation are fuzzy
            translatedEntries = new Dictionary<string, string>();
        }
        string txt = merged.MergeFileEx(translatedEntries, files.GetFile(idx));
        //txt = contrib.Append(txt);

        NameValueFile mergedFile = originalFile;
        mergedFile = mergedFile.LoadFrom(string.Empty);
        mergedFile.AddToArchive(txt, outputArchive, pathFile);
        stat.Comparisons++;
    }

    outputArchive.Finish();
    outputArchive.Close();

    Output.WriteLine(stat.Comparisons + " files have been created.");
    return stat;
}











public static Status Save(string originalDir, string translatedDir, string outputDir)
{
    Output.OpenH2("Merging translated into original");
    Output.WriteLine("To: " + outputDir);
    Status stat = SaveCore(originalDir, translatedDir, outputDir);
    Output.Close();
    return stat;
}

// salvar em ZIP
private static Status SaveCore(string originalDir, string translatedDir, string outputDir)
{
    // originalDir   = c:\moz\cvs\en-US
    // translatedDir = c:\MT\pt-BR
    // outputDir     = c:\moz\cvs\pt-BR

    Status stat = new Status();
    List<string> files = BPIO.GetFileList(originalDir, "*");
    Contributors contrib = new Contributors(Config.Current.GetPref("merge", "contributors"));

    for (int idx = 0; idx < files.Count; idx++) {

        string pathFile = files[idx];
        NameValueFile originalFile = NameValueFile.Load(originalDir + pathFile);
        if (originalFile == null) {
            Output.WriteWarning("Ignoring file " + pathFile);
            stat.Warnings++;
            continue;
        }
        stat.Files++;
        Merge merged = originalFile.GetMerge();
        string txt = merged.MergeFile(translatedDir, pathFile);
        txt = contrib.Append(txt);


        NameValueFile mergedFile = NameValueFile.LoadTranslated(translatedDir + pathFile);
        if (mergedFile != null) {
            //throw(new System.ArgumentNullException(translatedDir + "***" + pathFile));
            mergedFile = mergedFile.LoadFrom(outputDir + pathFile);
        } else {
            // translated file doesn't exist
            mergedFile = originalFile.LoadFrom(outputDir + pathFile);
        }
        if (mergedFile.SaveTo(txt)) {
            stat.Comparisons++;
        }
    }

    Output.WriteLine(stat.Comparisons + "/" + stat.Files + " files have been created/replaced.");
    return stat;
}

protected void WriteWarning(string txt)
{
    if (Config.Current == null) {
        //Console.WriteLine("{0} is fuzzy ", PoEntry.FormatRef(txt) "warn.: " + txt);
    } else {
        Output.WriteWarning(txt);
    }
}


}//class
}//ns
