//include("chrome://jslib/content/io/file.js");

var queue = document.createElement('queue');
function addFile2Queue(queuedFile) {
  //make sure that type is valid
  if(queuedFile.type != 'upload') {
    queuedFile.type = 'download';
  }

  var file         = document.createElement('file');
  var type         = document.createElement('type');
  var locationFrom = document.createElement('locationFrom');
  var locationTo   = document.createElement('locationTo');

  type.setAttribute('value', queuedFile.type);
  locationFrom.setAttribute('value', queuedFile.locationFrom);
  locationTo.setAttribute('value', queuedFile.locationTo);

  file.appendChild(type);
  file.appendChild(locationFrom);
  file.appendChild(locationTo);
  queue.appendChild(file);
  updateQueuedTree();
}


function updateQueuedTree() {
  var tree = document.getElementById('queued');
  var treechildrenTemp = tree.getElementsByTagName('treechildren')[0];
  treechildren = treechildrenTemp.cloneNode(false);
  tree.removeChild(treechildrenTemp);
  tree.appendChild(treechildren);

  for(x=0; x<queue.getElementsByTagName("file").length; x++) {
    var path = queue.getElementsByTagName("file")[x].getElementsByTagName("locationFrom")[0].getAttribute("value");
    var file = new File(path);

    treeitem = document.createElement('treeitem');
    treerow = document.createElement('treerow');
    treecellFilename = document.createElement('treecell');
    treecellSize = document.createElement('treecell');

    treerow.setAttribute('queuedIndex', x);
    if(file.exists()) {
      treecellFilename.setAttribute('label', file.leaf);
      treecellSize.setAttribute('label', file.size);
    }
    else {
      treecellFilename.setAttribute('label', 'file not exsist');
      treecellSize.setAttribute('label', 'null');
    }

    treerow.appendChild(treecellFilename);
    treerow.appendChild(treecellSize);
    treeitem.appendChild(treerow);
    treechildren.appendChild(treeitem);
  }
}

function openFileInformationDialog(queuedIndex) {
  var file = new Object();
  file = queue.getElementsByTagName("file")[queuedIndex];

  //window.setCursor("wait");
  window.openDialog("chrome://filemanager/content/fileInformation.xul", "fileInformationDialog", "chrome", file);
}


/*
 * Tests if the mouse is clicked over an object in the list */
function getQueuedEventElementIndex(event, tree) {
  var row = new Object();
  tree.treeBoxObject.getCellAt( event.clientX, event.clientY, row, {}, {} );

  if( row.value!=-1 && row.value<tree.view.rowCount ) {
    return tree.getElementsByTagName("treechildren")[0].getElementsByTagName("treeitem")[row.value].getElementsByTagName("treerow")[0].getAttribute("queuedIndex");
  }
  else {
    return false;
  }
}

function queuedMouseDown(event) {
  var tree = document.getElementById('queued');

  if(event.button == 2) {
    var queuedIndex = getQueuedEventElementIndex(event, tree);
    if(queuedIndex) {
      document.getElementById("info_about_queued_file").removeAttribute("disabled");
      
      document.getElementById("info_about_queued_file").setAttribute("oncommand", "openFileInformationDialog(" + queuedIndex + ");");
      document.getElementById("remove_queued_file").removeAttribute("disabled");
    }
    else {
      document.getElementById("info_about_queued_file").setAttribute("disabled", "true");
      document.getElementById("remove_queued_file").setAttribute("disabled", "true");
    }
  }
}
