/*
 * Decompiled with CFR 0.152.
 */
package mozilla_training_analyzer;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import mozilla_training_analyzer.TableWindow;
import mozilla_training_analyzer.TrainingData;

public class RemoveTokenWindow
extends JDialog {
    private static final String WINDOW_TITLE = "Please Select Range Of Tokens To Remove";
    private static final int WINDOW_WIDTH = 400;
    private static final int WINDOW_HEIGHT = 150;
    private static final int textFieldSize = 5;
    private JTextField goodTokenNumField;
    private JTextField badTokenNumField;
    private JCheckBox goodTokenBox;
    private JCheckBox badTokenBox;

    public RemoveTokenWindow(TableWindow tableWindow) {
        super(tableWindow, WINDOW_TITLE, true);
        this.setContentPane(new JScrollPane());
        this.setSize(400, 150);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        ((JScrollPane)this.getContentPane()).getViewport().add(jPanel);
        jPanel.setLayout(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder();
        this.goodTokenNumField = new JTextField(new LimitedDocument(), "0", 5);
        this.goodTokenNumField.setEditable(true);
        this.goodTokenNumField.setBorder(border);
        this.badTokenNumField = new JTextField(new LimitedDocument(), "0", 5);
        this.badTokenNumField.setEditable(true);
        this.badTokenNumField.setBorder(border);
        JLabel jLabel = new JLabel("Good Token Count is strictly less than ");
        JLabel jLabel2 = new JLabel("Bad Token Count is strictly less than ");
        jLabel.setForeground(Color.black);
        jLabel2.setForeground(Color.black);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JLabel("Remove if:"), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 3.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.goodTokenNumField, gridBagConstraints);
        this.goodTokenBox = new JCheckBox();
        this.goodTokenBox.setSelected(true);
        this.goodTokenBox.setEnabled(true);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.goodTokenBox, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel("AND"), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.badTokenNumField, gridBagConstraints);
        this.badTokenBox = new JCheckBox();
        this.badTokenBox.setSelected(true);
        this.badTokenBox.setEnabled(true);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.badTokenBox, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("   OK   ");
        final TrainingData trainingData = tableWindow.getTableWindowTrainer();
        final TableWindow tableWindow2 = tableWindow;
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = -1;
                int n2 = -1;
                if (RemoveTokenWindow.this.goodTokenBox.isSelected()) {
                    n = Integer.parseInt(RemoveTokenWindow.this.goodTokenNumField.getText());
                }
                if (RemoveTokenWindow.this.badTokenBox.isSelected()) {
                    n2 = Integer.parseInt(RemoveTokenWindow.this.badTokenNumField.getText());
                }
                trainingData.removeTokens(n, n2);
                tableWindow2.setNewTrainingData(trainingData);
                RemoveTokenWindow.this.getRemoveTokenWindow().hide();
                RemoveTokenWindow.this.getRemoveTokenWindow().dispose();
            }
        });
        JButton jButton2 = new JButton("   Cancel   ");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoveTokenWindow.this.getRemoveTokenWindow().hide();
                RemoveTokenWindow.this.getRemoveTokenWindow().dispose();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(new JLabel("   "));
        jPanel2.add(jButton2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RemoveTokenWindow.this.getRemoveTokenWindow().hide();
                RemoveTokenWindow.this.getRemoveTokenWindow().dispose();
            }
        });
    }

    private RemoveTokenWindow getRemoveTokenWindow() {
        return this;
    }

    private class LimitedDocument
    extends DefaultStyledDocument {
        private LimitedDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            try {
                Integer.parseInt(string);
                super.insertString(n, string, attributeSet);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

