var g_nameRDF;

var g_RDF = '@mozilla.org/rdf/rdf-service;1';
g_RDF = Components.classes[g_RDF].getService();
g_RDF = g_RDF.QueryInterface(Components.interfaces.nsIRDFService);

function onInit()
{
    g_nameRDF = g_RDF.GetResource("http://www.3dbuzz.com/rdf#name");
    onModChange(-1);
}

/*
    getOption() and setOption(sel) are required to get around the reverse selection bug in Firefox.
*/
function getOption()
{
    var TOTAL = 4;
    
    for(var i = 0; i < TOTAL; i++)
        if(document.getElementById("radio"+i).selected)
            return i;
            
    return -1;
}

function setOption(sel)
{
    var rg = document.getElementById("choice-radiogroup");
    
    rg.selectedItem = document.getElementById("radio"+sel);
}

function onModChange(nMenuChanged)
{
    var dsource = g_RDF.GetDataSource("rdf:local-store");
    var mod1List = document.getElementById("mod1-list");
    var mod2List = document.getElementById("mod2-list");
    var btnList = document.getElementById("btn-list");
    var btnRDF;
    var res;
    var nChoice = 0;
    var selectedBtn = btnList.selectedIndex;
    
    if(btnList.selectedIndex != 0)
        selectedBtn++;
    
    // The first list must be set first!
    if(mod2List.selectedIndex > 0 && mod1List.selectedIndex == 0)
    {
        opener.opener.MsgBox(document.getElementById("stringRes").getString("alertFirstModifierSetFirst"));
        mod1List.selectedIndex = mod2List.selectedIndex;
        mod2List.selectedIndex = 0;
    }
    
    if(mod1List.selectedIndex == mod2List.selectedIndex)
    {
        mod2List.selectedIndex = 0;
    }
    
    /*
        Set default configurations:
        
            All Mouse Buttons = load in current window
            Shift + All Mouse Buttons = load in background
            Shift + Ctrl + All Mouse Buttons = load in foreground
    */
    if(mod1List.selectedIndex == 1) // Shift
    {
        if(mod2List.selectedIndex == 2) // Ctrl
            nChoice = 2;
        else
            nChoice = 3;
    } // Check for reverse
    else if(mod2List.selectedIndex == 1) // Shift
    {
        if(mod1List.selectedIndex == 2) // Ctrl
            nChoice = 2;
        else
            nChoice = 3;
    }
    else if(mod1List.selectedIndex == 0 && mod2List.selectedIndex == 0)
        nChoice = 1;
    
    /*
        A sample stored setting would be:
        
        http://www.3dbuzz.com/settings/mouse/button012
        
        The first number immediately following button is for the mouse button:
            0 - Left
            2 - Middle
            3 - Right
            
        The second is the first modifier and the third is the second modifier:
            0 - No modifier
            1 - Shift
            2 - Ctrl
            
        These numbers correspond directly with those in the menulists.
    */
    btnRDF = g_RDF.GetResource("http://www.3dbuzz.com/settings/mouse/button"+ 
                                    selectedBtn +
                                    mod1List.selectedIndex + 
                                    mod2List.selectedIndex);

    res = dsource.GetTarget(btnRDF, g_nameRDF, true);
    if(res)
        nChoice = parseInt(res.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
    else if(mod2List.selectedIndex != 0)// Take care of a case like "Shift + Ctrl" and "Ctrl + Shift", but also avoid 
                                        // unnecessary checks when there's no second modifier
    {
            btnRDF = g_RDF.GetResource("http://www.3dbuzz.com/settings/mouse/button"+ 
                                            selectedBtn + 
                                            mod2List.selectedIndex +
                                            mod1List.selectedIndex);
        
            res = dsource.GetTarget(btnRDF, g_nameRDF, true);
            if(res)
                nChoice = parseInt(res.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
    }

    if(nChoice >=0 && nChoice <= 3)
    {
        setOption(nChoice);
    }

    return true;
}

function save()
{
    var dsource = g_RDF.GetDataSource("rdf:local-store");
    var mod1List = document.getElementById("mod1-list");
    var mod2List = document.getElementById("mod2-list");
    var btnList = document.getElementById("btn-list");
    var btnRDF;
    var temp;
    var selectedBtn = btnList.selectedIndex;
    
    if(btnList.selectedIndex != 0)
        selectedBtn++;
    
    btnRDF = g_RDF.GetResource("http://www.3dbuzz.com/settings/mouse/button"+ 
                                    selectedBtn + 
                                    mod1List.selectedIndex +
                                    mod2List.selectedIndex);

    temp = dsource.GetTarget(btnRDF, g_nameRDF, true);
    if(temp)
    {
        temp = temp.QueryInterface(Components.interfaces.nsIRDFLiteral);
        dsource.Unassert(btnRDF, g_nameRDF, temp, true);
    }
    temp = g_RDF.GetLiteral(getOption());
    dsource.Assert(btnRDF, g_nameRDF, temp, true);
}

function onOK()
{
    save();
    return true;
}