#!/bin/bash
# $1: PHP script
# Be sure to review the value of PHPEXE and SESSDIR below before usage.
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.
#
# Copyright © 2008 Yves Gablin
# Version 1.0 / 2008-11-29

PHPEXE="/opt/php5/bin/php"
SESSDIR="$(cd "$(dirname "$0")/../php_sessions" &>/dev/null; pwd)"
if [ -n "$CONTENT_LENGTH" ]; then
  read -r -n $CONTENT_LENGTH postReq
fi

$PHPEXE -r '
  function ygphpcli_debug($str) {
    if (defined("YGPHPCLI_DEBUG")) {
      echo("<pre>\n".htmlentities($str)."\n</pre>");
    }
  }
  function ygphpcli_header($string, $replace = null, $http_response_code = null, $action = null) {
    static $headers = null;
    if ($headers === null) $headers = array();
    if ($action === "list") return array_keys($headers);
//TODO: MANAGE HTTP_RESPONSE_CODE
    $string = trim($string);
    $name = explode(":", $string);
    $name = strtolower($name[0]);
    if ($replace) foreach (array_keys($headers, $name) as $key) unset($headers[$key]);
    $headers[$string] = $name;
//ygphpcli_debug("ygphpcli_header({$string}, {$replace}, {$http_response_code}, {$action}): \$headers[{$string}]=\"{$name}\"");
  }
  function ygphpcli_headers_list() {
//ygphpcli_debug("ygphpcli_headers_list():\n".ygphpcli_header(null, null, null, "list"));
    return ygphpcli_header(null, null, null, "list");
  }
  function ygphpcli_headers_sent($file = null, $line = null) {
//ygphpcli_debug("ygphpcli_headers_sent(): FALSE");
    return FALSE;
  }
  function ygphpcli_setcookie($name, $value = "", $expire = 0, $path = null, $domain = null, $secure = FALSE, $httponly = FALSE) {
    ygphpcli_setrawcookie($name, rawurlencode($value), $expire, $path, $domain, $secure, $httponly);
  }
  function ygphpcli_setrawcookie($name, $value = "", $expire = 0, $path = null, $domain = null, $secure = FALSE, $httponly = FALSE) {
//TODO: DISALLOW FORBIDDEN CHARACTERS
    $cookie = "Set-cookie: {$name}={$value}";
    if ($expire !== 0) $cookie .= "; Expires=".gmdate("r", $expire);
    if ($path !== null) $cookie .= "; Path={$path}";
    if ($domain !== null) $cookie .= "; Domain={$domain}";
    if ($secure) $cookie .= "; Secure";
    if ($httponly) $cookie .= "; HttpOnly";
    ygphpcli_header($cookie);
  }
  function ygphpcli_get_included_files() {
    return ygphpcli_IncludeOrRequire(null, null, 1);
  }
  function ygphpcli_get_required_files() {
    return ygphpcli_IncludeOrRequire(null, null, 1);
  }
  function ygphpcli_IncludesPathStack($action, $pushPath = null) {
    static $stack = null;
    if ($stack === null) $stack = array(getcwd());
    if ($action == "push") {
      $stack[] = $pushPath;
      $incPath = explode(PATH_SEPARATOR, get_include_path());
      $incPath[] = $pushPath;
      set_include_path(implode(PATH_SEPARATOR, $incPath));
    } elseif ($action == "pull") {
      $pullPath = array_pop($stack);
      $incPath = explode(PATH_SEPARATOR, get_include_path());
      $pullKeys = array_keys($incPath, $pullPath);
      if (count($pullKeys) > 0) unset($incPath[end($pullKeys)]);
      set_include_path(implode(PATH_SEPARATOR, $incPath));
    }
//ygphpcli_debug("ygphpcli_IncludesPathStack({$action}, {$pushPath}):\n".get_include_path());
  }
  function ygphpcli_IncludePathResolve($path) {
    $realP = $path;
    if (strlen($path) == 0) $realP = "";
    elseif (file_exists($path)) $realP = realpath($path);
    elseif ($path[0] == DIRECTORY_SEPARATOR) $realP = $path;
    else foreach (explode(PATH_SEPARATOR, get_include_path()) as $incP)
      if (file_exists($incP.DIRECTORY_SEPARATOR.$path)) $realP = realpath($incP.DIRECTORY_SEPARATOR.$path);
//ygphpcli_debug("ygphpcli_IncludePathResolve(".print_r(array("path" => $path, "CWD" => getcwd(), "include.path" => get_include_path(), "path.sep" => PATH_SEPARATOR, "dir.sep" => DIRECTORY_SEPARATOR), true)."):\n {$realP}\n");
    return $realP;
  }
  function cb_ygphpcli_IncludeOrRequire($matches) {
    $r = "\$__include__or__require__ = ygphpcli_IncludePathResolve({$matches[5]});\n";
    $r .= "if (!file_exists(\$__include__or__require__))\n";
    $r .= "  ".$matches[2].$matches[3]."(\$__include__or__require__);\nelse {\n";
    $r .= "  \$__include__or__require__content__ = ".$matches[2]."ygphpcli_IncludeOrRequire(\$__include__or__require__, ".($matches[4] == "_once" ? 1 : 0).");\n";
    $r .= "  ygphpcli_IncludesPathStack(\"push\", dirname(\$__include__or__require__));\n";
    $r .= "  {$matches[1]}eval(\$__include__or__require__content__);\n";
    $r .= "  ygphpcli_IncludesPathStack(\"pull\");\n}";
//ygphpcli_debug("cb_ygphpcli_IncludeOrRequire(".print_r($matches, true)."):\n{$r}");
    return $r;
  }
  function ygphpcli_IncludeOrRequire($file, $once, $justGetList = 0) {
    static $included = null;
    if ($included === null) $included = array();
    if ($justGetList === 1) return array_keys($included);
    if ($once == 1 && array_key_exists($file, $included)) $content = "<"."?php\n//ALREADY INCLUDED"; else {
      $included[$file] = null;
      $content = str_replace(
        "__DI"."R__", "\"".@dirname($file)."\"",
        str_replace(
          "__FI"."LE__", "\"".$file."\"",
          preg_replace(
            "/(^|<\?php|[^.>\w])(header|headers_list|headers_sent|setcookie|setrawcookie|get_included_files|get_required_files)(\s*\()/", "\\1ygphpcli_\\2\\3",
            preg_replace_callback(
              "/(?:^|<\?php)[^\S\\n\\r]*(\S.*=[^\S\\n\\r]*)?(@[^\S\\n\\r]*)?(include|require)(_once)?[^\S\\n\\r]*\(?[^\S\\n\\r]*(.*[^\s)])[^\S\\n\\r]*\)?[^\S\\n\\r]*;[^\S\\n\\r]*(?:\\r?\$|\?".">)/mS",
              "cb_ygphpcli_IncludeOrRequire",
              file_get_contents($file)))));
    }
//ygphpcli_debug("ygphpcli_IncludeOrRequire({$file}, {$once}):\n?".">{$content}");
    return "?".">".$content;
  }
  function ygphpcli_sendPHP($content) {
    $page = "";
    $headers = ygphpcli_headers_list();
    foreach ($headers as &$header) $page .= $header."\n";
    if (! preg_match("/^Content-Type: /mi", $page)) $page .= "Content-Type: text/html\n";
    $page .= "\n".$content;
    return $page;
  }
//  function ygphpcli_putMagicQuotes($param) {
//    return is_array($param) ? array_map("ygphpcli_putMagicQuotes", $param) : addslashes($param);
//  }
  ob_start("ygphpcli_sendPHP");
  error_reporting(E_ALL ^ E_NOTICE);
  $args = $_SERVER["argv"];
  session_save_path($args[5]);
  parse_str($args[2], $_GET);
  parse_str($args[3], $_POST);
  parse_str($args[4], $_COOKIE);
  $req = $args[2].(strlen($args[2]) > 0 ? "&" : "").$args[3].(strlen($args[2].$args[3]) > 0 ? "&" : "").$args[4];
  parse_str($req, $_REQUEST);
//  if (get_magic_quotes_gpc()) {
//    $_GET = ygphpcli_putMagicQuotes($_GET);
//    $_POST = ygphpcli_putMagicQuotes($_POST);
//    $_COOKIE = ygphpcli_putMagicQuotes($_COOKIE);
//    $_REQUEST = ygphpcli_putMagicQuotes($_REQUEST);
//  }
  if (array_key_exists("DEBUG", $_REQUEST)) define("YGPHPCLI_DEBUG", null);
  chdir(dirname($args[1]));
//ygphpcli_debug(print_r(array("GET" => $_GET, "POST" => $_POST, "COOKIE" => $_COOKIE, "REQUEST" => $_REQUEST), true));
  eval(ygphpcli_IncludeOrRequire($args[1], 0));
' -- "$1" "$QUERY_STRING" "$postReq" "$HTTP_COOKIE" "$SESSDIR" 2>&1
