#  Copyright (C) 2003 Ingo K"ohne
#  
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

. ../include/common

cmd=update-rc.d

optcomplete  $cmd n
optcomplete  $cmd f
optcomplete -C "find /etc/init.d -type f -name [a-z]\\* ! \\( -name \\*.dpkg\\* -o -name rc\\* \\) -printf '%f\\n' #"  $cmd NONOPT1
optcomplete -m array -V nonopts -C "
if test "\$XPC_NONOPT_NO" = 2; then
	echo -e 'remove\ndefaults\nstart\nstop'
	return
fi
case "\${XPC_nonopts[0]}" in
remove)
	;;
defaults)
	if test "\$XPC_NONOPT_NO" -lt 6; then
		echo '$xpc_digit_W' | tr ' ' '\\n'
	fi
	;;
start|stop)
	declare -i i=0
	declare -i dot=-1
	while test \"\${XPC_nonopts[\$i]}\"; do
		if test \"\${XPC_nonopts[\$i]}\" = .; then
			dot=\$i
		fi
		i=\$(( \$i+1 ))
	done
	i=\$(( \$XPC_NONOPT_NO - \$dot - 2 ))
	case \"\$i\" in
	0)
		echo .
		;;
	1)
		echo -e 'start\nstop'
		;;
	2)
		echo \"$xpc_digit_W\" | tr ' ' '\\n'
		;;
	*)
		echo \"$xpc_digit_W\" S| tr ' ' '\\n'
		;;
	esac
	;;
esac; # "  $cmd NONOPT

optcomplete -m short,getoptparse  $cmd

complete -F xpcompfunc  $cmd

unset cmd ${!xpc_*}
