#ifndef XML_UTF8_H
#define XML_UTF8_H

#ifdef TARGET_FREEBSD
#include <sys/types.h>
#else
#include <stdint.h>
#endif
#include <wchar.h>
#include "adt_id.h"

typedef struct _DAttr DAttr;
struct _DAttr {
    wchar_t* name;
	int nlen;
    wchar_t* value;
	int vlen;
    DAttr* next;
};


typedef struct _DTag DTag;
struct _DTag {
	int type;
	unsigned sid;
	wchar_t *name;
	int nlen;
	wchar_t *value;
	int vlen;
	DAttr* attributes;
	uint32_t pos;
	uint32_t len;

	void *udata;
	atd_id_t udata_type;
	
	DTag *parent;
	DTag *body;
	DTag *next;

	wchar_t *source_xml;
};

typedef enum _DTagType {
    DT_Tag,
    DT_Value,
    DT_Attribute,
	DT_Cdata
} DTagType;


#define S_DEEP (1 << 0)
#define S_DOWN (1 << 1)
#define S_UP   (1 << 2)
#define S_ALL  (S_DEEP | S_DOWN | S_UP)
#define S_SKIP (1 << 3)

#define XML_SAVE_SPC_BODY  (0x1 << 0)

typedef struct _pse_param_t pse_param_t;
struct _pse_param_t {
  wchar_t *xml;
  unsigned long xml_len;
  unsigned long *wc_mb_addr;
  unsigned flags;
  wchar_t *seek_tag;
  wchar_t *stop_tag;
  int stop_parsing;
  int found;
};

DTag* fseek_tag(char *path, wchar_t *seek_tag, wchar_t *stop_tag, unsigned flags);
DTag* seek_tag(wchar_t *wcs_xml, wchar_t *seek_tag, wchar_t *stop_tag, unsigned flags);
DTag* dexml(wchar_t* wcs_xml, unsigned flags);

DTag* tag_seek(DTag *tag_vroot, DTag *tag_root, wchar_t *tag_name, unsigned flags);
DTag* _tag_seek(DTag* tag_root, wchar_t *tag_name, unsigned flags);
DTag* tag_rnext(DTag *tag_vroot, DTag *tag_root, unsigned flags);
int is_tag_name(DTag *tag, wchar_t *str);
void tag_free(DTag* tag);

#endif
