/*
    Copyright (C) 2012 Oleksiy Chernyavskyy

    This file is part of XDClient.

    XDClient is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    XDClient is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XDClient.  If not, see <http://www.gnu.org/licenses/>.
*/

#define _GNU_SOURCE

#include <stdio.h>
#include <wchar.h>
#include <wctype.h>
#include <stdlib.h>
#include <tre/tre.h>
#include "common.h"
#include "aprint.h"
#include "xdxf.h"
#include "xml_utf8.h"
#include "index.h"
#include "file.h"
#include "xdc.h"

wchar_t apr_sbuf[APR_BUFSZ];

void print_dict_descr(xdc_conf_t *xdc_conf, fstat_lt *dict)
{
  wchar_t *name;
  char *lang_from, *lang_to;

  if (!xdc_conf || !dict)
	return;

  if (get_full_name(xdc_conf, dict, &name)) {
	print_color_esc(xdc_conf, ESC_BWHITE);
	fwprintf(stdout, L"DICT: %S\n", name);
	reset_color(xdc_conf);
	free(name);
  }

  if (get_lang(xdc_conf, dict, &lang_from, &lang_to)) {
	print_color_esc(xdc_conf, ESC_BWHITE);
	fwprintf(stdout, L"LANG: %s-%s\n", lang_from ? lang_from : "", lang_to ? lang_to : "");
	reset_color(xdc_conf);
	if (lang_from)
	  free(lang_from);
	if (lang_to)
	  free(lang_to);
  }
}

void print_tag_article(xdc_conf_t *xdc_conf, DTag* tag, unsigned key_mask, regmatch_t *pmatch)
{
  int vlen;
  DTag *_tag;
  xdtag_id_t prev_tag = XDTAG_NULL;
  int i, j;
  int pmi;
  int in_match;
  regmatch_t *pm;
  int na_num;
  int pos;

  pos = 0;
  pmi = 0;
  na_num = 0;
  _tag = tag;
  while (_tag) {
	if (_tag->type == DT_Tag) {
	  if (! is_tag_name(_tag, L"abr") && prev_tag == XDTAG_ABR)
		fwprintf(stdout, L"\n");
	  else if (prev_tag == XDTAG_DTRN)
		fwprintf(stdout, L"\n\n");
	  else if (prev_tag == XDTAG_EX)
		fwprintf(stdout, L"\n");

	  if (is_tag_name(_tag, L"ar")) {
		print_tag_article(xdc_conf, _tag->body, key_mask, pmatch);
		prev_tag = XDTAG_AR;
	  } else if (is_tag_name(_tag, L"k")) {
		print_tag_key(xdc_conf, _tag->body, key_mask, pmatch);
		fwprintf(stdout, L"\n");
		prev_tag = XDTAG_K;
	  } else if (is_tag_name(_tag, L"kref") ||
		  is_tag_name(_tag, L"rref") ||
		  is_tag_name(_tag, L"iref")) {
		print_color_esc(xdc_conf, ESC_NGREEN);
		print_tag_article(xdc_conf, _tag->body, key_mask, pmatch);
		reset_color(xdc_conf);
		prev_tag = XDTAG_UNDEF;
	  } else if (is_tag_name(_tag, L"pos")) {
		print_color_esc(xdc_conf, ESC_NMAGENTA);
		print_tag_article(xdc_conf, _tag->body, key_mask, pmatch);
		reset_color(xdc_conf);
		prev_tag = XDTAG_POS;
	  } else if (is_tag_name(_tag, L"tr")) {
		print_tag_tr(xdc_conf, _tag->body);
		fwprintf(stdout, L"\n");
		prev_tag = XDTAG_TR;
	  } else if (is_tag_name(_tag, L"abr")) {
		print_tag_abr(xdc_conf, _tag->body);
		reset_color(xdc_conf);
		prev_tag = XDTAG_ABR;
	  } else if (is_tag_name(_tag, L"dtrn")) {
		print_tag_article(xdc_conf, _tag->body, key_mask, pmatch);
		prev_tag = XDTAG_DTRN;
	  } else if (is_tag_name(_tag, L"ex")) {
/*		print_color_esc(xdc_conf, ESC_NGREEN); */
		print_tag_article(xdc_conf, _tag->body, key_mask, pmatch);
		reset_color(xdc_conf);
		prev_tag = XDTAG_EX;
	/*  } else if (is_tag_name(_tag, L"i") ||
		  is_tag_name(_tag, L"c") ||
		  is_tag_name(_tag, L"co") ||
		  is_tag_name(_tag, L"sup") ||
		  is_tag_name(_tag, L"sub") ||
		  is_tag_name(_tag, L"b") ||
		  is_tag_name(_tag, L"tt") ||
		  is_tag_name(_tag, L"big") ||
		  is_tag_name(_tag, L"small") ||
		  is_tag_name(_tag, L"blockquote")) {
		  */
	  } else {
		print_tag_article(xdc_conf, _tag->body, key_mask, pmatch);
		prev_tag = XDTAG_UNDEF;
	  }
	} else if (_tag->type == DT_Value) {
	  vlen =  APR_BUFSZ > _tag->vlen ? _tag->vlen : APR_BUFSZ-1;
	  wcsncpy(apr_sbuf, _tag->value, vlen);
	  apr_sbuf[vlen] = L'\0';
	  convert_xml_escape(apr_sbuf);
	  if (prev_tag == XDTAG_K) {
		j = i = 0;
		while (iswspace(apr_sbuf[i]))
		  i++;
		while (apr_sbuf[i] != L'\0')
		  apr_sbuf[j++] = apr_sbuf[i++];
		apr_sbuf[j] = L'\0';
	  }
	  if (_tag->udata && _tag->udata_type == Tregmatch) {
		in_match = 0;
		i=0;
		pm = (regmatch_t*) _tag->udata;
		while(apr_sbuf[i] != L'\0') {
		  if (!iswalnum(apr_sbuf[i]) && !iswspace(apr_sbuf[i]))
			na_num++;
		  if (pm[pmi].rm_so != -1 && pos >= (pm[pmi].rm_so + na_num) && pos < (pm[pmi].rm_eo + na_num)  && !in_match) {
			in_match = 1;
			print_color_esc(xdc_conf, ESC_BRED);
		  }
		  if (pm[pmi].rm_eo != -1 && pos >= (pm[pmi].rm_eo + na_num) && in_match) {
			in_match = 0;
			reset_color(xdc_conf);
			if (pmi < RE_NMATCH-1)
			  pmi++;
		  }

		  fputwc(apr_sbuf[i], stdout);
		  i++;
		  pos++;
		}
		reset_color(xdc_conf);
	  } else {
		fwprintf(stdout, L"%S", apr_sbuf);
	  }
	  prev_tag = XDTAG_VALUE;
	}
	_tag = _tag->next; 
/*	_tag = tag_rnext(_tag->parent, _tag, S_ALL); */
  }
}


void print_tag_abr(xdc_conf_t *xdc_conf, DTag *tag)
{
  int vlen;
  DTag *_tag;
  int pmi;
  int in_match;
  regmatch_t *pm;
  int i;

  _tag = tag;
  while (_tag) {
	print_color_esc(xdc_conf, ESC_NMAGENTA);
	if (_tag->type == DT_Tag) {
	  if (is_tag_name(_tag, L"c")) {
		print_tag_abr(xdc_conf, _tag->body);
	  } else if (is_tag_name(_tag, L"i")) {
		print_tag_abr(xdc_conf, _tag->body);
	  } else if (is_tag_name(_tag, L"co")) {
		print_tag_abr(xdc_conf, _tag->body);
	  } else {
		print_tag_abr(xdc_conf, _tag->body);
	  }
	} else if (_tag->type == DT_Value) {
	  vlen =  APR_BUFSZ > _tag->vlen ? _tag->vlen : APR_BUFSZ-1;
	  wcsncpy(apr_sbuf, _tag->value, vlen);
	  apr_sbuf[vlen] = L'\0';
	  convert_xml_escape(apr_sbuf);

	  if (_tag->udata && _tag->udata_type == Tregmatch) {
		pmi = 0;
		in_match = 0;
		i=0;
		pm = (regmatch_t*) _tag->udata;
		while(apr_sbuf[i] != L'\0') {
		  if (pm[pmi].rm_so != -1 && i >= pm[pmi].rm_so && i < pm[pmi].rm_eo && !in_match) {
			in_match = 1;
			print_color_esc(xdc_conf, ESC_BRED);
		  }
		  if (pm[pmi].rm_eo != -1 && i >= pm[pmi].rm_eo && in_match) {
			in_match = 0;
			reset_color(xdc_conf);
			if (pmi < RE_NMATCH-1)
			  pmi++;
		  }

		  fputwc(apr_sbuf[i], stdout);
		  i++;
		}
		reset_color(xdc_conf);
	  } else {
		fwprintf(stdout, L"%S", apr_sbuf);
	  }
	}
	_tag = _tag->next;
  }
  reset_color(xdc_conf);
}

void print_tag_key(xdc_conf_t *xdc_conf, DTag *tag, unsigned key_mask, regmatch_t *pmatch)
{
  int vlen;
  DTag *_tag;
  xdtag_id_t prev_tag = XDTAG_NULL;
  int i;
  int pmi;
  regmatch_t *pm;
  int in_match;
  int na_num;
  int skip_rnext = 0;
  int pos;
  int opt_num;

  opt_num = 0;
  pos = 0;
  pmi = 0;
  na_num = 0;
  _tag = tag;
  while (_tag) {
	print_color_esc(xdc_conf, ESC_BYELLOW);
	if (_tag->type == DT_Tag) {
	  if (is_tag_name(_tag, L"opt")) {
		print_tag_opt(xdc_conf, _tag->body, opt_num++, key_mask, pmatch, &pmi, &pos, &na_num);
		_tag = _tag->next;
		skip_rnext = 1;
		prev_tag = XDTAG_OPT;
	  } else if (is_tag_name(_tag, L"nu")) {
	/*	print_tag_key(xdc_conf, _tag->body, key_mask, pmatch); */
		prev_tag = XDTAG_NU;
	  } else {
		/*print_tag_key(xdc_conf, _tag->body, key_mask, pmatch); */
		prev_tag = XDTAG_UNDEF;
	  }
	} else if (_tag->type == DT_Value) {
	  if (! (prev_tag == XDTAG_NU && _tag->vlen > 0 && _tag->value[0] == L'[')) {
		vlen =  APR_BUFSZ > _tag->vlen ? _tag->vlen : APR_BUFSZ-1;
		wcsncpy(apr_sbuf, _tag->value, vlen);
		apr_sbuf[vlen] = L'\0';
		convert_xml_escape(apr_sbuf);
		if (pmatch) {
		  i=0;
		  in_match = 0;
		  pm = pmatch;
		  while(apr_sbuf[i] != L'\0') {
			if (!iswalnum(apr_sbuf[i]) && !iswspace(apr_sbuf[i]))
			  na_num++;
			if (pm[pmi].rm_so != -1 && pos >= (pm[pmi].rm_so + na_num) && pos < (pm[pmi].rm_eo + na_num)  && !in_match) {
			  in_match = 1;
			  print_color_esc(xdc_conf, ESC_BRED);
			}
			if (pm[pmi].rm_eo != -1 && pos >= (pm[pmi].rm_eo + na_num) && in_match) {
			  in_match = 0;
			  print_color_esc(xdc_conf, ESC_BYELLOW);
			  if (pmi < RE_NMATCH-1)
				pmi++;
			}

			fputwc(apr_sbuf[i], stdout);
			i++;
			pos++;
		  }
		  reset_color(xdc_conf);
		} else {
		  fwprintf(stdout, L"%S", apr_sbuf);
		}
	  }
	  prev_tag = XDTAG_VALUE;
	}
	if (!skip_rnext)
	  _tag = tag_rnext(tag->parent, _tag, S_ALL);
	skip_rnext = 0;
  }
  reset_color(xdc_conf);
}

void print_key(xdc_conf_t *xdc_conf, wchar_t *key)
{
  if (!key)
	return;

  print_color_esc(xdc_conf, ESC_BYELLOW);
  fwprintf(stdout, L"%S\n", key);
  reset_color(xdc_conf);
}

void print_tag_opt(xdc_conf_t *xdc_conf, DTag *tag, int opt_num, unsigned key_mask, regmatch_t *pmatch, int *pmi_ret, int *pos_ret, int *na_num_ret)
{
  int vlen;
  DTag *_tag;
  int i;
  int add_space;
  int opened_par;
  unsigned opt_mask;
  int active_opt = 0;
  int pmi;
  int pos;
  int na_num;
  int in_match;
  regmatch_t *pm;

  if (pmi_ret)
	pmi = *pmi_ret;
  else
	pmi = 0;

  if (pos_ret)
	pos = *pos_ret;
  else
	pos = 0;

  if (na_num_ret)
	na_num = *na_num_ret;
  else
	na_num = 0;

  opt_mask = (1 << opt_num);
  if (opt_mask & key_mask)
	active_opt = 1;

  print_color_esc(xdc_conf, ESC_BYELLOW);

  add_space = 0;
  opened_par = 0;
  _tag = tag;
  while (_tag) {
	if (_tag->type == DT_Value) {
	  vlen =  APR_BUFSZ > _tag->vlen ? _tag->vlen : APR_BUFSZ-1;
	  wcsncpy(apr_sbuf, _tag->value, vlen);
	  apr_sbuf[vlen] = L'\0';
	  convert_xml_escape(apr_sbuf);

	  if (add_space) {
		fputwc(L' ', stdout);
		add_space=0;
	  }
	  i = 0;
	  in_match = 0;
	  pm = pmatch;
	  while(apr_sbuf[i] != L'\0') {
		if (iswspace(apr_sbuf[i]) && apr_sbuf[i+1] == L'\0') {
		  add_space = 1;
		} else {
		  if (!iswspace(apr_sbuf[i]) && !opened_par) {
			fputwc(L'(', stdout);
			opened_par = 1;
		  }

		  if (active_opt && pm) {
			if (!iswalnum(apr_sbuf[i]) && !iswspace(apr_sbuf[i]))
			  na_num++;
			if (pm[pmi].rm_so != -1 && pos >= (pm[pmi].rm_so + na_num) && pos < (pm[pmi].rm_eo + na_num)  && !in_match) {
			  in_match = 1;
			  print_color_esc(xdc_conf, ESC_BRED);
			}
			if (pm[pmi].rm_eo != -1 && pos >= (pm[pmi].rm_eo + na_num) && in_match) {
			  in_match = 0;
			  reset_color(xdc_conf);
			  if (pmi < RE_NMATCH-1)
				pmi++;
			}
		  }

		  fputwc(apr_sbuf[i], stdout);

		  if (iswspace(apr_sbuf[i]) && !opened_par) {
			print_color_esc(xdc_conf, ESC_BYELLOW);
			fputwc(L'(', stdout);
			opened_par = 1;
			if (in_match)
			  print_color_esc(xdc_conf, ESC_BRED);
		  }
		}

		i++;
		if (active_opt)
		  pos++;
	  }
	  print_color_esc(xdc_conf, ESC_BYELLOW);
	}
	_tag = tag_rnext(tag->parent, _tag, S_ALL);
  }


  fputwc(L')', stdout);
  if (add_space)
	fputwc(L' ', stdout);

  if (pmi_ret)
	*pmi_ret = pmi;
  if (pos_ret)
	*pos_ret = pos;
  if (na_num_ret)
	*na_num_ret = na_num;
}

void print_tag_tr(xdc_conf_t *xdc_conf, DTag *tag)
{
  int vlen;
  DTag *_tag;

  _tag = tag;
  print_color_esc(xdc_conf, ESC_NCYAN);
  while (_tag) {
	if (_tag->type == DT_Tag) {
	  print_tag_tr(xdc_conf, _tag->body);
	} else if (_tag->type == DT_Value) {
	  vlen =  APR_BUFSZ > _tag->vlen ? _tag->vlen : APR_BUFSZ-1;
	  wcsncpy(apr_sbuf, _tag->value, vlen);
	  apr_sbuf[vlen] = L'\0';
	  convert_xml_escape(apr_sbuf);
	  fwprintf(stdout, L"[%S]", apr_sbuf);
	}
	_tag = _tag->next;
  }
  reset_color(xdc_conf);
}

void print_xml_body(wchar_t *wcs)
{
  unsigned vlen, len;

  if (!wcs)
	return;

  len = wcslen(wcs);
  vlen =  APR_BUFSZ > len ? len : APR_BUFSZ-1;
  wcscpy(apr_sbuf, wcs);
  apr_sbuf[vlen] = L'\0';
  convert_xml_escape(apr_sbuf);
  fwprintf(stdout, L"%S", apr_sbuf);
}

void print_xml_body_double_conv(wchar_t *wcs)
{
  unsigned vlen, len;

  if (!wcs)
	return;

  len = wcslen(wcs);
  vlen =  APR_BUFSZ > len ? len : APR_BUFSZ-1;
  wcscpy(apr_sbuf, wcs);
  apr_sbuf[vlen] = L'\0';
  convert_xml_escape(apr_sbuf);
  convert_xml_escape(apr_sbuf);
  fwprintf(stdout, L"%S", apr_sbuf);
}

void print_color_esc(xdc_conf_t *xdc_conf, char *esc_str)
{
  if (xdc_conf->use_colors)
	fwprintf(stdout, L"%s", esc_str);
}

void reset_color(xdc_conf_t *xdc_conf)
{
  if (xdc_conf->use_colors)
	fwprintf(stdout, L"%s", ESC_RESET);
}

