#ifndef UTF8_H
#define UTF8_H

#include <wchar.h>

typedef struct _mbs_ll_t mbs_ll_t;
typedef struct _wcs_ll_t wcs_ll_t;

struct _mbs_ll_t {
  char *mbs;
  mbs_ll_t *next;
};

struct _wcs_ll_t {
  wchar_t *wcs;
  wcs_ll_t *next;
};


int wc_mb_len(wchar_t wc);
size_t wcslen_fast(const wchar_t *s);
int wcsncmp_fast(const wchar_t *s1, const wchar_t *s2, size_t n);
wchar_t* wcsstr_fast(wchar_t *s1, const wchar_t *s2);
size_t mbs_nchars(const char *s);
wchar_t* mbs2wcs(char *mbs);
char* wcs2mbs(wchar_t *wcs);
char* mbsdup(char *mbs);
char *tombs(wchar_t *wcs);
wchar_t* towcs(char *mbs);
char* pfmbs(char *format, ...);
wchar_t* pfwcs(wchar_t *format, ...);
wchar_t* wcsndup(wchar_t *wcs, int len);
mbs_ll_t* mbs_split(char *mbs, char sc);
wcs_ll_t* wcs_split(wchar_t *wcs, wchar_t sc);
void mbsl_free(mbs_ll_t *mbsl);
void wcsl_free(wcs_ll_t *wcsl);
void ppad(int shift);
void print_mbsll(mbs_ll_t *mbsl, int shift);
void print_wcsll(wcs_ll_t *wcsl, int shift);
mbs_ll_t* mbsl_create(char *mbs);
char* mbs_pref_crop(char *mbs, char cc);
wchar_t* wcs_pref_crop(wchar_t *wcs, wchar_t cc);
char* mbs_sufx_crop(char *mbs, char cc);
wchar_t* wcs_sufx_crop(wchar_t *wcs, wchar_t cc);

#endif
