#ifndef APRINT_H
#define APRINT_H

#include "xml_utf8.h"
#include "index.h"

#define APR_BUFSZ (BUFSZ * 10)

void print_dict_descr(xdc_conf_t *xdc_conf, fstat_lt *dict);
void print_tag_article(xdc_conf_t *xdc_conf, DTag* tag, unsigned key_mask, regmatch_t *pmatch);
void print_tag_key(xdc_conf_t *xdc_conf, DTag *tag, unsigned key_mask, regmatch_t *pmatch);
void print_tag_tr(xdc_conf_t *xdc_conf, DTag *tag);
void print_tag_opt(xdc_conf_t *xdc_conf, DTag *tag, int opt_num, unsigned key_mask, regmatch_t *pmatch, int *pmi_ret, int *pos_ret, int *na_num_ret);
void print_tag_abr(xdc_conf_t *xdc_conf, DTag *tag);
void print_key(xdc_conf_t *xdc_conf, wchar_t *key);

void print_xml_body(wchar_t *wcs);
void print_xml_body_double_conv(wchar_t *wcs);

#define ESC_RESET      "\033[0m"

#define ESC_NBLACK     "\033[0;30m"
#define ESC_NRED       "\033[0;31m"
#define ESC_NGREEN     "\033[0;32m"
#define ESC_NYELLOW    "\033[0;33m"
#define ESC_NBLUE      "\033[0;34m"
#define ESC_NMAGENTA   "\033[0;35m"
#define ESC_NCYAN      "\033[0;36m"
#define ESC_NWHITE     "\033[0;37m"

#define ESC_BBLACK     "\033[1;30m"
#define ESC_BRED       "\033[1;31m"
#define ESC_BGREEN     "\033[1;32m"
#define ESC_BYELLOW    "\033[1;33m"
#define ESC_BBLUE      "\033[1;34m"
#define ESC_BMAGENTA   "\033[1;35m"
#define ESC_BCYAN      "\033[1;36m"
#define ESC_BWHITE     "\033[1;37m"

#define ESC_UBLACK     "\033[4;30m"
#define ESC_URED       "\033[4;31m"
#define ESC_UGREEN     "\033[4;32m"
#define ESC_UYELLOW    "\033[4;33m"
#define ESC_UBLUE      "\033[4;34m"
#define ESC_UMAGENTA   "\033[4;35m"
#define ESC_UCYAN      "\033[4;36m"
#define ESC_UWHITE     "\033[4;37m"

void print_color_esc(xdc_conf_t *xdc_conf, char *esc_str);
void reset_color(xdc_conf_t *xdc_conf);

#endif
