/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import processing.app.Base;

public class SketchCode {
    private String prettyName;
    private File file;
    private String extension;
    private String program;
    private Document document;
    private UndoManager undo = new UndoManager();
    private int selectionStart;
    private int selectionStop;
    private int scrollPosition;
    private boolean modified;
    private int preprocOffset;

    public SketchCode(File file, String string) {
        this.file = file;
        this.extension = string;
        this.makePrettyName();
        try {
            this.load();
        }
        catch (IOException iOException) {
            System.err.println("Error while loading code " + file.getName());
        }
    }

    protected void makePrettyName() {
        this.prettyName = this.file.getName();
        int n = this.prettyName.indexOf(46);
        this.prettyName = this.prettyName.substring(0, n);
    }

    public File getFile() {
        return this.file;
    }

    protected boolean fileExists() {
        return this.file.exists();
    }

    protected boolean fileReadOnly() {
        return !this.file.canWrite();
    }

    protected boolean deleteFile() {
        return this.file.delete();
    }

    protected boolean renameTo(File file, String string) {
        boolean bl = this.file.renameTo(file);
        if (bl) {
            this.file = file;
            this.extension = string;
            this.makePrettyName();
        }
        return bl;
    }

    protected void copyTo(File file) throws IOException {
        Base.saveFile(this.program, file);
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isExtension(String string) {
        return this.extension.equals(string);
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String string) {
        this.program = string;
    }

    public int getLineCount() {
        return Base.countLines(this.program);
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setPreprocOffset(int n) {
        this.preprocOffset = n;
    }

    public int getPreprocOffset() {
        return this.preprocOffset;
    }

    public void addPreprocOffset(int n) {
        this.preprocOffset += n;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public UndoManager getUndo() {
        return this.undo;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionStop() {
        return this.selectionStop;
    }

    public int getScrollPosition() {
        return this.scrollPosition;
    }

    protected void setState(String string, int n, int n2, int n3) {
        this.program = string;
        this.selectionStart = n;
        this.selectionStop = n2;
        this.scrollPosition = n3;
    }

    public void load() throws IOException {
        this.program = Base.loadFile(this.file);
        if (this.program.indexOf(65533) != -1) {
            System.err.println(this.file.getName() + " contains unrecognized characters.");
            System.err.println("If this code was created with an older version of Processing,");
            System.err.println("you may need to use Tools -> Fix Encoding & Reload to update");
            System.err.println("the sketch to use UTF-8 encoding. If not, you may need to");
            System.err.println("delete the bad characters to get rid of this warning.");
            System.err.println();
        }
        this.setModified(false);
    }

    public void save() throws IOException {
        Base.saveFile(this.program, this.file);
        this.setModified(false);
    }

    public void saveAs(File file) throws IOException {
        Base.saveFile(this.program, file);
    }
}

