###############################################################################
#                 Undernet Channel Service Management Script                  #
###############################################################################
# $Id: UndernetCS.tcl,v 1.6 2003/05/19 18:51:34 Ze Exp $
###############################################################################
# (c) 2001 RICHARD Yann alias Ze <mgm@ifrance.com>                            #
###############################################################################

###############################################################################
# This program is distributed under the GNU General Public Licence            #
# See the LICENCE file for more information.                                  #
###############################################################################

# Verify compatibility with eggdrop version ...
if {(![info exists numversion]) || ($numversion < 1060500) } {
    putlog "*** Can't load UndernetCS*.tcl -- At least Eggdrop v1.6.5 required."
    return 0
}
# Loading configuration.
source scripts/UndernetCS/UndernetCS-Conf.tcl
# Loading inidb.tcl ?
if { $UndernetCS_Must_Load_inidb } {
    if { ![info exists inidb_ver] } {
        source scripts/UndernetCS/inidb.tcl
    }
} else {
    if { ![info exists inidb_ver] } {
        set out "You must turn on the UndernetCS_Must_Load_inidb"
        set out "$out var on UndernetCS-Conf.tcl or loading inidb.tcl" 
        set out "$out before loading UndernetCS.tcl !!!"
        UndernetCS:PutLog "$out" "GLOBAL" 1
        return 0
    }
}

# Current version of the script. !Do not change it!
set UndernetCS_Version "0.8.5"
set UndernetCS_NumVersion "00805"

# Set script's status to Off
set UndernetCS_X(STATUS) 0
# Default checktime to verify auth status to X (in minutes)
set UndernetCS_X(AUTH_CHK_FREQUENCY) "05"

# Set this to the eggdrop password. You can set this value in the party line
# The password can be a sentence... this is the default value for password
# this value will be overwriten by config file's values.
# I recommend to change password value via DCC command and leave this default
# value.
# See .CS in party line...
set UndernetCS_X(PASS) {DEFAULT PASSWORD}

# Prompt before message in eggdrop log
set UndernetCS_Prompt "UndernetCS -->"
# Eggdrop Setting in X database

# Item List
# This is all "index" of the 'UndernetCS_X' array who are saved on
# the config file...
set UndernetCS_GlobalItemList {
    "USERID" "PASS" "STATUS" "AUTH_CHK_FREQUENCY" "MODEX"
}
# All theirs index of the UndernetCS_ChannelSetting's array value
# are saved on config file..
set UndernetCS_ChannelItemList {
    "LEVEL" "STATUS" "AUTOMODE" "SUSPENDED"
    "AUTH_CHK_FREQUENCY_WHEN_SUSP"
}

# Volatile GLOBAL VAR
set UndernetCS_X(NEWPASS) {}
set UndernetCS_X(AUTH_STATUS) 0
###
    # Channel settings
    ###################################
    ## Channel Setting in X database ##
    # Default Level [0..500]
    #   0     = No Access for this channel
    #   1-500 = I have an access for this channel
    set UndernetCS_ChannelSetting(DEFAULT,LEVEL) 0
    # Is the channel is active ? [/0/1]
    #   0 = script disabled for this channel
    #   1 = script enabled for this channel
    set UndernetCS_ChannelSetting(DEFAULT,STATUS) 0
    # Is the access suspended by default  ? [0/1]
    set UndernetCS_ChannelSetting(DEFAULT,SUSPENDED) 0
    # What is the AutoMode by default? [NONE|OP|VOICE]
    set UndernetCS_ChannelSetting(DEFAULT,AUTOMODE) "NONE"
    #################################
    ## Script Setting for Channels ##
    # Default checktime to verify if already suspended (in minutes)
    set UndernetCS_ChannelSetting(DEFAULT,AUTH_CHK_FREQUENCY_WHEN_SUSP) 30


#### DEBUG ####
# Levels can be set from 1 to 6
# Level		Description
#   1		Very quiet, you will only get vital messages, like script crashing
#   2		Quiet, you will see only needed messages, like failed auth and such
#   3		Normal, you will see all usefull messages, like auth succesfull, and such
#   4		coder debug, use to check that a function is working properly, without getting all the debug messages
#   5		Debug, you will almost messages, use carefully
#   6		Deep debug, only usefull when something doesn't work with no reason
#			and only if proc all outputs something
#
#   Note for coders : you should set all debug messages to level 5
#   However you should set debug for the parts you are working on to 4
#   Also, you should try to give an output to almost every proc
#
#   Coder note : 
#   make a little app that kills every line where debug level is higher than a given value
#

set UndernetCS_Debug(AUTH) 2    ;# debug for 'Auth' part.
set UndernetCS_Debug(GLOBAL) 2  ;# debug for global features.
set UndernetCS_Debug(NEED) 2    ;# debug for Need part.
set UndernetCS_Debug(IO) 2      ;# debug for IO part.
set UndernetCS_Debug(TIMER) 2   ;# debug for timers.
set UndernetCS_Debug(NEWS) 2    ;# debug for newschecker.

set UndernetCS_DebugItemList {
    "AUTH" "GLOBAL" "NEED" "IO" "TIMER" "NEWS"
}

proc UndernetCS:GetWordStatus {value} {
    if { $value == 1 } { return "Enabled" }
    return "Disabled"
}

# UndernetCS:DebugLevel
# returns the debug level of 'type'
#         stg if 'type' is unknown
proc UndernetCS:DebugLevel {type} {
	global UndernetCS_Debug
	return $UndernetCS_Debug($type)
}

# UndernetCS:PutLog
#   puts the 'message' in eggdrop log if debug 'type' is set to 'level' or higher
#  return nothing
proc UndernetCS:PutLog {message type level} {
    global UndernetCS_Prompt
    if { [UndernetCS:DebugLevel $type] >= $level } {
	putlog "$UndernetCS_Prompt (${type}/${level}): $message"
    }
}


# UndernetCS:SetModeX 
# Change the usermode +x settings for the eggdrop to 'value'
# [0/1].
proc UndernetCS:SetModeX {value} {
    global UndernetCS_X botnick
    set UndernetCS_X(MODEX) $value
    if { $value == 1 } {
        putserv "MODE $::botnick +x"
    }
}
# UndernetCS:GetWordModeXActive
proc UndernetCS:GetWordModeXActive {} {
    global UndernetCS_X
    if { UndernetCS_X(MODEX) == 1 } {
        return "Yes"
    } else {
        return "No"
    }
}

# UndernetCS:IsModeXActive 
#   Check if eggdrop usermode +x must be set for the eggdrop
#   Return: 1 if usermode +x must be set
#           0 if usermode +x must NOT be set
proc UndernetCS:IsModeXActive {} {
    global UndernetCS_X
    if { UndernetCS_X(MODEX) == 1 } {
        return 1
    } else {
        return 0
    }
}

# UndernetCS:SetAuthStatus 
#   Change the authentication status to 'value' [-1/0/1/Other value]
#       0  : means not curently authenticated
#       1  : means already authenticated
#      -1  : means that the last try return authentication failed...
#     Other: means eggdrop is waiting for a reply from X to
#            a previous auth request. this value is the unix
#            time at the momment where the command was send.
#   Return: Nothing
proc UndernetCS:SetAuthStatus {value} {
    global UndernetCS_X
    set UndernetCS_X(AUTH_STATUS) $value
}

# UndernetCS:IsAuth 
#   Check if eggdrop is authenticated to X.
#   Return: 1 if eggdrop is curently authenticated,
#           0 otherwise.
proc UndernetCS:IsAuth {} {
    global UndernetCS_X
    if { $UndernetCS_X(AUTH_STATUS) == 1 } {
        return 1
    } else { return 0 }
}

# UndernetCS:IsAuthFailed 
#   Check if the last anwser after sending auth command is FAILED.
#   Return: 1 if last try return FAILED.
#           0 otherwise.
proc UndernetCS:IsAuthFailed {} {
    global UndernetCS_X
    if { $UndernetCS_X(AUTH_STATUS) == -1 } {
        return 1
    } else { return 0 }
}

# UndernetCS:IsWaitingForReply 
#   Check if the eggdrop is waiting for a reply to a login request.
#   Return: 0 if eggdrop isn't waiting for a reply to a login request.
#           "the time of the send of the request in unixtime otherwise
proc UndernetCS:IsWaitingForReply {} {
    global UndernetCS_X
    if { $UndernetCS_X(AUTH_STATUS) > 1 } {
        # Verify timeout for last request 
        UndernetCS:Auth:AuthTimeChecker 0 0 0 0 0
        return $UndernetCS_X(AUTH_STATUS)
    } else { return 0 }
}

proc UndernetCS:GetWordAuthStatus {} {
    global UndernetCS_X
    if { $UndernetCS_X(AUTH_STATUS) == -1 } {
        return "Failed."
    } elseif { $UndernetCS_X(AUTH_STATUS) == 0 } {
        return "Not authenticated."
    } elseif { $UndernetCS_X(AUTH_STATUS) == 1 } {
        return "Authenticated."
    } elseif { $UndernetCS_X(AUTH_STATUS) > 1 } {
        return "Waiting for reply from X."
    }
}
# UndernetCS:SetPass
#   Just change the internal value of the password of 
#   the access to X. This proc don't send anything to X.
#   Return: Nothing
proc UndernetCS:SetPass {newpass} {
    global UndernetCS_X
    set UndernetCS_X(PASS) $newpass
}

# UndernetCS:IsValidPass 
#   Verify if the parameter will be accepted if it is sending to X
#   as a newpassword.
#   Return: 1 if it is ok.
#           0 otherwise.
proc UndernetCS:IsValidPass {pass} {
    if { [string length $pass] < 6 } {
        return 0
    } else {
        return 1
    }
}

# UndernetCS:GetPass 
#   Return: The password of the eggdrop witch is use
#           for authenticated eggdrop to X.
proc UndernetCS:GetPass {} {
    global UndernetCS_X
    return $UndernetCS_X(PASS)
}

# UndernetCS:SetUserId 
#   Change the UserId of the eggdrop who is used to auth the
#   eggdrop to UnderNet Channel Service.
#   In theory this proc is launch one time if the owner haven't
#   set this var when he have installed the script ...
#   Return: Nothing
proc UndernetCS:SetUserId {newuserid} {
    global UndernetCS_X
    set UndernetCS_X(USERID) $newuserid
}

# UndernetCS:GetUserId
#   Return: The username witch identify the eggdrop in X's database.
proc UndernetCS:GetUserId {} {
    global UndernetCS_X
    return $UndernetCS_X(USERID)
}

# UndernetCS:SetAutoMode
#   Change the internal AutoMode value for "channel".
#   This proc doesn't send anything to X.
#   Return: Nothing
proc UndernetCS:SetAutoMode {channel value} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    set UndernetCS_ChannelSetting($chan,AUTOMODE) [string toupper $value]
}

# UndernetCS:GetAutoMode
#   Return: The value of AUTOMODE for 'channel'
proc UndernetCS:GetAutoMode {channel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    return $UndernetCS_ChannelSetting($chan,AUTOMODE)
}

# UndernetCS:IsAutoModeOp 
#   Check if AUTOMODE in 'channel' is "OP"
#   Return: 1 if is set to OP,
#           0 otherwise.
proc UndernetCS:IsAutoModeOp {channel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    if { $UndernetCS_ChannelSetting($chan,AUTOMODE) == "OP" } {
        return 1
    } else {
        return 0
    }
}

# UndernetCS:SetNewLevel 
#   Set the internal value of the access level for 'channel'
#   to 'newlevel'. This proc doesn't send anything to X.
#   Return: Nothing
proc UndernetCS:SetNewLevel {channel newlevel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    if { $newlevel == 0 } {
        # We also disabled this channel
        set UndernetCS_ChannelSetting($chan,STATUS) 0
    }
    set UndernetCS_ChannelSetting($chan,LEVEL) $newlevel
}

# UndernetCS:GetLevel 
#   Return: The access level of eggdrop for 'channel'
proc UndernetCS:GetLevel {channel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    return $UndernetCS_ChannelSetting($chan,LEVEL)
}

# UndernetCS:SetSuspended 
#   Set SUSPENDED boolean to "value" for the given channel.
#   Return: Nothing
proc UndernetCS:SetSuspended {channel value} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    set UndernetCS_ChannelSetting($chan,SUSPENDED) $value
}

# UndernetCS:IsSuspended 
#   Check if eggdrop's access is suspended for 'channel'
#   Return: 1 if access is suspended,
#           0 if not.
proc UndernetCS:IsSuspended {channel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    if { $UndernetCS_ChannelSetting($chan,SUSPENDED) == 1 } {
        return 1
    } else {
        return 0
    }
}

# UndernetCS:SetAuthCheckFrequency
#   Set the authentication check frequency to 'value'
#   This value means that each 'value' minuts, the eggdrop check
#   if he is already logged on X. In theory, when the eggdrop check
#   he must be already loggued because the script manage all situation
#   who eggdrop must send an login command to X.
#   Return: Nothing
proc UndernetCS:SetAuthCheckFrequency {value} {
    global UndernetCS_X
    # Unbind and rebind time binding for check
    set bindslist [binds "*UndernetCS:Auth:AuthTimeChecker*"]
    foreach item $bindslist {
        unbind time - "[lindex $item 2]" "[lindex $item 4]"
    }
    if { $value < 10 } {
        set value "0$value"
    }
    set UndernetCS_X(AUTH_CHK_FREQUENCY) $value
    bind time - "$UndernetCS_X(AUTH_CHK_FREQUENCY) * * * *" UndernetCS:Auth:AuthTimeChecker
}

# UndernetCS:GetAuthCheckFrequency
#   Return: The value of the authentication check frequency
proc UndernetCS:GetAuthCheckFrequency {} {
    global UndernetCS_X
    return $UndernetCS_X(AUTH_CHK_FREQUENCY)
}

# UndernetCS:SetSuspendedAuthCheckFrequency 
#   Set the frequency of check when the access is suspended on 'channel'
#   to 'value'. This value means that when the access to 'channel' is
#   suspended the eggdrop check each 'value' minutes if he is already
#   suspended. In theory, this situation must not arrived !!
#   But to save the pass-band the script must managed this stupid situation.
#   Return: Nothing
proc UndernetCS:SetSuspendedAuthCheckFrequency {channel value} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    set UndernetCS_ChannelSetting($chan,AUTH_CHK_FREQUENCY_WHEN_SUSP) $value
}

proc UndernetCS:GetSuspendedAuthCheckFrequency {channel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    return $UndernetCS_ChannelSetting($chan,AUTH_CHK_FREQUENCY_WHEN_SUSP)
}
# UndernetCS:IsActived
#   Check if the script is active not not.
#   Return: 1 if active,
#           0 if inactive.
proc UndernetCS:IsActived {} {
    global UndernetCS_X
    return $UndernetCS_X(STATUS)
}

proc UndernetCS:GetWordScriptStatus {} {
    global UndernetCS_X
    if { $UndernetCS_X(STATUS) } {
        return "Enabled"
    } else {
        return "Disabled"
    }
}

# UndernetCS:SetGlobalStatus 
#   Set Global STATUS of the script to value.
#   Return: Nothing.
proc UndernetCS:SetGlobalStatus {value} {
    global UndernetCS_X
    set UndernetCS_X(STATUS) $value
}


# UndernetCS:HaveAccess
#   Check if eggdrop have an access to X for 'channel'
#   Return: 1 if have an access,
#           0 if don't have an access.
proc UndernetCS:HaveAccess {channel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    if { $UndernetCS_ChannelSetting($chan,LEVEL) == 0 } {
        return 0
    } else {
        return 1
    }
}

# UndernetCS:IsEnabled 
#   Check if 'channel' is enabled for the script.
#   Return: 1 if enabled,
#           0 if disabled.
proc UndernetCS:IsEnabled {channel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    if { $UndernetCS_ChannelSetting($chan,STATUS) == 0 } {
        return 0
    } else {
        return 1
    }
}
# UndernetCS:SetEnabled 
#   set to active 'channel' (only if there is a level > 0)
#   Return: 1 if success
#           0 on failed. (level = 0)
proc UndernetCS:SetEnabled {channel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    if { $UndernetCS_ChannelSetting($chan,LEVEL) == 0 } {
        return 0
    }
    set UndernetCS_ChannelSetting($chan,STATUS) 1
    return 1
}

# UndernetCS:SetDisabled 
#   Unactice 'channel' for the script
#   Return: Nothing.
proc UndernetCS:SetDisabled {channel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    set UndernetCS_ChannelSetting($chan,STATUS) 0
}

proc UndernetCS:SetChannelStatus {channel value} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    set UndernetCS_ChannelSetting($chan,STATUS) $value
}

proc UndernetCS:GetWordChannelStatus {channel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    if { $UndernetCS_ChannelSetting($chan,STATUS) } {
        return "Enabled"
    } else {
        return "Disabled"
    }
}


# UndernetCS:IsX
#   Return:
#       1: if nick!userhost is the Undernet Channel service Bot
#       0: if nick!userhost isn't Undernet Channel Service Bot.
proc UndernetCS:IsX {nick userhost} {
    global UndernetCS_XMask
    set mask [string tolower "${nick}!${userhost}"]
    if { $mask != $UndernetCS_XMask } {
        return 0
    } else {
        return 1
    }
}

# UndernetCS:VerifyIfExists
proc UndernetCS:VerifyIfExists {channel} {
    global UndernetCS_ChannelSetting
    set chan [string toupper $channel]
    return [info exists UndernetCS_ChannelSetting($chan,STATUS)]
}

# UndernetCS:AddChan 
#   set channel setting for 'channel' and save them to config file.
#   Return: Nothing.
proc UndernetCS:AddChan {channel} {
    global UndernetCS_ChannelSetting UndernetCS_ChannelItemList 
    set chan [string toupper $channel]
    foreach item $UndernetCS_ChannelItemList {
        set UndernetCS_ChannelSetting($chan,$item) $UndernetCS_ChannelSetting(DEFAULT,$item)
    }
    UndernetCS:IO:SaveChannelSetting $chan
}

# UndernetCS:RemChan 
#   set channel setting for 'channel' and save them to config file.
#   Return: Nothing.
proc UndernetCS:RemChan {channel} {
    global UndernetCS_ChannelSetting UndernetCS_ChannelItemList 
    set chan [string toupper $channel]
    foreach item $UndernetCS_ChannelItemList {
        unset UndernetCS_ChannelSetting($chan,$item)
    }
    UndernetCS:IO:RemoveChannelSetting $chan
}

# UndernetCS:EggdropCanSendCommand2X 
# Return: 1 if eggdrop can send command to X for 'chan'.
#         2 if eggdrop isn't authenticated to X.
#         3 if eggdrop is waiting for a auth reply from X.
#         4 if 'chan' isn't enabled.
#         5 if X isn't on 'chan'.
#         6 if the script is disabled.
#         7 if no access for $chan
proc UndernetCS:EggdropCanSendCommand2X {chan} {
    global UndernetCS_Nick

    set chan [string toupper $chan]

    if { ![UndernetCS:IsActived] } {
        return 6
    }
    if { ![UndernetCS:IsAuth] } {
        return 2
    }
    if { [UndernetCS:IsWaitingForReply] } {
        return 3
    }
    if { ![UndernetCS:IsEnabled $chan] } {
        return 4
    }
    if { ![onchan "$UndernetCS_Nick" "$chan"] } {
        return 5
    }
    if { ![UndernetCS:HaveAccess $chan] } {
	return 7
    }
    return 1
}

proc UndernetCS:Parse {str} {
    regsub -all {\[} $str {\[} str
    regsub -all {\]} $str {\]} str
    regsub -all {\{} $str {\{} str
    regsub -all {\}} $str {\}} str
    return $str
}

############ SCRIPT INIT ############
# load all UndernetCS*.tcl
source scripts/UndernetCS/UndernetCS-DCC.tcl
source scripts/UndernetCS/UndernetCS-IO.tcl
source scripts/UndernetCS/UndernetCS-IRC.tcl
source scripts/UndernetCS/UndernetCS-Cmd.tcl

proc UndernetCS:Init {{type ""}} {
    global UndernetCS_X UndernetCS_ConfFile UndernetCS_ChannelItemList
    global UndernetCS_GlobalItemList UndernetCS_ChannelSetting UndernetCS_Prompt 
    global UndernetCS_Need UndernetCS_XMask UndernetCS_Nick UndernetCS_DebugItemList
    global UndernetCS_UseNewsChecker
    # Loading config file...
    set active [UndernetCS:IsActived]
    UndernetCS:SetGlobalStatus 0
    if { [file exists $UndernetCS_ConfFile] } {
        UndernetCS:PutLog "Reading config file..." "GLOBAL" 3
        UndernetCS:IO:LoadConfigFile
    } else {
        foreach item $UndernetCS_DebugItemList {
            set UndernetCS_Debug($item) 0
        }
        # This is the first use of this script...
        putlog "---------------------------------------------------------------------"
	putlog "              Undernet Channel Service Management Script"
	putlog "   This program is distributed under the GNU General Public Licence"
	putlog "---------------------------------------------------------------------"
	putlog "This is the first use of UndernetCS*.tcl in this bot."
	putlog "See .cs command for more information to know how to configure this"
	putlog "script."
	putlog "Thank you to use this script. If you like this script, please"
	putlog "Send me a post card (for my collection)... see README file for"
	putlog "more information... or go to http://mgm.fr.st/"
	putlog "Copyright (c) 2001 RICHARD Yann. <Ze@administrateur.net>"
	putlog "---------------------------------------------------------------------"
        # Creating Directory we need for config file
        # TIPS: file mkdir command create all dir needed
        #       file mkdir blah/truc/machin create blah/, /blah/truc and
        #       /blah/truc/machin if need.
        set confdir [file dirname $UndernetCS_ConfFile]
        file mkdir $confdir
        # Creating X user account with global friend flag because eggdrop ignore
        # X's notice when UndernetCS request some things.
        set X [finduser $UndernetCS_XMask]
        if { $X == "*" } {
            if { ![validuser "$UndernetCS_Nick"] } {
                adduser "[string toupper $UndernetCS_Nick]" "$UndernetCS_XMask"
                chattr "$UndernetCS_Nick" "-ph+f|"
                setuser "$UndernetCS_Nick" "PASS" "[rand 900000000]"
            } else {
                UndernetCS:PutLog "Please create an account for $UndernetCS_Nick with this mask: $UndernetCS_XMask and with +f global flag" "GLOBAL" 1
            }
        }
        UndernetCS:IO:SaveGlobalSetting
        foreach channel [channels] {
            set chan [string toupper $channel]
            UndernetCS:AddChan "$chan"
        }
        UndernetCS:SetGlobalStatus $active
    }
    set UndernetCS_blah "\"$UndernetCS_X(AUTH_CHK_FREQUENCY) * * * *\""
    if [catch "unbind time - $UndernetCS_blah UndernetCS:Auth:AuthTimeChecker" res_catch] {
	UndernetCS:PutLog "Unbind Error: $res_catch (This error isn't a bug..)" "GLOBAL" 6
    }

    # Update for undernetcs < 0.8 ....
    if { [string length $UndernetCS_X(AUTH_CHK_FREQUENCY)] != 2 } {
        UndernetCS:SetAuthCheckFrequency [UndernetCS:GetAuthCheckFrequency]
        UndernetCS:IO:SaveGlobalSetting
    }

    bind time - "$UndernetCS_X(AUTH_CHK_FREQUENCY) * * * *" UndernetCS:Auth:AuthTimeChecker
    if [catch "source scripts/UndernetCS/UndernetCS-Need.tcl" res] {
        putlog "UndernetCS: Error when load NEED: $res"
	putlog "UndernetCS: Fix this pb and rehash"
    }
    # Init Need Section:
    foreach chan [channels] {
	set chan [string toupper $chan]
	foreach type {OP UNBAN INVITE KEY LIMIT} {
	    set UndernetCS_Need($chan,$type) 0
	}
    }
    if [catch "source scripts/UndernetCS/UndernetCS-Auth.tcl" res] {
        putlog "UndernetCS: Error when loadind Auth: $res"
	putlog "UndernetCS: Fix this pb and rehash"
    }
    if { $UndernetCS_UseNewsChecker } {
	if [catch "source scripts/UndernetCS/UndernetCS_NewsChecker.tcl" res] {
	    putlog "UndernetCS: Error when loading NewsChecker: $res"
	    putlog "UndernetCS: Fix this pb and rehash"
	}
    }
    loadhelp ../scripts/UndernetCS/UndernetCS.help
}

###
bind evnt - "loaded" UndernetCS:Init
bind evnt - "rehash" UndernetCS:Init

#set t [utimer 3 UndernetCS:Init]
#UndernetCS:PutLog "UndernetCS:Init --> $t" "GLOBAL" 3
putlog "-------------------------------------------------------------------------------"
putlog "The TeTsuYa Team Present: Undernet Channel Service Management Script."
putlog "UndernetCS is distributed under the GNU General Public Licence."
putlog "Copyright (c) 2001 RICHARD Yann."
putlog "UndernetCS V$UndernetCS_Version are loaded."
putlog "-------------------------------------------------------------------------------"
### EOF ###
