/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import org.treebind.DefaultFilterImplementation;
import org.treebind.Filter;
import org.treebind.JavaClassName;
import org.treebind.JavaMethodName;
import org.treebind.Ldap2JavaObjectPipe;
import org.treebind.LdapName;
import org.treebind.Name;
import org.treebind.Names;
import org.treebind.Util;

public class Ldap2JavaObjectFilter
extends DefaultFilterImplementation
implements Filter {
    int depth = 0;

    public Ldap2JavaObjectFilter(Ldap2JavaObjectPipe pipe) {
        super(pipe);
    }

    public void addLeaf(Name role, Name nature, Object value) throws Exception {
        block2: {
            try {
                super.addLeaf(role, nature, value);
            }
            catch (Exception e) {
                if (LdapName.DN.equals(role)) break block2;
                throw e;
            }
        }
    }

    public Name convertNature(Name role, Name nature) {
        if (Names.literal.equals(nature)) {
            return new JavaClassName("java.lang.String");
        }
        return super.convertNature(role, nature);
    }

    public Name convertRole(Name role, Name nature) {
        return this.convertRole(role.getLocalName());
    }

    private Name convertRole(String role) {
        return new JavaMethodName(Util.ToFirstUpper(role));
    }

    public void endProperty() throws Exception {
        --this.depth;
        if (this.depth > 0) {
            super.endProperty();
        } else if (this.pipe.getParameter("rootLevel") != null) {
            super.endProperty();
        }
    }

    public void startProperty(Name role, Name nature) throws Exception {
        if (this.depth == 0) {
            Object root = this.pipe.getParameter("rootLevel");
            if (root != null) {
                this.getSink().startProperty(role, new JavaClassName(root.toString()));
            }
        } else if (this.depth == 1) {
            String topLevel = (String)this.pipe.getParameter("topLevel");
            this.getSink().startProperty(this.convertRole(topLevel), new JavaClassName(topLevel));
        } else {
            super.startProperty(role, nature);
        }
        ++this.depth;
    }
}

