from Things.ThingsApp import *

class JiggleBall(Thing):
	def __init__(self ):
		Thing.__init__(self)
		self.keys  ( "#----------------#-----------------#",
				Props(sy=0.9),Props(rot=6.28),Props(sy=0.9)
				)
	def draw(self,ctx,fr):
		bos["art:ball"].draw(ctx)

class Ball(Thing):
	def __init__(self ):
		Thing.__init__(self)
		self.keys  ( "#--------#---------#", Props(sy=0.5),Props(),Props(sy=0.5))
		self.stops ( "         ^" )
		self.labels( "         ^","squishdown")

		self.add( JiggleBall() )
	def squish(self):
		self.goPlay("squishdown")

class Throw(FollowThing):
	def __init__(self ):
		FollowThing.__init__(self,"throw path")
		self.keys  (90, self.path, startAtFirstNode=False)
		ls = self.lifespan - 10
		self.funcs( " " * ls + "^        ^", self.goSquish, self.goFlip)
		self.ball=Ball()
		self.add( self.ball )
	def goSquish(self):
		self.ball.squish()
	def goFlip(self):
		self.parentThing.flip()

	def path(self,ctx):
		bos["art:swoopy"].draw(ctx)

class TwoWay(Thing):
	def __init__(self ):
		Thing.__init__(self, "two way flipper")
		self.keys  ( "##", Props(),Props(sx=-1))
		self.stops ( "^" )
		self.add( Throw() )
		self.f=False
	def flip(self):
		self.f = not(self.f)
		if self.f:
			self.goStop(2)
		else:
			self.goStop(1)
	
bos = BagOfStuff()
bos.add ( "tutorial.svg", "art")

app = AllThings ( 400, 400, speed = 30, title = "A Ball" )
app.add(TwoWay())

app.comeToLife ( )
