from Things.ThingsApp import *

class JiggleBall(Thing):
	def __init__(self ):
		Thing.__init__(self)
		self.keys  ( "#-------------#-------------#",
				Props(sy=0.9),Props(rot=6.28),Props(sy=0.9)
				)
	def draw(self,ctx,fr):
		bos["art:ball"].draw(ctx)

class Ball(Thing):
	def __init__(self ):
		Thing.__init__(self)
		self.keys  ( "#--------#---------#",
				Props(sy=0.5),Props(),Props(sy=0.5)
				)
		self.stops ( "         ^" )
		self.labels( "         ^","squishdown")

		self.add( JiggleBall() )

	def squish(self):
		self.goPlay("squishdown")

class Throw(FollowThing):
	def __init__(self ):
		FollowThing.__init__(self,"throw path")

		self.keys  (90, self.path)
		
		# Only use self.lifespan *after*
		# a call to keys!
		ls = self.lifespan - 10

		self.funcs( " " * ls + "^",self.goSquish)

		self.loops=False
		
		self.ball=Ball()
		self.add( self.ball )

	def goSquish(self):
		self.ball.squish()

	def path(self,ctx):
		bos["art:swoopy"].draw(ctx)

bos = BagOfStuff()
bos.add ( "tutorial.svg", "art")

app = AllThings ( 400, 400, speed = 90, title = "Throwing a Ball" )
app.add( Throw() )

app.comeToLife ( )




