#!/usr/bin/env python
# -*- coding: utf8 -*-

##	Things Copyright(C) 2009 Donn.C.Ingle
##
##	Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##  This file is part of Things.
##
##  Things is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  Things is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with Things.  If not, see <http://www.gnu.org/licenses/>.

"""
A simple demo of SceneThings.
"""

from Things.ThingsApp import *
from Things.Thinglets import *
from Things.BoxOfTricks import *

import math
from math import radians as d2r # degrees to radians

class Cairo(DrawThing):
	def draw(self, ctx, fr):
		BOS["CG:cairo_word"].draw(ctx)

class Scarab(Thing):
	def __init__(self):
		Thing.__init__(self)
		self.keys(  "#------#", Props(a=0),Props(a=1))
		self.stops( ".......^")
		self.labels(".......^","logo")
	def draw(self, ctx, fr):
		BOS["CG:cairo_scarab"].draw(ctx)

class FadeBox(Thing):
	def __init__(self):
		Thing.__init__(self,'fader')
		self.keys ( "#------------------------------#.", Props(y=0),Props(y=80) )
		self.stops( "................................^")


		self.linear = cairo.LinearGradient(0, 0, 0, 100)
		self.linear.add_color_stop_rgba(0, 0, 0, 0, 0)
		self.linear.add_color_stop_rgba(0.2, 0, 0,0, 1)
	
	def draw( self, ctx, fr ):
		ctx.set_source(self.linear)
		ctx.rectangle(-150,0,300,100)
		ctx.fill()

class Backdrop(Thing):
	def __init__(self):
		Thing.__init__(self,id="backdrop")
		self.keys ( "#",Props())

	def draw(self, ctx, fr):
		ctx.set_source_rgb(1, 1, 1)
		ctx.set_source_rgb(0, 0, 0)
		ctx.paint() # paint black

class IntroduceLogo(Thing):
	def __init__(self):
		Thing.__init__(self)
		#            123456789-123456789-123456789-123456789-123456789-
		self.keys ( "#===========================================#--------#=.", Props(),Props(),Props(a=0))
		self.stops( ".......................................................^")
		self.funcs( "......................................................^", app.playNextScene )

		self.add( Scarab(), parentFrame=1, globalProps=Props(y=-50), layer=100)
		self.add( Cairo(), parentFrame=10, globalProps=Props(y=25,x=-5))
		self.add( FadeBox(),parentFrame=10, layer=10, globalProps=Props(y=-25) )


RootStore = {} 

## Get a Bag of stuff
BOS = BagOfStuff()

# Add stuff to it
BOS.add("common.stuff/Comic.ttf","font")
BOS.add("cg.stuff/cairo.svg","CG")

## Get an app ref.
app = AllThings ( 600, 600, speed = 40, title = "TEST SCENES")

## Add Things to app
app.add(Backdrop())

scene1 = SceneThing()
scene2 = SceneThing()

scene1.add(IntroduceLogo())
scene1.play()

scene2.add(Scarab(),globalProps=Props(rot=2))

app.add( scene1 )
app.add( scene2 )

#app.showGrid() # optional for debugging

## My Flying-Spaghetti-Monster, it's full of stars :O
app.comeToLife ( )

