#!/usr/bin/env python
# -*- coding: utf8 -*-

from Things.ThingsApp import *

zeropos = Props()

class P(Thing):
	def __init__(self ):
		Thing.__init__(self)
		self.keys  ( "#",zeropos)
	def draw(self,ctx,fr):
		bos["foll:swoopy"].draw(ctx)
		ctx.stroke()

class Dot(Thing):
	def __init__(self ):
		Thing.__init__(self,"dot")
		self.keys  ( "#",zeropos)
		
	def draw(self,ctx,frame):
		ctx.set_source_rgb(1.0, 0.0, 0.0)
		radius = 20
		pi = 3.141
		ctx.arc(0, 0, radius / 2.0, 0, 2 * pi)
		ctx.stroke_preserve()
		ctx.fill()

class Square(Thing):
	def __init__(self ):
		Thing.__init__(self,"dot")
		self.keys  ( "#",zeropos)
		
	def draw(self,ctx,frame):
		ctx.set_source_rgb(1.0, 1.0, 0.0)
		ctx.rectangle(-5,-50,10,100)
		ctx.fill()
		return
	

class FollowPath(FollowThing):
	def __init__(self ):
		FollowThing.__init__(self,"dot")
		self.keys  (40, self.path)
		self.dot = Dot()
		self.add(self.dot)
		self.add(Square())

	def path(self,ctx):
		bos["foll:swoopy"].draw(ctx)
		
class Pulse(Thing):
	def __init__(self ):
		Thing.__init__(self)
		self.keys( "#-------------------------#----------------------------------#",Props(),Props(sz=2),Props())
		self.add( FollowPath() )
		self.add(P())


bos = BagOfStuff()
bos.add ( "follow.stuff/follow.svg", "foll")

## Setup the main app variable.
app = AllThings ( 400, 400, speed = 30, title = "TEST" )

#p = P()
#app.add(p)

app.add(Pulse())

#fp = FollowPath()
#app.add( fp, layer=0 ) #below the aliens
## Now start the app!
app.comeToLife ( )




