#!/usr/bin/env python
# -*- coding: utf8 -*-

##	Things Copyright(C) 2009 Donn.C.Ingle
##
##	Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##  This file is part of Things.
##
##  Things is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  Things is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with Things.  If not, see <http://www.gnu.org/licenses/>.


# Notes - 06 Aril 2009
from Things.ThingsApp import *
from Things.Thinglets import *
import math
import pangocairo, pango

pi=math.pi
pi2=math.pi * 2

zeropos = Props()


F={
"LoopWalk" : {
"keys"  : "#=====..............................",
"stops" : "     ^",
"labels": "......^",
"jumps" : "",
"funcs" : "",
"keyprops" : [ Props(sx=2,sy=2) ],
"labelprops":[ "hide" ]
},
"Boom" : {
"keys"  : ".#------------#============================================......................",
"stops" : "^",
"labels": "",
"jumps" : "",
"funcs" : "",
"keyprops" : [ Props(),Props(sx=2,sy=2) ]
},
"KAT" : {
"keys"  : "#------------------------------------#-------------------------------------#",
"stops" : "",
"labels": "",
"jumps" : "",
"funcs" : "",
"keyprops" : [ Props(),Props(rot=pi,sx=4,sy=4),Props(rot=pi2,sx=-1,sy=-1) ]
},
}

def zerodot(ctx):
	ctx.set_source_rgb(1.0, 1.0, 0)
	ctx.rectangle(-51, -1, 51, 1)
	ctx.fill()

class Alien1( Thing ):
	def __init__ ( self ) :
		start = Props ()
		
		Thing.__init__ ( self, "One")
		self.keys("#===...", zeropos )
		
	def draw ( self, ctx, frame ):
		BOS['rsvg:orangealien'].draw(ctx)

class Alien2( Thing ):
	def __init__ ( self) :
		start = Props ( )
		end = Props ( x=100, y=0 )
		
		Thing.__init__ ( self, "One")
		self.keys("#--------------------#--------------------#",start, end, start )
		
	def draw ( self, ctx, frame ):
		BOS['rsvg:orangealien'].draw(ctx)	

class Action(Thing):
	def __init__( self ):
		Thing.__init__( self,"ACTION")
		self.keys ('#',Props(sx=5,sy=5))
		self.stops('^')

		self.WALK = TweenLoopWalk()
		#self.WALK = LoopWalk()
		
		self.BOOM = Boom()

		self.add(self.WALK)
		self.add(self.BOOM)

class TweenLoopWalk(LoopThing):
	def __init__(self):
		LoopThing.__init__(self,"TestLoopthing")
		self.keys ( "#---#---#---#---------------------------------------------------#............................",Props(),Props(x=5),Props(x=10),Props(x=15),Props(x=50))
		self.jumps( "................................................................^",1)
		self.labels("                                                                 ^","hide")

		BOOP = BOS['rsvg:walkloop']
		self.addLoop(BOOP)
	# Don't have to use draw() here, but can if you need to.
	def draw(self,ctx,fr):
		zerodot(ctx)
		# To continue the draw, call the parent's draw method.
		LoopThing.draw(self,ctx,fr)

class LoopWalk(Thing):
	def __init__( self ):
		s = Props()
		e = Props(sx=2,sy=2)#,x=-100,y=-100)
		Thing.__init__( self,"WALK")
		d=F["LoopWalk"]
		self.keys (d["keys"], *d["keyprops"])
		self.stops(d["stops"])
		self.labels(d["labels"],*d["labelprops"])

		BOS['rsvg:walkloop'].Props( stretch = 2 )

		self.add(A1,ParentFrame=5)

	def draw(self,ctx,frame):
		BOS['rsvg:walkloop'].draw(ctx) 
		zerodot(ctx)

class Boom(Thing):
	def __init__( self ):
		Thing.__init__( self,"BOOM")
		d=F["Boom"]
		self.keys (d['keys'], *d['keyprops'])
		self.stops(d['stops'])

		BOS['rsvg:boomloop'].Props( stretch=5 ) # Due to stretch, I made more keys above for the loop to show.
	def draw(self,ctx,frame):
		BOS['rsvg:boomloop'].draw(ctx)
		zerodot(ctx)

class SpinAlien(Thing):
	def __init__(self):
		Thing.__init__(self,"ROTTER")
		self.keys("#----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------#-----------------------#",Props(y=200),Props(sx=2,sy=2,y=200),Props(y=200))
		self.stops('^')
		self.add(HA)

class HitAlien( HitThing ):
	def __init__ ( self ) :
		HitThing.__init__ ( self, "hitalien")
		self.keys("#",Props())
		
		self.mystate = False 

	def draw ( self, ctx, frame ):
		if self.mystate:
			BOS['rsvg:orangealien'].draw(ctx)
		else:
			BOS['rsvg:redalien'].draw(ctx)
		zerodot(ctx)
			
	def drawHitarea ( self, ctx, fr ):
		BOS['rsvg:alienhit'].draw(ctx)
		
	def onDrag ( self, x, y ):
		self.changeProps ( x = x, y = y, rx=x, ry=y )
	def onEnter ( self, x, y ):
		print "enter ", self.id
		self.mystate = True
	def onLeave(self,x,y):
		self.mystate=False
		print "leaving"
	def onDown ( self, x, y ): 
		print "down"

	def onRelease ( self ):
		print "released"
		A.BOOM.goPlay(2)
		A.WALK.goPlay("hide")
class BackImage(Thing):
	def __init__ ( self ) :
		Thing.__init__ ( self, "backdrop")
		d=F["KAT"]
		self.keys(d['keys'], *d['keyprops'])
	def draw(self,ctx,frame):
		BOS['aha'].draw(ctx,-300,-215)

BOS = BagOfStuff()

BOS.add("clickboom.stuff/clickboom.svg", "rsvg")
BOS.add("images.stuff/ahha.jpg","aha")

app = AllThings ( 600, 600, speed = 200, title = "TEST")

backimg = BackImage()

A1 = Alien1()
A=Action()
#A2 = Alien2()

HA = HitAlien()
SA = SpinAlien()
#L1 = LoopWalk()

#app.add( A2 )

#app.add( L1 )

app.add(backimg, layer=0)
app.add(A, layer= 1)
app.add( SA, layer = 2 )

#app.showGrid()

app.comeToLife ( )


