##	Things Copyright(C) 2009 Donn.C.Ingle
##
##	Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##  This file is part of Things.
##
##  Things is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  Things is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with Things.  If not, see <http://www.gnu.org/licenses/>.

"""
This is a collection of Thing objects.
"""

import Stack
from constants import *
import ThingsApp

class Timeline(object):
	"""
	A Timeline is a collection of Things. 
	
	@ivar parentThing: A reference to my parent.

	"""
	def __init__( self):
		self.thinglist =[]
		self.scenelist=[]
		self.scenelistindex=0

		self.ztally = 0

		self.parentThing = None
		# Use a different _tick function depending
		# on what kind of Thing this is.
		self._tick = self._defaultTick
		if isinstance(self,ThingsApp.AllThings):
			self._tick = self._mainTimeLineTick

	def add(self, thing, layer = -1, parentFrame=1, globalProps=None):
		"""
		Add a Thing to this Thing's Timeline.
		There is one Timeline per Thing, but you can add many Things to
		this Timeline.

		A layer can be supplied, larger numbers go above smaller ones.

		Use
		===
		YourThing.add( SomeOtherThing, layer=10, parentFrame = 2)

		@param thing: The Thing you want to add.
		@param layer: Layering of this thing (z-order.) 0 is the bottom.
		 The default is to draw everything overlapping on layer
		 zero. If you want to use thing.changeLayer() then make
		 sure you give things layers that are > 0.
		@param parentFrame: What frame number (in self) you want the
		 thing being added to begin playing from.
		 This is the same as padding the thing being
		 added with blanks "....#" implies it starts
		 from frame 5. So you could have "#" and set
		 parentFrame = 5 instead.
		@param globalProps: This is a Props() object. If you skip it, 
		 an ordinary Props() object is employed (position 0, alpha 1 etc.)
		 If you want to control the placement/rotation of the Thing you are
		 adding, then use this param.
		"""
		## parentFrame is the frame IN ME (I am the parent of what is
		## currently being added) that this thing should begin playing from.
		##   These two are equal:
		##   thing.keys('...#') <-three blank frames, first key at 4
		##   app.add(thing)
		##     and
		##   thing.keys('#')
		##   app.add(thing,parentFrame=4)<- no blank needed, force start @ 4
		thing.parentThing = self

		self.ztally += 1

		if globalProps:	thing.globalProps = globalProps
		
		if layer != -1:
			tup =(layer, thing, parentFrame)
		else:
			tup =(self.ztally, thing, parentFrame ) #defaults to layer 0
		self.thinglist.append(tup)
		
		self.thinglist.sort()


	## Tick one frame forward in time.
	def _mainTimeLineTick(self):
		## This is tailored for the MAIN Things TimeLine.
		## It does not need certain tests, and has only to
		## start going through its children.

		## I am trying to squeeze some speed by dropping 
		## if commands and such.

		## See defaultTick for remarks.
		for layer, thingInMe,PF in self.thinglist:
		#for sceneThing in self.scenelist:
			#print "THING:",thingInMe.id
			#print "LAYER:", layer
			tf = thingInMe._getFrameAndAdvanceFrame()	 
			if not tf.blank:
				Stack.stack._push(thingInMe,THINGSTART)
				thingInMe._tick()
				if thingInMe._isClip: Stack.stack._push(thingInMe, MASKEND)
				Stack.stack._push(thingInMe, THINGEND)   
						
	## Tick one frame forward in time.
	def _defaultTick(self):
		"""Private: Walk through my children and if they are not blank frames, _tick them."""
		## Note to self:
		## The trick with this recursion lark is to think backwards
		## from the outer leaves to the next leaves up and so on.
		##
		## Actually, it still hurts my head. I just don't know how to debug this stuff :(
		## If it works at all it's entirely up to chance.

		## The thinglist is a list of tuples: (layer, thing, parentFrame)
		for layer, thingInMe, PF in self.thinglist:
			## We need to see if the thing is "in-play" i.e. is it due?
			inplay = False
			
			if self.currentFrame.frame >= PF:
				inplay = True

			if inplay:
				tf = thingInMe._getFrameAndAdvanceFrame()	 
				## Reasoning:
				## A blank keyframe means that THIS THING is
				## NOT alive, right now, therefore NONE of its 
				## children should be ticked or pushed or anything at all.
				if not tf.blank:
					Stack.stack._push(thingInMe,THINGSTART)
					thingInMe._tick()
					if thingInMe._isClip: Stack.stack._push(thingInMe, MASKEND)
					Stack.stack._push(thingInMe, THINGEND)  
