##	Things Copyright(C) 2009 Donn.C.Ingle
##
##	Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##  This file is part of Things.
##
##  Things is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  Things is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with Things.  If not, see <http://www.gnu.org/licenses/>.
class Bugs(Exception):
    """Private: Contains and controls error messages.
    ## How to raise:
    ## raise _Bugs("BAG_ERROR", key="A")
    ## raise _Bugs("FILE_ERROR", paf="thisfile")
    """
    s = {
    'BAG_ERROR' : 
        u"You already have '%(key)s' in this bag. If this is an SVG file, check your ids.",
        
    'FILE_ERROR': 
        u"I cannot open '%(paf)s'.",
        
    'SVG_FILE_ERROR':
        u"I cannot find or open the SVG file '%(paf)s'.",
        
    'UNKNOWN_TYPE':
        u"I could not figure out what you want to load.",

    'NO_SUCH_LABEL':
        u"Could not find the label \"%(label)s\".",
    'EMPTY_LABEL_STRING':
        u"Your labels string is empty.",
        
    'EMPTY_FUNC_STRING':
        u"Your funcs string is empty.",
    'MISSING_FUNCS':
        u"There are functions missing.",
    'FUNC_ON_BLANK':
        u"Don't put functions on blank keys.",
        
    'SET_KEYFRAMES_FIRST':
        u"Make sure you set the Keys of your thing first.",
        
    'EMPTY_KEY_STRING':
        u"Your keys string cannot be empty.",

    'KEYS_NEED_STUFF':
        u"Your Keys must have stuff in them.",
     
	'GENERAL_BAD_KEYS':
		u"Check your keys, something is wrong with them.",

    'MISSING_HASH':
        u"Your key string must have a # in it",
        
    'NOT_ENOUGH_KEYS':
        u"You have more(or less) # characters than Keys.",
        
    'BAD_KEY_STRING':
        u"Check your Thing, a key cannot begin with '-' or '='.",
        
    'ENDS_IN_TWEEN':
        u"Check your Thing, it cannot end in a tween.",
        
    'BAD_KEY_COMBO':
        u"Check your Thing, you have a bad combination(%(test)s at character %(pos)i).",

    'MISSING_LABELS':
        u"Check your labels, there's a problem.",
    
    'EMPTY_STOP_STRING':
        u"Your stop string is empty.",
        
    'NO_STOPS_FOUND':
        u"There were no ^ chars in your stop string.",

    'EMPTY_JUMP_STRING':
        u"Your jump string is empty.",

    'MISSING_JUMP_TARGETS':
        u"Check your Jump command, there's a problem.",
    
    'BAD_PROPS':
        u"I can't find those props in myself.",
        
    'CANNOT_MAKE_FONTS_FOLDER':
        u"For some reason, I cannot make a .fonts folder\nin your home directory.",
        
    'GTK_ALREADY_LOADED':
        u"I cannot install new fonts if GTK+ is already loaded.\nPlease move your BagOStuff add before Things gets instantiated.",
        
    'NO_FC-LIST':
        u"I cannot find fc-list on your system. Please install fontconfig.",
        
    'GREP_FAILED':
        u"Either grep has failed or it's not installed.",
        
    'CANT_FIND_KEY':
        u"I cannot find the key: %(key)s.",
        
    'RSVG_WITHOUT_HANDLE':
        u"You have not opened this SVG with rsvgOnly = True.",
        
    'BAD_SVG_PATH':
        u"Error in path id: %(id)s. My SVG path code is very limited.\nMake sure you convert your objects to paths in Inkscape.",

    'BAD_SVG_STYLE':
        u"Error in style id: %(id)s. My SVG style code is very limited.\nMake sure you don't use any gradients--only simple fills and outlines.",
        
    'SVG_PATH_ID_DUPLICATE':
        u"The id: %(id)s has been found twice. Edit your SVG file and make each id unique.",
        
    'BAD_SVG_FILE':
        u"I cannot make any sense of: %(paf)s.\nThere may be exotic and somewhat fruity layer names...\nPlease see help(BagOfStuff.add)",
        
    'CANT_RUN_ME':
        u"This is the Things module, it does not run by itself.",

	'BUTTON_THING_CANNOT_HAVE_KEYS':
		u"A ButtonThing can't use the keys() method. Wrap it in another Thing if you want to.",
	
	'BUTTONTHING_MISSING_STATES':
		u"Your ButtonThing.addStates() is missing something. Use 'normal','down','up' and 'over'",

	'BUTTONTHING_BAD_STATE_KEYS':
		u"Your ButtonThing.addStates() requires these keys:'normal','down','up' and 'over'",

	'LOOPTHING_MISMATCH':
		u"Your LoopThing's frames and your key frames do not match. They must be *at least* equal in number.",
	
	'CANNOT_START_SCENE':
		u"You can't start that scene number.",
	
	'FOLLOWTHING_NEEDS_FRAMES':
		u"Your FollowThing needs a number of frames greater than zero.",
	
	'FOLLOWTHING_NEEDS_A_PATH_FUNCTION':
		u"Your FollowThing needs a function that draws a path of some kind.",
	
	'FOLLOW_PATH_NEEDS_MORE_NODES':
		u"Your FollowThing's path needs more nodes. It has %(has)s and you asked for %(want)s.\nThis is tricky voodoo; try simply asking for more frames.",

	'CANT_WRITE_FILE':
		u"I can't write to %(file)s. Is there a directory in there? Does it exist?",

	'CANT_EXPORT_TYPE':
		u"I can't export %(type)s files.",
    }
    def __init__( self, bugkey, **args):
        self.message = "\n\n" + self.s[bugkey] % args + "\n"
    def __str__( self ):
        return str(self.message)
    
