/* $Id: teebutest.c 670 2006-05-14 16:08:09Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <stdlib.h>
#include <check.h>
#include "logging.h"
#include "test_cmdline.h"
#include "check_io.h"
#include "check_iobuffer.h"
#include "check_darray.h"
#include "check_deque.h"
#include "check_list.h"
#include "check_hashtable.h"
#include "check_path.h"
#include "check_terminatedint.h"
#include "check_nullio.h"
#include "check_baseio.h"
#include "check_unixio.h"
#include "check_debugio.h"
#include "check_statio.h"
#include "check_selfsyncio.h"
#include "check_remarkio.h"
#include "check_bufferio.h"
#include "check_commandprocess.h"
#include "check_commandfilterio.h"
#include "check_fixedlenio.h"
#include "check_catio.h"
#include "check_gzipio.h"
#include "check_gpgio.h"
#include "check_bzip2io.h"
#include "check_infpipeio.h"
#include "check_teeio.h"
#include "check_stringio.h"
#include "check_md5sumio.h"
#include "check_simulateerrorio.h"
#include "check_sha1sumio.h"
#include "check_datapairstore.h"
#include "check_filestore.h"
#include "check_uidcache.h"

Suite *
teebu_suite (struct gengetopt_args_info *args_info)
{
  Suite *s = suite_create ("teebu");

  if ((args_info->off_flag && args_info->iobuffer_flag)
      || (!args_info->off_flag && !args_info->iobuffer_flag))
    add_iobuffer_tests (s);

  if ((args_info->off_flag && args_info->deque_flag)
      || (!args_info->off_flag && !args_info->deque_flag))
    add_deque_tests (s);

  if ((args_info->off_flag && args_info->list_flag)
      || (!args_info->off_flag && !args_info->list_flag))
    add_list_tests (s);

  if ((args_info->off_flag && args_info->hashtable_flag)
      || (!args_info->off_flag && !args_info->hashtable_flag))
    add_hashtable_tests (s);

  if ((args_info->off_flag && args_info->darray_flag)
      || (!args_info->off_flag && !args_info->darray_flag))
    add_darray_tests (s);

  if ((args_info->off_flag && args_info->path_flag)
      || (!args_info->off_flag && !args_info->path_flag))
    add_path_tests (s);

  if ((args_info->off_flag && args_info->terminatedint_flag)
      || (!args_info->off_flag && !args_info->terminatedint_flag))
    add_terminatedint_tests (s);

  if ((args_info->off_flag && args_info->nullio_flag)
      || (!args_info->off_flag && !args_info->nullio_flag))
    add_nullio_tests (s);

  if ((args_info->off_flag && args_info->baseio_flag)
      || (!args_info->off_flag && !args_info->baseio_flag))
    add_baseio_tests (s);

  if ((args_info->off_flag && args_info->unixio_flag)
      || (!args_info->off_flag && !args_info->unixio_flag))
    add_unixio_tests (s);

  if ((args_info->off_flag && args_info->debugio_flag)
      || (!args_info->off_flag && !args_info->debugio_flag))
    add_debugio_tests (s);

  if ((args_info->off_flag && args_info->statio_flag)
      || (!args_info->off_flag && !args_info->statio_flag))
    add_statio_tests (s);

  if ((args_info->off_flag && args_info->selfsyncio_flag)
      || (!args_info->off_flag && !args_info->selfsyncio_flag))
    add_selfsyncio_tests (s);

  if ((args_info->off_flag && args_info->remarkio_flag)
      || (!args_info->off_flag && !args_info->remarkio_flag))
    add_remarkio_tests (s);

  if ((args_info->off_flag && args_info->bufferio_flag)
      || (!args_info->off_flag && !args_info->bufferio_flag))
    add_bufferio_tests (s);

  if ((args_info->off_flag && args_info->commandprocess_flag)
      || (!args_info->off_flag && !args_info->commandprocess_flag))
    add_commandprocess_tests (s);

  if ((args_info->off_flag && args_info->commandfilterio_flag)
      || (!args_info->off_flag && !args_info->commandfilterio_flag))
    add_commandfilterio_tests (s);

  if ((args_info->off_flag && args_info->catio_flag)
      || (!args_info->off_flag && !args_info->catio_flag))
    add_catio_tests (s);

  if ((args_info->off_flag && args_info->gzipio_flag)
      || (!args_info->off_flag && !args_info->gzipio_flag))
    add_gzipio_tests (s);

  if ((args_info->off_flag && args_info->bzip2io_flag)
      || (!args_info->off_flag && !args_info->bzip2io_flag))
    add_bzip2io_tests (s);

  if ((args_info->off_flag && args_info->gpgio_flag)
      || (!args_info->off_flag && !args_info->gpgio_flag))
    add_gpgio_tests (s);

  if ((args_info->off_flag && args_info->infpipeio_flag)
      || (!args_info->off_flag && !args_info->infpipeio_flag))
    add_infpipeio_tests (s);

  if ((args_info->off_flag && args_info->teeio_flag)
      || (!args_info->off_flag && !args_info->teeio_flag))
    add_teeio_tests (s);

  if ((args_info->off_flag && args_info->stringio_flag)
      || (!args_info->off_flag && !args_info->stringio_flag))
    add_stringio_tests (s);

  if ((args_info->off_flag && args_info->md5sumio_flag)
      || (!args_info->off_flag && !args_info->md5sumio_flag))
    add_md5sumio_tests (s);

  if ((args_info->off_flag && args_info->simulateerrorio_flag)
      || (!args_info->off_flag && !args_info->simulateerrorio_flag))
    add_simulateerrorio_tests (s);

  if ((args_info->off_flag && args_info->sha1sumio_flag)
      || (!args_info->off_flag && !args_info->sha1sumio_flag))
    add_sha1sumio_tests (s);

  if ((args_info->off_flag && args_info->datapairstore_flag)
      || (!args_info->off_flag && !args_info->datapairstore_flag))
    add_datapairstore_tests (s);

  if ((args_info->off_flag && args_info->fixedlenio_flag)
      || (!args_info->off_flag && !args_info->fixedlenio_flag))
    add_fixedlenio_tests (s);

  if ((args_info->off_flag && args_info->filestore_flag)
      || (!args_info->off_flag && !args_info->filestore_flag))
    add_filestore_tests (s);

  if ((args_info->off_flag && args_info->uidcache_flag)
      || (!args_info->off_flag && !args_info->uidcache_flag))
    add_uidcache_tests (s);

  return s;
}

int
main (int argc, char **argv)
{
  struct gengetopt_args_info args_info;

  init_logging (stderr, WARNING);

  /* let's call our cmdline parser */
  if (cmdline_parser (argc, argv, &args_info) != 0)
    exit (1);

  if (args_info.long_flag)
    set_test_size (LONG_TEST);

  int nf;
  Suite *s = teebu_suite (&args_info);
  SRunner *sr = srunner_create (s);

  if (args_info.verbose_flag)
    srunner_run_all (sr, CK_VERBOSE);
  else
    srunner_run_all (sr, CK_NORMAL);

  nf = srunner_ntests_failed (sr);
  srunner_free (sr);
  return (nf == 0) ? EXIT_SUCCESS : EXIT_FAILURE;
}
