/* $Id: check_uidcache.c 673 2006-05-14 18:18:15Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include <string.h>

#include "uidcache.h"

#include "check_uidcache.h"

START_TEST (check_basic)
{
  uidcache_t cache = create_uidcache ();
  fail_if (!cache);

  const char *name = lookup_username_from_uid (cache, 0) ;
  fail_unless (0 == strcmp ("root", name));

  uid_t uid;
  fail_unless (lookup_uid_from_username (cache, "root", &uid));
  fail_unless (0 == uid);

  const char *group = lookup_groupname_from_gid (cache, 0);
  fail_if (!group);
  gid_t gid = 1;
  fail_unless (lookup_gid_from_groupname (cache, group, &gid));
  fail_unless (0 == gid);
  release_uidcache (cache);
}
END_TEST

void
add_uidcache_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("UIDCache");
  tcase_add_test (tc_core, check_basic);
  suite_add_tcase (s, tc_core);
}

