/* $Id: check_terminatedint.c 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <stdio.h>

#include "terminatedint.h"

#include "check_terminatedint.h"

static void
check_uint32 (const uint32_t x)
{
  char buffer[UINT32_MAX_BYTES];
  for (int i = 0; i < UINT32_MAX_BYTES; i++)
    buffer[i] = 0;

  char *optr = &buffer[0];

  uint32_t x1 = x;
  while (encode_uint32_byte (optr++, &x1))
    ;                           // Do nothing

  char *iptr = &buffer[0];
  int pos = 0;
  uint32_t x2 = 0;
  while (decode_uint32_byte (&x2, pos++, iptr++))
    ;                           // Do nothing

  // Garbage out == garbage in?
  if (x != x2)
    {
      char msg_buffer[128];
      sprintf (msg_buffer, "Expected %d but got %d", x, x2);
      fail (msg_buffer);
    }
}

START_TEST (check_uint32_0)
{
  check_uint32 (0);
}

END_TEST
START_TEST (check_uint32_1)
{
  check_uint32 (1);
}

END_TEST
START_TEST (check_uint32_127)
{
  check_uint32 (127);
}

END_TEST
START_TEST (check_uint32_128)
{
  check_uint32 (128);
}

END_TEST
START_TEST (check_uint32_16383)
{
  check_uint32 (16383);
}

END_TEST
START_TEST (check_uint32_16384)
{
  check_uint32 (16384);
}

END_TEST
START_TEST (check_uint32_2097151)
{
  check_uint32 (2097151);
}

END_TEST
START_TEST (check_uint32_2097152)
{
  check_uint32 (2097152);
}

END_TEST
START_TEST (check_uint32_268435455)
{
  check_uint32 (268435455);
}

END_TEST
START_TEST (check_uint32_268435456)
{
  check_uint32 (268435456);
}

END_TEST
START_TEST (check_uint32_4294967295)
{
  check_uint32 (4294967295);
}
END_TEST static void
check_uint64 (const uint64_t x)
{
  char buffer[UINT64_MAX_BYTES];
  for (int i = 0; i < UINT64_MAX_BYTES; i++)
    buffer[i] = 0;

  char *optr = &buffer[0];

  uint64_t x1 = x;
  while (encode_uint64_byte (optr++, &x1))
    ;                           // Do nothing

  char *iptr = &buffer[0];
  int pos = 0;
  uint64_t x2 = 0;
  while (decode_uint64_byte (&x2, pos++, iptr++))
    ;                           // Do nothing

  // Garbage out == garbage in?
  if (x != x2)
    {
      char msg_buffer[128];
      sprintf (msg_buffer, "Expected %" PRIu64 " but got %" PRIu64, x, x2);
      fail (msg_buffer);
    }
}

START_TEST (check_uint64_0)
{
  check_uint64 (0);
}

END_TEST
START_TEST (check_uint64_1)
{
  check_uint64 (1);
}

END_TEST
START_TEST (check_uint64_127)
{
  check_uint64 (127);
}

END_TEST
START_TEST (check_uint64_128)
{
  check_uint64 (128);
}

END_TEST
START_TEST (check_uint64_16383)
{
  check_uint64 (16383);
}

END_TEST
START_TEST (check_uint64_16384)
{
  check_uint64 (16384);
}

END_TEST
START_TEST (check_uint64_2097151)
{
  check_uint64 (2097151);
}

END_TEST
START_TEST (check_uint64_2097152)
{
  check_uint64 (2097152);
}

END_TEST
START_TEST (check_uint64_268435455)
{
  check_uint64 (268435455);
}

END_TEST
START_TEST (check_uint64_268435456)
{
  check_uint64 (268435456);
}

END_TEST
START_TEST (check_uint64_4294967295)
{
  check_uint64 (4294967295);
}

END_TEST
START_TEST (check_uint64_4294967296)
{
  check_uint64 (4294967296);
}

END_TEST
START_TEST (check_uint64_18446744073709551615)
{
  check_uint64 (18446744073709551615UL);
}
END_TEST void
add_terminatedint_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("TerminatedInt");
  tcase_add_test (tc_core, check_uint32_0);
  tcase_add_test (tc_core, check_uint32_1);
  tcase_add_test (tc_core, check_uint32_127);
  tcase_add_test (tc_core, check_uint32_128);
  tcase_add_test (tc_core, check_uint32_16383);
  tcase_add_test (tc_core, check_uint32_16384);
  tcase_add_test (tc_core, check_uint32_2097151);
  tcase_add_test (tc_core, check_uint32_2097152);
  tcase_add_test (tc_core, check_uint32_268435455);
  tcase_add_test (tc_core, check_uint32_268435456);
  tcase_add_test (tc_core, check_uint32_4294967295);
  tcase_add_test (tc_core, check_uint64_0);
  tcase_add_test (tc_core, check_uint64_1);
  tcase_add_test (tc_core, check_uint64_127);
  tcase_add_test (tc_core, check_uint64_128);
  tcase_add_test (tc_core, check_uint64_16383);
  tcase_add_test (tc_core, check_uint64_16384);
  tcase_add_test (tc_core, check_uint64_2097151);
  tcase_add_test (tc_core, check_uint64_2097152);
  tcase_add_test (tc_core, check_uint64_268435455);
  tcase_add_test (tc_core, check_uint64_268435456);
  tcase_add_test (tc_core, check_uint64_4294967295);
  tcase_add_test (tc_core, check_uint64_4294967296);
  tcase_add_test (tc_core, check_uint64_18446744073709551615);
  suite_add_tcase (s, tc_core);
}
