/* $Id: check_teeio.c 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "baseio.h"
#include "teeio.h"
#include "check_io.h"
#include "check_baseio.h"

#define TEST_FILE_BASE     "/tmp/bumtest.teeio.0.tmp"
#define TEST_FILE_OUT_COPY "/tmp/bumtest.teeio.1.tmp"
#define TEST_FILE_IN_COPY  "/tmp/bumtest.teeio.2.tmp"

static int
read_write_test_size ()
{
  switch (get_test_size ())
    {
    case QUICK_TEST:
      return 256;
    case NORMAL_TEST:
      return 1024;
    case LONG_TEST:
      return 10240;
    default:
      fail ("Invalid test size");
      return -1;                // Not reached, prevent compiler warning
    }
}

static void
check_read_write (int block_size)
{
  const int
    test_size = read_write_test_size (), count = test_size / block_size;

  assert (count > 0);
  assert (test_size > 0);

  out_stream_t out_base = baseio_open_out (TEST_FILE_BASE, "w");
  fail_if (!out_base);
  out_stream_t out_copy = baseio_open_out (TEST_FILE_OUT_COPY, "w");
  fail_if (!out_copy);

  out_stream_t outs = teeio_open_out (out_base, true, out_copy, true);
  fail_if (!outs);

  ascending_output_half_test (false, outs, block_size, count);
  release_out (outs);

  mark_point ();

  {
    in_stream_t in_base = baseio_open_in (TEST_FILE_BASE, "r");
    fail_if (!in_base);
    out_stream_t in_copy = baseio_open_out (TEST_FILE_IN_COPY, "w");
    fail_if (!in_copy);

    in_stream_t ins = teeio_open_in (in_base, true, in_copy, true);
    fail_if (!ins);
    ascending_input_half_test (true, false, ins, block_size, count);
    release_in (ins);
  }

  mark_point ();

  {
    in_stream_t copy = baseio_open_in (TEST_FILE_OUT_COPY, "r");
    fail_if (!copy);

    ascending_input_half_test (true, false, copy, block_size, count);
    release_in (copy);
  }
  mark_point ();

  {
    in_stream_t copy = baseio_open_in (TEST_FILE_IN_COPY, "r");
    fail_if (!copy);

    ascending_input_half_test (true, false, copy, block_size, count);
    release_in (copy);
  }
}

START_TEST (check_read_write_small_blocks)
{
  check_read_write (1);
}

END_TEST
START_TEST (check_read_write_medium_blocks)
{
  check_read_write (32);
}

END_TEST
START_TEST (check_read_write_large_blocks)
{
  check_read_write (256);
}
END_TEST void
add_teeio_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("TeeIO");
  tcase_add_test (tc_core, check_read_write_small_blocks);
  tcase_add_test (tc_core, check_read_write_medium_blocks);
  tcase_add_test (tc_core, check_read_write_large_blocks);

  suite_add_tcase (s, tc_core);
}
