/* $Id: check_io.c 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <stdio.h>
#include <stdio.h>
#include <check.h>
#include <alloca.h>
#include <assert.h>

#include "check_io.h"

static test_size_t test_size = NORMAL_TEST;

test_size_t
get_test_size ()
{
  return test_size;
}

void
set_test_size (test_size_t size)
{
  test_size = size;
}

/* Check we can do some output, and that stream closes properly. */
void
basic_out_test (out_stream_t outs)
{
  const int BUF_SIZE = 128, DATA_SIZE = 8;
  char test_data[DATA_SIZE];

  for (int i = 0; i < DATA_SIZE; i++)
    test_data[i] = i;

  iobuffer_t *iobuf = create_iobuffer (BUF_SIZE);
  fail_if (!iobuf);

  fail_unless (iobuffer_add_data (iobuf, test_data, DATA_SIZE));
  fail_unless (iobuffer_data_size (iobuf) > 0);

  fail_unless_out_status (OUTPUT_OK, output (outs, iobuf));

  fail_unless_out_status (OUTPUT_OK, close_out (outs));
  fail_unless_out_status (OUTPUT_ERR_CLOSED, close_out (outs));

}

/* Write some blocks of data to the given stream.  Each blocks contains
 * ascending ints.  This is only half a test... find the corresponding input
 * channel  and call ascending_input_half_test to check the data got correctly
 * written. */
void
ascending_output_half_test (bool write_marks, out_stream_t outs, const int
                            data_size, const int repeats)
{

  char test_data[data_size];

  for (int i = 0; i < data_size; i++)
    test_data[i] = (char) i;

  iobuffer_t *iobuf = create_iobuffer (data_size);
  fail_if (!iobuf);

  for (int j = 0; j < repeats; j++)
    {
      fail_unless (iobuffer_add_data (iobuf, test_data, data_size));
      fail_unless_out_status (OUTPUT_OK, output_all (outs, iobuf));
      fail_unless (0 == iobuffer_data_size (iobuf));

      if (write_marks)
        fail_unless_out_status (OUTPUT_OK, output_mark (outs));
    }

  free_iobuffer (iobuf);

  fail_unless_out_status (OUTPUT_OK, close_out (outs));
}

/** Verfy data written by ascending_output_half_test is correct. */
void
ascending_input_half_test (bool check_eof, bool read_marks, in_stream_t ins,
                           const int data_size, const int repeats)
{
  iobuffer_t *iobuf = create_iobuffer (data_size);
  fail_if (!iobuf);

  mark_point ();

  for (int i = 0; i < repeats; i++)
    {
      // printf("i = %d\n", i) ;
      fail_unless_in_status (INPUT_OK, input_all (ins, iobuf));
      fail_unless ((data_size == iobuffer_data_size (iobuf)));

      for (int j = 0; j < data_size; j++)
        {
          // printf("j = %d\n", j) ;
          fail_unless ((char) j == *iobuffer_data_pointer (iobuf));
          iobuffer_mark_taken (iobuf, 1);
        }

      if (read_marks)
        {
          fail_unless_in_status (INPUT_MARK, input (ins, iobuf));
          // assert(INPUT_MARK == input(ins, iobuf)) ;
          fail_unless_in_status (INPUT_OK, input_mark (ins));
        }
    }

  if (check_eof)
    fail_unless_in_status (INPUT_EOF, input (ins, iobuf));

  fail_unless_out_status (INPUT_OK, close_in (ins));
}
