/* $Id: simulateerrorio.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifndef SIMULATEERRORIO_H
#define SIMULATEERRORIO_H

#include <stdlib.h>
#include <stdbool.h>
#include "nonstdio.h"

typedef struct
{
  off_t failure_position;
  bool failure_report;
  size_t failure_bytes_lost;
  size_t failure_bytes_garbage;
} failure_mode_t;

/* parse a string in the format "pos:rep:lost:garb", where all fields are
 * numbers except rep, which is either 't' or 'f'.  Eg "0:f:0:0" or "128:t:8:4"
 */
bool parse_failure_mode (const char *, failure_mode_t *);

/* open an input stream which reads from the given input stream, but simulates
 * the error described by the failure_mode_t. If the final bool is true, the
 * base input stream will be released when the returned error stream is
 * released. */
in_stream_t simulateerrorio_open_in (failure_mode_t *, in_stream_t, bool);

#endif
