/* $Id: rng.c 721 2006-06-01 19:38:29Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/


#define STATE_SIZE  (sizeof (unsigned int))

#include <sys/time.h>
#include <time.h>

#include "nonstdio.h"
#include "baseio.h"
#include "logging.h"

static bool state_inited = false;

static void init_state ()
{
  in_stream_t random = baseio_open_in("/dev/urandom", "r");
  if (random)
    {
      LOG (DEBUG, "Using primary random initialisation method");
      char random_state[STATE_SIZE];
      iobuffer_t iobuf;
      init_iobuffer_with(&iobuf, STATE_SIZE, 0, random_state);
      if (INPUT_OK != input_all (random, &iobuf))
        {
          FATAL("Unabled to read randomness");
        }
      unsigned int seed = 0;
      for (int i = 0; i < STATE_SIZE; i++)
        {
          seed <<= 8;
          seed |= random_state[i];
        }
      srandom (seed);
      close_and_release_in (random);
    }
  else
    {
      LOG (DEBUG, "Using fallback random initialisation method");
      srandom (time (NULL));
    }
  state_inited = true;
}

unsigned long int
random_long ()
{
  if (!state_inited)
    init_state ();

  return random ();
}

